/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.creaking_expanded.mixin;

import com.belgie.creaking_expanded.registry.MobEffectRegistry;
import com.belgie.creaking_expanded.util.CustomOptions;
import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.buffers.Std140Builder;
import com.mojang.blaze3d.systems.RenderSystem;
import java.nio.ByteBuffer;
import net.minecraft.client.Camera;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MappableRingBuffer;
import net.minecraft.client.renderer.fog.FogData;
import net.minecraft.client.renderer.fog.FogRenderer;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.joml.Vector4f;
import org.joml.Vector4fc;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={FogRenderer.class})
public class FogRendererMixin {
    @Shadow
    @Final
    private MappableRingBuffer regularBuffer;

    @Unique
    private Vector4f creakingExpanded$computeFogColor(Camera camera, float partialTick, ClientLevel level, int renderDistance, float darkenWorldAmount) {
        float gray = 0.4f;
        return new Vector4f(gray, gray, gray, 1.0f);
    }

    @Inject(method={"setupFog"}, at={@At(value="HEAD")}, cancellable=true)
    public void setupFog(Camera camera, int renderDistance, DeltaTracker deltaTracker, float darkenWorldAmount, ClientLevel level, CallbackInfoReturnable<Vector4f> cir) {
        LivingEntity living;
        float f = deltaTracker.getGameTimeDeltaPartialTick(false);
        Vector4f vector4f = this.creakingExpanded$computeFogColor(camera, f, level, renderDistance, darkenWorldAmount);
        FogData data = new FogData();
        float f1 = renderDistance * 16;
        Entity entity = camera.entity();
        if (entity instanceof LivingEntity && (living = (LivingEntity)entity).hasEffect((Holder)MobEffectRegistry.FOGGY.getHolder().get())) {
            CustomOptions.MobEffectFogFunction fogenvironment = new CustomOptions.MobEffectFogFunction();
            fogenvironment.setupFog(data, camera, level, f1, deltaTracker);
            GpuBuffer.MappedView gpubuffer$mappedview = RenderSystem.getDevice().createCommandEncoder().mapBuffer(this.regularBuffer.currentBuffer(), false, true);
            data.renderDistanceStart = 0.0f;
            data.renderDistanceEnd = 10.0f;
            data.environmentalStart = 0.0f;
            data.environmentalEnd = 10.0f;
            this.creakingExpanded$updateBuffer(gpubuffer$mappedview.data(), 0, vector4f, data.environmentalStart, data.environmentalEnd, data.renderDistanceStart, data.renderDistanceEnd, data.skyEnd, data.cloudEnd);
            cir.setReturnValue((Object)vector4f);
        }
    }

    @Unique
    private void creakingExpanded$updateBuffer(ByteBuffer buffer, int position, Vector4f fogColor, float environmentalStart, float environmentalEnd, float renderDistanceStart, float renderDistanceEnd, float skyEnd, float cloudEnd) {
        buffer.position(position);
        Std140Builder.intoBuffer((ByteBuffer)buffer).putVec4((Vector4fc)fogColor).putFloat(environmentalStart).putFloat(environmentalEnd).putFloat(renderDistanceStart).putFloat(renderDistanceEnd).putFloat(skyEnd).putFloat(cloudEnd);
    }
}

