/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.creaking_expanded.registry;

import com.belgie.creaking_expanded.entity.CreakingGolem;
import com.belgie.creaking_expanded.entity.PaleCreeperEntity;
import com.belgie.creaking_expanded.entity.PaleEyeEntity;
import com.belgie.creaking_expanded.entity.PaleSkeletonEntity;
import com.belgie.creaking_expanded.entity.PaleSpiderEntity;
import com.belgie.creaking_expanded.entity.PaleZombieEntity;
import com.belgie.creaking_expanded.entity.SpriteEntity;
import com.belgie.creaking_expanded.entity.SpritelingEntity;
import com.belgie.creaking_expanded.variants.AncientSpriteVariant;
import com.belgie.creaking_expanded.variants.CreakingGuardVariant;
import com.belgie.creaking_expanded.variants.PaleCreeperVariant;
import com.belgie.creaking_expanded.variants.PaleEyeVariant;
import com.belgie.creaking_expanded.variants.PaleSkeletonVariant;
import com.belgie.creaking_expanded.variants.PaleSpiderVariant;
import com.belgie.creaking_expanded.variants.PaleZombieVariant;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.event.entity.SpawnPlacementRegisterEvent;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;

public class EntityRegistry {
    public static final DeferredRegister<EntityType<?>> ENTITY = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"creaking_expanded");
    public static final DeferredRegister<EntityDataSerializer<?>> DATA = DeferredRegister.create((DeferredRegister.RegistryHolder)ForgeRegistries.ENTITY_DATA_SERIALIZERS, (String)"creaking_expanded");
    public static final Supplier<EntityDataSerializer<SpriteEntity.State>> SNIFFER_STATE = DATA.register("sprite_state", () -> EntityDataSerializer.forValueType(SpriteEntity.State.STREAM_CODEC));
    public static final Supplier<EntityType<CreakingGolem>> FRIENDLY_CREAKING = ENTITY.register("creaking_guard", () -> EntityType.Builder.of(CreakingGolem::new, (MobCategory)MobCategory.MONSTER).noSummon().fireImmune().sized(0.6f, 2.7f).eyeHeight(2.3f).clientTrackingRange(8).build(ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (Identifier)Identifier.fromNamespaceAndPath((String)"creaking_expanded", (String)"creaking_guard"))));
    public static final Supplier<EntityType<PaleEyeEntity>> PALE_EYE = ENTITY.register("pale_eye", () -> EntityType.Builder.of(PaleEyeEntity::new, (MobCategory)MobCategory.MONSTER).fireImmune().canSpawnFarFromPlayer().sized(1.0f, 1.0f).eyeHeight(1.25f).clientTrackingRange(10).build(ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (Identifier)Identifier.fromNamespaceAndPath((String)"creaking_expanded", (String)"pale_eye"))));
    public static final Supplier<EntityType<SpriteEntity>> ANCIENT_SPRITE = ENTITY.register("ancient_sprite", () -> EntityType.Builder.of(SpriteEntity::new, (MobCategory)MobCategory.MONSTER).fireImmune().sized(2.0f, 2.8f).eyeHeight(1.8f).clientTrackingRange(8).build(ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (Identifier)Identifier.fromNamespaceAndPath((String)"creaking_expanded", (String)"ancient_sprite"))));
    public static final Supplier<EntityType<PaleCreeperEntity>> PALE_CREEPER = ENTITY.register("pale_creeper", () -> EntityType.Builder.of(PaleCreeperEntity::new, (MobCategory)MobCategory.MONSTER).sized(0.6f, 1.7f).eyeHeight(1.4f).clientTrackingRange(10).build(ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (Identifier)Identifier.fromNamespaceAndPath((String)"creaking_expanded", (String)"pale_creeper"))));
    public static final Supplier<EntityType<SpritelingEntity>> SPITELING = ENTITY.register("spriteling", () -> EntityType.Builder.of(SpritelingEntity::new, (MobCategory)MobCategory.CREATURE).sized(1.0f, 1.4f).eyeHeight(0.8f).clientTrackingRange(10).build(ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (Identifier)Identifier.fromNamespaceAndPath((String)"creaking_expanded", (String)"spriteling"))));
    public static final Supplier<EntityType<PaleSpiderEntity>> PALE_SPIDER = ENTITY.register("garden_spider", () -> EntityType.Builder.of(PaleSpiderEntity::new, (MobCategory)MobCategory.MONSTER).sized(1.4f, 0.9f).eyeHeight(0.65f).passengerAttachments(new float[]{0.765f}).clientTrackingRange(8).build(ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (Identifier)Identifier.fromNamespaceAndPath((String)"creaking_expanded", (String)"garden_spider"))));
    public static final Supplier<EntityType<PaleSkeletonEntity>> PALE_SKELETON = ENTITY.register("cloaked", () -> EntityType.Builder.of(PaleSkeletonEntity::new, (MobCategory)MobCategory.MONSTER).sized(0.6f, 1.99f).eyeHeight(1.74f).ridingOffset(-0.7f).clientTrackingRange(8).build(ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (Identifier)Identifier.fromNamespaceAndPath((String)"creaking_expanded", (String)"cloaked"))));
    public static final Supplier<EntityType<PaleZombieEntity>> PALE_ZOMBIE = ENTITY.register("overgrowth", () -> EntityType.Builder.of(PaleZombieEntity::new, (MobCategory)MobCategory.MONSTER).sized(0.6f, 1.95f).eyeHeight(1.74f).passengerAttachments(new float[]{2.0125f}).ridingOffset(-0.7f).clientTrackingRange(8).build(ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (Identifier)Identifier.fromNamespaceAndPath((String)"creaking_expanded", (String)"overgrowth"))));
    public static final Supplier<EntityDataSerializer<Holder<AncientSpriteVariant>>> ANCIENT_SPRITE_VARIANT = DATA.register("ancient_sprite_variant", () -> EntityDataSerializer.forValueType(AncientSpriteVariant.STREAM_CODEC));
    public static final Supplier<EntityDataSerializer<Holder<CreakingGuardVariant>>> CREAKING_GOLEM_VARIANT = DATA.register("creaking_golem_variant", () -> EntityDataSerializer.forValueType(CreakingGuardVariant.STREAM_CODEC));
    public static final Supplier<EntityDataSerializer<Holder<PaleEyeVariant>>> PALE_EYE_VARIANT = DATA.register("pale_eye_variant", () -> EntityDataSerializer.forValueType(PaleEyeVariant.STREAM_CODEC));
    public static final Supplier<EntityDataSerializer<Holder<PaleCreeperVariant>>> PALE_CREEPER_VARIANT = DATA.register("pale_creeper_variant", () -> EntityDataSerializer.forValueType(PaleCreeperVariant.STREAM_CODEC));
    public static final Supplier<EntityDataSerializer<Holder<PaleSkeletonVariant>>> PALE_SKELETON_VARIANT = DATA.register("cloaked_variant", () -> EntityDataSerializer.forValueType(PaleSkeletonVariant.STREAM_CODEC));
    public static final Supplier<EntityDataSerializer<Holder<PaleSpiderVariant>>> PALE_SPIDER_VARIANT = DATA.register("garden_spider_variant", () -> EntityDataSerializer.forValueType(PaleSpiderVariant.STREAM_CODEC));
    public static final Supplier<EntityDataSerializer<Holder<PaleZombieVariant>>> PALE_ZOMBIE_VARIANT = DATA.register("overgrowth_variant", () -> EntityDataSerializer.forValueType(PaleZombieVariant.STREAM_CODEC));

    @Mod.EventBusSubscriber(modid="creaking_expanded")
    public static class EntityPlacements {
        @SubscribeEvent
        public static void Attributes(SpawnPlacementRegisterEvent e) {
            e.register(PALE_CREEPER.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::checkMonsterSpawnRules, SpawnPlacementRegisterEvent.Operation.AND);
            e.register(PALE_SPIDER.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::checkMonsterSpawnRules, SpawnPlacementRegisterEvent.Operation.AND);
            e.register(PALE_SKELETON.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::checkMonsterSpawnRules, SpawnPlacementRegisterEvent.Operation.AND);
            e.register(PALE_ZOMBIE.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::checkMonsterSpawnRules, SpawnPlacementRegisterEvent.Operation.AND);
        }
    }
}

