/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.creaking_expanded.util;

import com.belgie.creaking_expanded.registry.MobEffectRegistry;
import net.minecraft.client.Camera;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.fog.FogData;
import net.minecraft.client.renderer.fog.environment.MobEffectFogEnvironment;
import net.minecraft.core.Holder;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.api.distmarker.OnlyIns;

public class CustomOptions {
    public static final OptionInstance<Boolean> PALE_GARDEN_FOG = OptionInstance.createBoolean((String)"options.paleGardenFog", (boolean)true);

    public OptionInstance<Boolean> paleGardenFog() {
        return PALE_GARDEN_FOG;
    }

    @OnlyIns(value={@OnlyIn(value=Dist.CLIENT), @OnlyIn(value=Dist.CLIENT)})
    public static class MobEffectFogFunction
    extends MobEffectFogEnvironment {
        public void setupFog(FogData fogData, Camera camera, ClientLevel clientLevel, float v, DeltaTracker deltaTracker) {
            LivingEntity livingentity;
            MobEffectInstance mobeffectinstance;
            Entity entity = camera.entity();
            if (entity instanceof LivingEntity && (mobeffectinstance = (livingentity = (LivingEntity)entity).getEffect(this.getMobEffect())) != null) {
                float f = Mth.lerp((float)mobeffectinstance.getBlendFactor(livingentity, deltaTracker.getGameTimeDeltaPartialTick(false)), (float)v, (float)15.0f);
                fogData.environmentalStart = f * 0.75f;
                fogData.environmentalEnd = f;
                fogData.skyEnd = f;
                fogData.cloudEnd = f;
            }
        }

        public Holder<MobEffect> getMobEffect() {
            return (Holder)MobEffectRegistry.FOGGY.getHolder().get();
        }

        public float getModifiedDarkness(LivingEntity p_423586_, float p_423483_, float p_423558_) {
            MobEffectInstance mobeffectinstance = p_423586_.getEffect(this.getMobEffect());
            return mobeffectinstance != null ? Math.max(mobeffectinstance.getBlendFactor(p_423586_, p_423558_), p_423483_) : p_423483_;
        }
    }
}

