/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.creaking_expanded;

import com.belgie.creaking_expanded.Config;
import com.belgie.creaking_expanded.blockentity.ResinCampfireRenderer;
import com.belgie.creaking_expanded.entity.CreakingGolem;
import com.belgie.creaking_expanded.entity.PaleCreeperEntity;
import com.belgie.creaking_expanded.entity.PaleEyeEntity;
import com.belgie.creaking_expanded.entity.PaleSkeletonEntity;
import com.belgie.creaking_expanded.entity.PaleSpiderEntity;
import com.belgie.creaking_expanded.entity.PaleZombieEntity;
import com.belgie.creaking_expanded.entity.SpriteEntity;
import com.belgie.creaking_expanded.entity.SpritelingEntity;
import com.belgie.creaking_expanded.entity.model.AncientSpriteModel;
import com.belgie.creaking_expanded.entity.model.CreakingGuardModel;
import com.belgie.creaking_expanded.entity.model.PaleCreeperModel;
import com.belgie.creaking_expanded.entity.model.PaleEyeModel;
import com.belgie.creaking_expanded.entity.model.PaleSpiderModel;
import com.belgie.creaking_expanded.entity.model.PaleZombieModel;
import com.belgie.creaking_expanded.entity.model.SpritelingModel;
import com.belgie.creaking_expanded.entity.renderer.AncientSpriteRenderer;
import com.belgie.creaking_expanded.entity.renderer.FriendlyCreakingRenderer;
import com.belgie.creaking_expanded.entity.renderer.PaleCreeperRenderer;
import com.belgie.creaking_expanded.entity.renderer.PaleEyeRenderer;
import com.belgie.creaking_expanded.entity.renderer.PaleSkeletonRenderer;
import com.belgie.creaking_expanded.entity.renderer.PaleSpiderRenderer;
import com.belgie.creaking_expanded.entity.renderer.PaleZombieRenderer;
import com.belgie.creaking_expanded.entity.renderer.SpritelingRenderer;
import com.belgie.creaking_expanded.registry.BlockEntityRegistry;
import com.belgie.creaking_expanded.registry.BlockRegistry;
import com.belgie.creaking_expanded.registry.EntityRegistry;
import com.belgie.creaking_expanded.registry.ItemRegistry;
import com.belgie.creaking_expanded.registry.MapDecorRegistry;
import com.belgie.creaking_expanded.registry.MenuRegistry;
import com.belgie.creaking_expanded.registry.MobEffectRegistry;
import com.belgie.creaking_expanded.registry.ModEvents;
import com.belgie.creaking_expanded.registry.ModGamerules;
import com.belgie.creaking_expanded.registry.ParticleRegistry;
import com.belgie.creaking_expanded.registry.RecipeRegistry;
import com.belgie.creaking_expanded.registry.VariantsRegistry;
import com.mojang.logging.LogUtils;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.slf4j.Logger;

@Mod(value="creaking_expanded")
public class CreakingExpanded {
    public static final String MODID = "creaking_expanded";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"creaking_expanded");
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> EXAMPLE_TAB = CREATIVE_MODE_TABS.register("creaking_expanded_tab", () -> CreativeModeTab.builder().title((Component)Component.translatable((String)"itemGroup.creaking_expanded_tab")).icon(() -> ((Block)BlockRegistry.SIGHT_BLOCK.get()).asItem().getDefaultInstance()).displayItems((parameters, output) -> {
        for (DeferredHolder item : ItemRegistry.ITEMS.getEntries()) {
            output.accept((ItemLike)item.get());
        }
    }).build());
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> WOOD_BLOCKS = CREATIVE_MODE_TABS.register("creaking_expanded_wood_tab", () -> CreativeModeTab.builder().title((Component)Component.translatable((String)"itemGroup.creaking_expanded_wood_tab")).icon(() -> ((Block)BlockRegistry.PETRIFIED_OAK_LOG.get()).asItem().getDefaultInstance()).displayItems((parameters, output) -> {
        for (DeferredHolder item : ItemRegistry.WOODS.getEntries()) {
            output.accept((ItemLike)((Item)item.get()).asItem());
        }
    }).build());

    public CreakingExpanded(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(VariantsRegistry::registerDatapackRegistries);
        BlockRegistry.BLOCKS.register(modEventBus);
        ItemRegistry.ITEMS.register(modEventBus);
        ItemRegistry.WOODS.register(modEventBus);
        ModGamerules.RULE.register(modEventBus);
        CREATIVE_MODE_TABS.register(modEventBus);
        MenuRegistry.MENU.register(modEventBus);
        ParticleRegistry.PARTICLE.register(modEventBus);
        BlockEntityRegistry.BLOCK_ENTITY.register(modEventBus);
        MobEffectRegistry.EFFECT.register(modEventBus);
        MobEffectRegistry.POTION.register(modEventBus);
        EntityRegistry.ENTITY.register(modEventBus);
        EntityRegistry.DATA.register(modEventBus);
        RecipeRegistry.RECIPE.register(modEventBus);
        RecipeRegistry.RECIPE_S.register(modEventBus);
        MapDecorRegistry.DECOR.register(modEventBus);
        NeoForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(this::handleRegisterMenuScreens);
        modEventBus.addListener(this::addCreative);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            NeoForge.EVENT_BUS.addListener(ModEvents::ItemClick);
            NeoForge.EVENT_BUS.addListener(ModEvents::Living);
            NeoForge.EVENT_BUS.addListener(ModEvents::SleepingEvent);
            NeoForge.EVENT_BUS.addListener(ModEvents::StopPhantomsInPaleGarden);
            NeoForge.EVENT_BUS.addListener(ModEvents::BrewingEvent);
            NeoForge.EVENT_BUS.addListener(ModEvents::WanderingEvent);
        });
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.INGREDIENTS) {
            event.insertAfter(new ItemStack((ItemLike)Items.BOLT_ARMOR_TRIM_SMITHING_TEMPLATE), new ItemStack((ItemLike)ItemRegistry.CREAK_ARMOR_TRIM_SMITHING_TEMPLATE.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(new ItemStack((ItemLike)Items.GUSTER_BANNER_PATTERN), new ItemStack((ItemLike)ItemRegistry.CREAK_BANNER_PATTERN.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(new ItemStack((ItemLike)ItemRegistry.CREAK_BANNER_PATTERN.get()), new ItemStack((ItemLike)ItemRegistry.SPRITE_BANNER_PATTERN.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(new ItemStack((ItemLike)ItemRegistry.SPRITE_BANNER_PATTERN.get()), new ItemStack((ItemLike)ItemRegistry.WATCHER_BANNER_PATTERN.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(new ItemStack((ItemLike)ItemRegistry.WATCHER_BANNER_PATTERN.get()), new ItemStack((ItemLike)ItemRegistry.WATCHER_BASIC_BANNER_PATTERN.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(new ItemStack((ItemLike)Items.RESIN_CLUMP), new ItemStack((ItemLike)BlockRegistry.DRIED_RESIN_CLUMP.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(new ItemStack((ItemLike)Items.RESIN_BRICK), new ItemStack((ItemLike)ItemRegistry.DRIED_RESIN_BRICK.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(new ItemStack((ItemLike)Items.PHANTOM_MEMBRANE), new ItemStack((ItemLike)ItemRegistry.CRACKED_RESIN.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        }
        if (event.getTabKey() == CreativeModeTabs.NATURAL_BLOCKS) {
            event.insertAfter(new ItemStack((ItemLike)Items.JACK_O_LANTERN), new ItemStack((ItemLike)BlockRegistry.SOUL_JACK_O_LANTERN.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(new ItemStack((ItemLike)BlockRegistry.SOUL_JACK_O_LANTERN.get()), new ItemStack((ItemLike)BlockRegistry.PALE_PUMPKIN.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(new ItemStack((ItemLike)BlockRegistry.PALE_PUMPKIN.get()), new ItemStack((ItemLike)BlockRegistry.CARVED_PALE_PUMPKIN.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(new ItemStack((ItemLike)BlockRegistry.CARVED_PALE_PUMPKIN.get()), new ItemStack((ItemLike)BlockRegistry.PALE_JACK_O_LANTERN.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(new ItemStack((ItemLike)BlockRegistry.PALE_JACK_O_LANTERN.get()), new ItemStack((ItemLike)BlockRegistry.SOUL_PALE_JACK_O_LANTERN.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(new ItemStack((ItemLike)Items.DEAD_BUSH), new ItemStack((ItemLike)ItemRegistry.DUSK_BERRIES.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(new ItemStack((ItemLike)ItemRegistry.DUSK_BERRIES.get()), new ItemStack((ItemLike)ItemRegistry.DAWN_BERRIES.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(new ItemStack((ItemLike)Items.SNIFFER_EGG), new ItemStack((ItemLike)BlockRegistry.SPRITELING_EGG.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(new ItemStack((ItemLike)Items.SPORE_BLOSSOM), new ItemStack((ItemLike)BlockRegistry.NIGHTBLOSSOM.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(new ItemStack((ItemLike)Items.OPEN_EYEBLOSSOM), new ItemStack((ItemLike)BlockRegistry.STABLE_CLOSED_EYEBLOSSOM.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(new ItemStack((ItemLike)BlockRegistry.STABLE_CLOSED_EYEBLOSSOM.get()), new ItemStack((ItemLike)BlockRegistry.STABLE_OPEN_EYEBLOSSOM.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(new ItemStack((ItemLike)BlockRegistry.STABLE_OPEN_EYEBLOSSOM.get()), new ItemStack((ItemLike)BlockRegistry.CLOSED_EYESHROOM.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(new ItemStack((ItemLike)BlockRegistry.CLOSED_EYESHROOM.get()), new ItemStack((ItemLike)BlockRegistry.OPEN_EYESHROOM.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(new ItemStack((ItemLike)BlockRegistry.OPEN_EYESHROOM.get()), new ItemStack((ItemLike)BlockRegistry.STABLE_CLOSED_EYESHROOM.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(new ItemStack((ItemLike)BlockRegistry.STABLE_CLOSED_EYESHROOM.get()), new ItemStack((ItemLike)BlockRegistry.STABLE_OPEN_EYESHROOM.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(new ItemStack((ItemLike)Items.RESIN_BLOCK), new ItemStack((ItemLike)BlockRegistry.RESIN_STAIRS.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(new ItemStack((ItemLike)BlockRegistry.RESIN_STAIRS.get()), new ItemStack((ItemLike)BlockRegistry.RESIN_SLAB.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(new ItemStack((ItemLike)BlockRegistry.RESIN_SLAB.get()), new ItemStack((ItemLike)BlockRegistry.DRIED_RESIN_BLOCK.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(new ItemStack((ItemLike)BlockRegistry.DRIED_RESIN_BLOCK.get()), new ItemStack((ItemLike)BlockRegistry.DRIED_RESIN_STAIRS.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(new ItemStack((ItemLike)BlockRegistry.DRIED_RESIN_STAIRS.get()), new ItemStack((ItemLike)BlockRegistry.DRIED_RESIN_SLAB.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(new ItemStack((ItemLike)Items.RED_MUSHROOM_BLOCK), new ItemStack((ItemLike)BlockRegistry.PALE_MUSHROOM_BLOCK.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(new ItemStack((ItemLike)BlockRegistry.PALE_MUSHROOM_BLOCK.get()), new ItemStack((ItemLike)BlockRegistry.CREAKING_MUSHROOM_BLOCK.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(new ItemStack((ItemLike)Items.PUMPKIN_SEEDS), new ItemStack((ItemLike)ItemRegistry.PALE_PUMPKIN_SEEDS.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        }
        if (event.getTabKey() == CreativeModeTabs.BUILDING_BLOCKS) {
            event.insertAfter(new ItemStack((ItemLike)Items.CHISELED_RESIN_BRICKS), new ItemStack((ItemLike)BlockRegistry.DRIED_RESIN_BRICKS.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(new ItemStack((ItemLike)BlockRegistry.DRIED_RESIN_BRICKS.get()), new ItemStack((ItemLike)BlockRegistry.DRIED_RESIN_BRICK_STAIRS.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(new ItemStack((ItemLike)BlockRegistry.DRIED_RESIN_BRICK_STAIRS.get()), new ItemStack((ItemLike)BlockRegistry.DRIED_RESIN_BRICK_SLAB.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(new ItemStack((ItemLike)BlockRegistry.DRIED_RESIN_BRICK_SLAB.get()), new ItemStack((ItemLike)BlockRegistry.DRIED_RESIN_BRICK_WALL.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(new ItemStack((ItemLike)BlockRegistry.DRIED_RESIN_BRICK_WALL.get()), new ItemStack((ItemLike)BlockRegistry.DRIED_CHISELED_RESIN_BRICKS.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(new ItemStack((ItemLike)Items.MOSSY_COBBLESTONE_WALL), new ItemStack((ItemLike)BlockRegistry.PALE_MOSSY_COBBLESTONE.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(new ItemStack((ItemLike)BlockRegistry.PALE_MOSSY_COBBLESTONE.get()), new ItemStack((ItemLike)BlockRegistry.PALE_MOSSY_COBBLESTONE_STAIRS.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(new ItemStack((ItemLike)BlockRegistry.PALE_MOSSY_COBBLESTONE_STAIRS.get()), new ItemStack((ItemLike)BlockRegistry.PALE_MOSSY_COBBLESTONE_SLAB.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(new ItemStack((ItemLike)BlockRegistry.PALE_MOSSY_COBBLESTONE_SLAB.get()), new ItemStack((ItemLike)BlockRegistry.PALE_MOSSY_COBBLESTONE_WALL.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(new ItemStack((ItemLike)Items.MOSSY_STONE_BRICK_WALL), new ItemStack((ItemLike)BlockRegistry.PALE_MOSSY_STONE_BRICKS.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(new ItemStack((ItemLike)BlockRegistry.PALE_MOSSY_STONE_BRICKS.get()), new ItemStack((ItemLike)BlockRegistry.PALE_MOSSY_STONE_BRICK_STAIRS.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(new ItemStack((ItemLike)BlockRegistry.PALE_MOSSY_STONE_BRICK_STAIRS.get()), new ItemStack((ItemLike)BlockRegistry.PALE_MOSSY_STONE_BRICK_SLAB.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(new ItemStack((ItemLike)BlockRegistry.PALE_MOSSY_STONE_BRICK_SLAB.get()), new ItemStack((ItemLike)BlockRegistry.PALE_MOSSY_STONE_BRICK_WALL.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        }
        if (event.getTabKey() == CreativeModeTabs.FUNCTIONAL_BLOCKS) {
            event.insertAfter(new ItemStack((ItemLike)Items.REDSTONE_TORCH), new ItemStack((ItemLike)BlockRegistry.RESIN_TORCH.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(new ItemStack((ItemLike)Items.SOUL_LANTERN), new ItemStack((ItemLike)BlockRegistry.RESIN_LANTERN.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(new ItemStack((ItemLike)Items.SOUL_CAMPFIRE), new ItemStack((ItemLike)BlockRegistry.RESIN_CAMPFIRE.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        }
        if (event.getTabKey() == CreativeModeTabs.FOOD_AND_DRINKS) {
            event.insertAfter(new ItemStack((ItemLike)Items.PUMPKIN_PIE), new ItemStack((ItemLike)ItemRegistry.PALE_PUMPKIN_PIE.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        }
        if (event.getTabKey() == CreativeModeTabs.TOOLS_AND_UTILITIES) {
            event.insertAfter(new ItemStack((ItemLike)Items.TADPOLE_BUCKET), new ItemStack((ItemLike)ItemRegistry.SPRITELING_BUCKET.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        }
        if (event.getTabKey() == CreativeModeTabs.SPAWN_EGGS) {
            event.insertAfter(new ItemStack((ItemLike)Items.PARCHED_SPAWN_EGG), new ItemStack((ItemLike)ItemRegistry.PALE_SKELETON_SPAWN_EGG.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(new ItemStack((ItemLike)Items.SPIDER_SPAWN_EGG), new ItemStack((ItemLike)ItemRegistry.PALE_SPIDER_SPAWN_EGG.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(new ItemStack((ItemLike)Items.STRAY_SPAWN_EGG), new ItemStack((ItemLike)ItemRegistry.PALE_ZOMBIE_SPAWN_EGG.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(new ItemStack((ItemLike)Items.CREAKING_SPAWN_EGG), new ItemStack((ItemLike)ItemRegistry.PALE_EYE_SPAWN_EGG.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(new ItemStack((ItemLike)ItemRegistry.PALE_EYE_SPAWN_EGG.get()), new ItemStack((ItemLike)ItemRegistry.PALE_CREEPER_SPAWN_EGG.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(new ItemStack((ItemLike)Items.SNIFFER_SPAWN_EGG), new ItemStack((ItemLike)ItemRegistry.ANCIENT_SPRITE_SPAWN_EGG.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(new ItemStack((ItemLike)ItemRegistry.ANCIENT_SPRITE_SPAWN_EGG.get()), new ItemStack((ItemLike)ItemRegistry.SPRITELING_SPAWN_EGG.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        }
        if (event.getTabKey() == CreativeModeTabs.REDSTONE_BLOCKS) {
            event.insertAfter(new ItemStack((ItemLike)Items.OBSERVER), new ItemStack((ItemLike)BlockRegistry.SIGHT_BLOCK.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        }
    }

    private void handleRegisterMenuScreens(RegisterMenuScreensEvent event) {
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
    }

    @EventBusSubscriber(modid="creaking_expanded")
    public static class Register {
        @SubscribeEvent
        public static void registerAttributes(EntityAttributeCreationEvent event) {
            event.put(EntityRegistry.FRIENDLY_CREAKING.get(), CreakingGolem.createAttributes().build());
            event.put(EntityRegistry.PALE_EYE.get(), PaleEyeEntity.createAttributes().build());
            event.put(EntityRegistry.ANCIENT_SPRITE.get(), SpriteEntity.createAttributes().build());
            event.put(EntityRegistry.PALE_CREEPER.get(), PaleCreeperEntity.createAttributes().build());
            event.put(EntityRegistry.SPITELING.get(), SpritelingEntity.createAttributes().build());
            event.put(EntityRegistry.PALE_SPIDER.get(), PaleSpiderEntity.createAttributes().build());
            event.put(EntityRegistry.PALE_SKELETON.get(), PaleSkeletonEntity.createAttributes().build());
            event.put(EntityRegistry.PALE_ZOMBIE.get(), PaleZombieEntity.createAttributes().build());
        }
    }

    @EventBusSubscriber(modid="creaking_expanded", value={Dist.CLIENT})
    public static class EntityBits {
        public static final ModelLayerLocation CREAKING_GUARD = new ModelLayerLocation(Identifier.fromNamespaceAndPath((String)"creaking_expanded", (String)"creaking_guard"), "main");
        public static final ModelLayerLocation PALE_EYE = new ModelLayerLocation(Identifier.fromNamespaceAndPath((String)"creaking_expanded", (String)"pale_eye"), "main");
        public static final ModelLayerLocation ANCIENT_SPRITE = new ModelLayerLocation(Identifier.fromNamespaceAndPath((String)"creaking_expanded", (String)"ancient_sprite"), "main");
        public static final ModelLayerLocation CREAKING_GUARD_ARMOR = new ModelLayerLocation(Identifier.fromNamespaceAndPath((String)"creaking_expanded", (String)"creaking_guard_armor"), "main");
        public static final ModelLayerLocation PALE_CREEPER = new ModelLayerLocation(Identifier.fromNamespaceAndPath((String)"creaking_expanded", (String)"pale_creeper"), "main");
        public static final ModelLayerLocation PALE_CREEPER_SHIELD = new ModelLayerLocation(Identifier.fromNamespaceAndPath((String)"creaking_expanded", (String)"pale_creeper_shield"), "main");
        public static final ModelLayerLocation SPRITELING = new ModelLayerLocation(Identifier.fromNamespaceAndPath((String)"creaking_expanded", (String)"spriteling"), "main");
        public static final ModelLayerLocation PALE_SPIDER = new ModelLayerLocation(Identifier.fromNamespaceAndPath((String)"creaking_expanded", (String)"pale_spider"), "main");
        public static final ModelLayerLocation PALE_ZOMBIE = new ModelLayerLocation(Identifier.fromNamespaceAndPath((String)"creaking_expanded", (String)"pale_zombie"), "main");

        @SubscribeEvent
        public static void registerEntityRenders(EntityRenderersEvent.RegisterRenderers event) {
            event.registerEntityRenderer(EntityRegistry.FRIENDLY_CREAKING.get(), FriendlyCreakingRenderer::new);
            event.registerEntityRenderer(EntityRegistry.PALE_EYE.get(), PaleEyeRenderer::new);
            event.registerEntityRenderer(EntityRegistry.ANCIENT_SPRITE.get(), AncientSpriteRenderer::new);
            event.registerEntityRenderer(EntityRegistry.PALE_CREEPER.get(), PaleCreeperRenderer::new);
            event.registerEntityRenderer(EntityRegistry.SPITELING.get(), SpritelingRenderer::new);
            event.registerEntityRenderer(EntityRegistry.PALE_SPIDER.get(), PaleSpiderRenderer::new);
            event.registerEntityRenderer(EntityRegistry.PALE_SKELETON.get(), PaleSkeletonRenderer::new);
            event.registerEntityRenderer(EntityRegistry.PALE_ZOMBIE.get(), PaleZombieRenderer::new);
        }

        @SubscribeEvent
        public static void registerEntityModels(EntityRenderersEvent.RegisterLayerDefinitions event) {
            event.registerLayerDefinition(PALE_EYE, PaleEyeModel::createBodyLayer);
            event.registerLayerDefinition(CREAKING_GUARD, CreakingGuardModel::createMesh);
            event.registerLayerDefinition(ANCIENT_SPRITE, AncientSpriteModel::createBodyLayer);
            event.registerLayerDefinition(CREAKING_GUARD_ARMOR, CreakingGuardModel::createArmorMesh);
            event.registerLayerDefinition(PALE_CREEPER, () -> PaleCreeperModel.createBodyLayer(new CubeDeformation(0.0f)));
            event.registerLayerDefinition(PALE_CREEPER_SHIELD, () -> PaleCreeperModel.createBodyLayer(new CubeDeformation(2.0f)));
            event.registerLayerDefinition(SPRITELING, SpritelingModel::createBodyLayer);
            event.registerLayerDefinition(PALE_SPIDER, PaleSpiderModel::createBodyLayer);
            event.registerLayerDefinition(PALE_ZOMBIE, PaleZombieModel::createBodyLayer);
        }
    }

    @EventBusSubscriber(modid="creaking_expanded", value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            BlockEntityRenderers.register(BlockEntityRegistry.RESIN_CAMPFIRE.get(), ResinCampfireRenderer::new);
        }
    }
}

