/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.creaking_expanded.blocks;

import com.belgie.creaking_expanded.registry.BlockRegistry;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.TrailParticleOption;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TriState;
import net.minecraft.world.Difficulty;
import net.minecraft.world.attribute.EnvironmentAttributes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.animal.bee.Bee;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.level.BlockGrowFeatureEvent;

public class EyeShroomBlock
extends FlowerBlock
implements BonemealableBlock {
    public static final MapCodec<EyeShroomBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.fieldOf("open").forGetter(block -> block.type.open), (App)ResourceKey.codec((ResourceKey)Registries.CONFIGURED_FEATURE).fieldOf("feature").forGetter(p_304931_ -> p_304931_.feature), (App)EyeShroomBlock.propertiesCodec()).apply((Applicative)instance, EyeShroomBlock::new));
    private static final int EYEBLOSSOM_XZ_RANGE = 3;
    private static final int EYEBLOSSOM_Y_RANGE = 2;
    private final Type type;
    private final ResourceKey<ConfiguredFeature<?, ?>> feature;
    protected static final VoxelShape SHAPE = Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)6.0, (double)11.0);

    public MapCodec<? extends EyeShroomBlock> codec() {
        return CODEC;
    }

    public EyeShroomBlock(Type p_382834_, ResourceKey<ConfiguredFeature<?, ?>> feature, BlockBehaviour.Properties p_383158_) {
        super(p_382834_.effect, p_382834_.effectDuration, p_383158_);
        this.type = p_382834_;
        this.feature = feature;
    }

    public EyeShroomBlock(boolean p_383090_, ResourceKey<ConfiguredFeature<?, ?>> feature, BlockBehaviour.Properties p_382887_) {
        super(Type.fromBoolean((boolean)p_383090_).effect, Type.fromBoolean((boolean)p_383090_).effectDuration, p_382887_);
        this.type = Type.fromBoolean(p_383090_);
        this.feature = feature;
    }

    public void animateTick(BlockState p_382850_, Level p_382933_, BlockPos p_382838_, RandomSource p_383190_) {
        BlockState blockstate;
        if (this.type.emitSounds() && p_383190_.nextInt(700) == 0 && (blockstate = p_382933_.getBlockState(p_382838_.below())).is(Blocks.PALE_MOSS_BLOCK)) {
            p_382933_.playLocalSound((double)p_382838_.getX(), (double)p_382838_.getY(), (double)p_382838_.getZ(), SoundEvents.EYEBLOSSOM_IDLE, SoundSource.BLOCKS, 1.0f, 1.0f, false);
        }
    }

    protected void randomTick(BlockState p_382824_, ServerLevel p_382831_, BlockPos p_382957_, RandomSource p_382888_) {
        if (this.tryChangingState(p_382824_, p_382831_, p_382957_, p_382888_)) {
            p_382831_.playSound((Entity)((Player)null), p_382957_, this.type.transform().longSwitchSound, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        super.randomTick(p_382824_, p_382831_, p_382957_, p_382888_);
    }

    protected void tick(BlockState p_382808_, ServerLevel p_383005_, BlockPos p_383211_, RandomSource p_383088_) {
        if (this.tryChangingState(p_382808_, p_383005_, p_383211_, p_383088_)) {
            p_383005_.playSound((Entity)((Player)null), p_383211_, this.type.transform().shortSwitchSound, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        super.tick(p_382808_, p_383005_, p_383211_, p_383088_);
    }

    private boolean tryChangingState(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        boolean flag = ((TriState)level.environmentAttributes().getValue(EnvironmentAttributes.EYEBLOSSOM_OPEN, pos)).toBoolean(this.type.open);
        if (flag == this.type.open) {
            return false;
        }
        Type eyeblossomblock$type = this.type.transform();
        level.setBlock(pos, eyeblossomblock$type.state(), 3);
        level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((BlockState)state));
        eyeblossomblock$type.spawnTransformParticle(level, pos, random);
        BlockPos.betweenClosed((BlockPos)pos.offset(-3, -2, -3), (BlockPos)pos.offset(3, 2, 3)).forEach(p_383198_ -> {
            BlockState blockstate = level.getBlockState(p_383198_);
            if (blockstate == state) {
                double d0 = Math.sqrt(pos.distSqr((Vec3i)p_383198_));
                int i = random.nextIntBetweenInclusive((int)(d0 * 5.0), (int)(d0 * 10.0));
                level.scheduleTick(p_383198_, state.getBlock(), i);
            }
        });
        return true;
    }

    public boolean growMushroom(ServerLevel level, BlockPos pos, BlockState state, RandomSource random) {
        Optional<Holder> optional = level.registryAccess().lookupOrThrow(Registries.CONFIGURED_FEATURE).get(this.feature);
        BlockGrowFeatureEvent event = EventHooks.fireBlockGrowFeature((LevelAccessor)level, (RandomSource)random, (BlockPos)pos, (Holder)optional.orElse(null));
        if (event.isCanceled()) {
            return false;
        }
        optional = Optional.ofNullable(event.getFeature());
        if (optional.isEmpty()) {
            return false;
        }
        level.removeBlock(pos, false);
        if (((ConfiguredFeature)optional.get().value()).place((WorldGenLevel)level, level.getChunkSource().getGenerator(), random, pos)) {
            return true;
        }
        level.setBlock(pos, state, 3);
        return false;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Vec3 vec3 = state.getOffset(pos);
        return SHAPE.move(vec3.x, vec3.y, vec3.z);
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        return true;
    }

    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return (double)random.nextFloat() < 0.4;
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        this.growMushroom(level, pos, state, random);
    }

    protected void entityInside(BlockState p_382817_, Level p_383060_, BlockPos p_383146_, Entity p_383054_, InsideBlockEffectApplier effectApplier, boolean intersects) {
        if (!p_383060_.isClientSide() && p_383060_.getDifficulty() != Difficulty.PEACEFUL && p_383054_ instanceof Bee) {
            Bee bee = (Bee)p_383054_;
            if (Bee.attractsBees((BlockState)p_382817_) && !bee.hasEffect(MobEffects.POISON)) {
                bee.addEffect(this.getBeeInteractionEffect());
            }
        }
    }

    public MobEffectInstance getBeeInteractionEffect() {
        return new MobEffectInstance(MobEffects.POISON, 25);
    }

    public static enum Type {
        OPEN(true, MobEffects.BLINDNESS, 11.0f, SoundEvents.EYEBLOSSOM_OPEN_LONG, SoundEvents.EYEBLOSSOM_OPEN, 16545810),
        CLOSED(false, MobEffects.NAUSEA, 7.0f, SoundEvents.EYEBLOSSOM_CLOSE_LONG, SoundEvents.EYEBLOSSOM_CLOSE, 0x5F5F5F);

        final boolean open;
        final Holder<MobEffect> effect;
        final float effectDuration;
        final SoundEvent longSwitchSound;
        final SoundEvent shortSwitchSound;
        private final int particleColor;

        private Type(boolean p_383223_, Holder p_383070_, float p_382883_, SoundEvent p_383157_, SoundEvent p_383205_, int p_383152_) {
            this.open = p_383223_;
            this.effect = p_383070_;
            this.effectDuration = p_382883_;
            this.longSwitchSound = p_383157_;
            this.shortSwitchSound = p_383205_;
            this.particleColor = p_383152_;
        }

        public Block block() {
            return this.open ? (Block)BlockRegistry.OPEN_EYESHROOM.get() : (Block)BlockRegistry.CLOSED_EYESHROOM.get();
        }

        public BlockState state() {
            return this.block().defaultBlockState();
        }

        public Type transform() {
            return Type.fromBoolean(!this.open);
        }

        public boolean emitSounds() {
            return this.open;
        }

        public static Type fromBoolean(boolean p_382912_) {
            return p_382912_ ? OPEN : CLOSED;
        }

        public void spawnTransformParticle(ServerLevel p_383084_, BlockPos p_383042_, RandomSource p_382825_) {
            Vec3 vec3 = p_383042_.getCenter();
            double d0 = 0.5 + p_382825_.nextDouble();
            Vec3 vec31 = new Vec3(p_382825_.nextDouble() - 0.5, p_382825_.nextDouble() + 1.0, p_382825_.nextDouble() - 0.5);
            Vec3 vec32 = vec3.add(vec31.scale(d0));
            TrailParticleOption trailparticleoption = new TrailParticleOption(vec32, this.particleColor, (int)(20.0 * d0));
            p_383084_.sendParticles((ParticleOptions)trailparticleoption, vec3.x, vec3.y, vec3.z, 1, 0.0, 0.0, 0.0, 0.0);
        }

        public SoundEvent longSwitchSound() {
            return this.longSwitchSound;
        }
    }
}

