/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.creaking_expanded.entity;

import com.belgie.creaking_expanded.entity.AI.PaleSwellGoal;
import com.belgie.creaking_expanded.registry.BlockRegistry;
import com.belgie.creaking_expanded.registry.EntityRegistry;
import com.belgie.creaking_expanded.registry.VariantsRegistry;
import com.belgie.creaking_expanded.variants.PaleCreeperVariant;
import com.belgie.creaking_expanded.variants.PaleCreeperVariants;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.TrailParticleOption;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.Identifier;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.feline.Cat;
import net.minecraft.world.entity.animal.feline.Ocelot;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.variant.VariantUtils;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.level.BlockGrowFeatureEvent;

public class PaleCreeperEntity
extends Monster {
    private static final EntityDataAccessor<Integer> DATA_SWELL_DIR;
    private static final EntityDataAccessor<Boolean> DATA_IS_POWERED;
    private static final EntityDataAccessor<Boolean> DATA_IS_IGNITED;
    private static final EntityDataAccessor<Holder<PaleCreeperVariant>> DATA_VARIANT_ID;
    private int oldSwell;
    private int swell;
    private int maxSwell = 30;
    private int explosionRadius = 3;
    private int droppedSkulls;

    public PaleCreeperEntity(EntityType<? extends PaleCreeperEntity> entityType, Level level) {
        super(entityType, level);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new PaleSwellGoal(this));
        this.goalSelector.addGoal(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Ocelot.class, 6.0f, 1.0, 1.2));
        this.goalSelector.addGoal(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Cat.class, 6.0f, 1.0, 1.2));
        this.goalSelector.addGoal(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.goalSelector.addGoal(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.targetSelector.addGoal(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    public Holder<PaleCreeperVariant> getVariant() {
        return (Holder)this.entityData.get(DATA_VARIANT_ID);
    }

    public void setVariant(Holder<PaleCreeperVariant> p_332777_) {
        this.entityData.set(DATA_VARIANT_ID, p_332777_);
    }

    public Identifier getTexture() {
        PaleCreeperVariant variant = (PaleCreeperVariant)this.getVariant().value();
        return variant.Texture();
    }

    public Identifier getShieldTexture() {
        PaleCreeperVariant variant = (PaleCreeperVariant)this.getVariant().value();
        return variant.PowerTexture();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MOVEMENT_SPEED, 0.25);
    }

    public int getMaxFallDistance() {
        return this.getTarget() == null ? this.getComfortableFallDistance(0.0f) : this.getComfortableFallDistance(this.getHealth() - 1.0f);
    }

    public boolean causeFallDamage(float fallDistance, float multiplier, DamageSource source) {
        boolean flag = super.causeFallDamage((double)fallDistance, multiplier, source);
        this.swell += (int)(fallDistance * 1.5f);
        if (this.swell > this.maxSwell - 5) {
            this.swell = this.maxSwell - 5;
        }
        return flag;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_SWELL_DIR, (Object)-1);
        builder.define(DATA_IS_POWERED, (Object)false);
        builder.define(DATA_IS_IGNITED, (Object)false);
        RegistryAccess registryaccess = this.registryAccess();
        Registry registry = registryaccess.lookupOrThrow(VariantsRegistry.PALE_CREEPER_VARIANT_REGISTRY_KEY);
        EntityDataAccessor<Holder<PaleCreeperVariant>> var10001 = DATA_VARIANT_ID;
        Optional var10002 = registry.get(PaleCreeperVariants.DEFAULT);
        Objects.requireNonNull(registry);
        builder.define(var10001, (Object)((Holder)var10002.or(() -> ((Registry)registry).getAny()).orElseThrow()));
    }

    public void addAdditionalSaveData(ValueOutput compound) {
        super.addAdditionalSaveData(compound);
        if (((Boolean)this.entityData.get(DATA_IS_POWERED)).booleanValue()) {
            compound.putBoolean("powered", true);
        }
        compound.putShort("Fuse", (short)this.maxSwell);
        compound.putByte("ExplosionRadius", (byte)this.explosionRadius);
        compound.putBoolean("ignited", this.isIgnited());
        this.getVariant().unwrapKey().ifPresent(p_344339_ -> compound.putString("variant", p_344339_.identifier().toString()));
    }

    public void readAdditionalSaveData(ValueInput compound) {
        super.readAdditionalSaveData(compound);
        this.entityData.set(DATA_IS_POWERED, (Object)compound.getBooleanOr("powered", false));
        this.maxSwell = compound.getShortOr("Fuse", (short)30);
        this.explosionRadius = compound.getByteOr("ExplosionRadius", (byte)3);
        if (compound.getBooleanOr("ignited", false)) {
            this.ignite();
        }
        VariantUtils.readVariant((ValueInput)compound, VariantsRegistry.PALE_CREEPER_VARIANT_REGISTRY_KEY).ifPresent(this::setVariant);
    }

    public void tick() {
        if (this.isAlive()) {
            int i;
            this.oldSwell = this.swell;
            if (this.isIgnited()) {
                this.setSwellDir(1);
            }
            if ((i = this.getSwellDir()) > 0 && this.swell == 0) {
                this.playSound(SoundEvents.CREEPER_PRIMED, 1.0f, 0.5f);
                this.gameEvent((Holder)GameEvent.PRIME_FUSE);
            }
            this.swell += i;
            if (this.swell < 0) {
                this.swell = 0;
            }
            if (this.swell >= this.maxSwell) {
                this.swell = this.maxSwell;
                this.explodeCreeper(this.blockPosition());
            }
        }
        super.tick();
    }

    public void setTarget(@Nullable LivingEntity target) {
        if (!(target instanceof Goat)) {
            super.setTarget(target);
        }
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return SoundEvents.CREEPER_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.CREEPER_DEATH;
    }

    protected void dropCustomDeathLoot(ServerLevel level, DamageSource damageSource, boolean recentlyHit) {
        PaleCreeperEntity creeper;
        super.dropCustomDeathLoot(level, damageSource, recentlyHit);
        Entity entity = damageSource.getEntity();
        if (entity != this && entity instanceof PaleCreeperEntity && (creeper = (PaleCreeperEntity)entity).canDropMobsSkull()) {
            creeper.increaseDroppedSkulls();
            this.spawnAtLocation(level, (ItemLike)Items.CREEPER_HEAD);
        }
    }

    public boolean doHurtTarget(ServerLevel p_376663_, Entity p_32281_) {
        return true;
    }

    public boolean isPowered() {
        return (Boolean)this.entityData.get(DATA_IS_POWERED);
    }

    public float getSwelling(float partialTicks) {
        return Mth.lerp((float)partialTicks, (float)this.oldSwell, (float)this.swell) / (float)(this.maxSwell - 2);
    }

    public int getSwellDir() {
        return (Integer)this.entityData.get(DATA_SWELL_DIR);
    }

    public void setSwellDir(int state) {
        this.entityData.set(DATA_SWELL_DIR, (Object)state);
    }

    public void thunderHit(ServerLevel level, LightningBolt lightning) {
        super.thunderHit(level, lightning);
        this.entityData.set(DATA_IS_POWERED, (Object)true);
    }

    protected InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (itemstack.is(ItemTags.CREEPER_IGNITERS)) {
            SoundEvent soundevent = itemstack.is(Items.FIRE_CHARGE) ? SoundEvents.FIRECHARGE_USE : SoundEvents.FLINTANDSTEEL_USE;
            this.level().playSound((Entity)player, this.getX(), this.getY(), this.getZ(), soundevent, this.getSoundSource(), 1.0f, this.random.nextFloat() * 0.4f + 0.8f);
            if (!this.level().isClientSide()) {
                this.ignite();
                if (!itemstack.isDamageableItem()) {
                    itemstack.shrink(1);
                } else {
                    itemstack.hurtAndBreak(1, (LivingEntity)player, hand.asEquipmentSlot());
                }
            }
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(player, hand);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor p_32259_, DifficultyInstance p_32260_, EntitySpawnReason p_363852_, @Nullable SpawnGroupData p_32262_) {
        Registry holder = p_32259_.registryAccess().lookupOrThrow(VariantsRegistry.PALE_CREEPER_VARIANT_REGISTRY_KEY);
        if (holder.getRandom(this.random).isPresent()) {
            this.setVariant((Holder<PaleCreeperVariant>)((Holder)holder.getRandom(this.random).get()));
        }
        return p_32262_;
    }

    private void explodeCreeper(BlockPos p_383073_) {
        Level var2 = this.level();
        if (var2 instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)var2;
            serverlevel.playSound((Entity)((Player)null), p_383073_, (SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), SoundSource.BLOCKS, 1.0f, 1.0f);
            this.dead = true;
            this.triggerOnDeathMobEffects(serverlevel, Entity.RemovalReason.KILLED);
            this.discard();
            List ENTITY = serverlevel.getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(4.0));
            for (LivingEntity entity : ENTITY) {
                entity.hurt(this.damageSources().mobAttack((LivingEntity)this), 1.5f);
            }
            if (!serverlevel.getBiome(p_383073_).is(((PaleCreeperVariant)this.getVariant().value()).Biome())) {
                this.growMushroom(serverlevel, p_383073_, serverlevel.getBlockState(p_383073_), this.random);
                if (this.getVariant().is(PaleCreeperVariants.DEFAULT)) {
                    BlockPos.betweenClosed((BlockPos)p_383073_.offset(-5, -5, -5), (BlockPos)p_383073_.offset(5, 5, 5)).forEach(p_383198_ -> {
                        BlockState blockstate = serverlevel.getBlockState(p_383198_);
                        if (blockstate.is(BlockTags.OVERWORLD_NATURAL_LOGS)) {
                            serverlevel.scheduleTick(p_383198_, Blocks.PALE_OAK_LOG, 1);
                            serverlevel.setBlock(p_383198_, (BlockState)Blocks.PALE_OAK_LOG.defaultBlockState().setValue((Property)RotatedPillarBlock.AXIS, (Comparable)((Direction.Axis)blockstate.getValue((Property)RotatedPillarBlock.AXIS))), 2);
                        }
                        if (blockstate.is(Blocks.RED_MUSHROOM_BLOCK)) {
                            serverlevel.scheduleTick(p_383198_, (Block)BlockRegistry.CREAKING_MUSHROOM_BLOCK.get(), 1);
                            serverlevel.setBlock(p_383198_, ((Block)BlockRegistry.CREAKING_MUSHROOM_BLOCK.get()).defaultBlockState(), 2);
                        }
                        if (blockstate.is(Blocks.BROWN_MUSHROOM_BLOCK)) {
                            serverlevel.scheduleTick(p_383198_, (Block)BlockRegistry.PALE_MUSHROOM_BLOCK.get(), 1);
                            serverlevel.setBlock(p_383198_, ((Block)BlockRegistry.PALE_MUSHROOM_BLOCK.get()).defaultBlockState(), 2);
                        }
                        if (blockstate.is(Blocks.PUMPKIN)) {
                            serverlevel.scheduleTick(p_383198_, (Block)BlockRegistry.PALE_PUMPKIN.get(), 1);
                            serverlevel.setBlock(p_383198_, ((Block)BlockRegistry.PALE_PUMPKIN.get()).defaultBlockState(), 2);
                        }
                        if (blockstate.is(BlockTags.LEAVES)) {
                            serverlevel.scheduleTick(p_383198_, Blocks.PALE_OAK_LEAVES, 1);
                            serverlevel.setBlock(p_383198_, Blocks.PALE_OAK_LEAVES.defaultBlockState(), 2);
                        }
                        if (blockstate.is(Blocks.MOSSY_COBBLESTONE)) {
                            serverlevel.scheduleTick(p_383198_, Blocks.MOSSY_COBBLESTONE, 1);
                            serverlevel.setBlock(p_383198_, ((Block)BlockRegistry.PALE_MOSSY_COBBLESTONE.get()).defaultBlockState(), 2);
                        }
                        if (blockstate.is(Blocks.MOSSY_COBBLESTONE_SLAB)) {
                            serverlevel.scheduleTick(p_383198_, Blocks.MOSSY_COBBLESTONE_SLAB, 1);
                            serverlevel.setBlock(p_383198_, (BlockState)((Block)BlockRegistry.PALE_MOSSY_COBBLESTONE_SLAB.get()).defaultBlockState().setValue((Property)SlabBlock.TYPE, (Comparable)((SlabType)blockstate.getValue((Property)SlabBlock.TYPE))), 2);
                        }
                        if (blockstate.is(Blocks.MOSSY_COBBLESTONE_STAIRS)) {
                            serverlevel.scheduleTick(p_383198_, Blocks.MOSSY_COBBLESTONE_STAIRS, 1);
                            serverlevel.setBlock(p_383198_, (BlockState)((BlockState)((BlockState)((Block)BlockRegistry.PALE_MOSSY_COBBLESTONE_STAIRS.get()).defaultBlockState().setValue((Property)StairBlock.SHAPE, (Comparable)((StairsShape)blockstate.getValue((Property)StairBlock.SHAPE)))).setValue((Property)StairBlock.HALF, (Comparable)((Half)blockstate.getValue((Property)StairBlock.HALF)))).setValue((Property)StairBlock.FACING, (Comparable)((Direction)blockstate.getValue((Property)StairBlock.FACING))), 2);
                        }
                        if (blockstate.is(Blocks.MOSSY_COBBLESTONE_WALL)) {
                            serverlevel.scheduleTick(p_383198_, Blocks.MOSSY_COBBLESTONE_WALL, 1);
                            serverlevel.setBlock(p_383198_, ((Block)BlockRegistry.PALE_MOSSY_COBBLESTONE_WALL.get()).defaultBlockState(), 2);
                        }
                        if (blockstate.is(Blocks.MOSSY_STONE_BRICKS)) {
                            serverlevel.scheduleTick(p_383198_, Blocks.MOSSY_STONE_BRICKS, 1);
                            serverlevel.setBlock(p_383198_, ((Block)BlockRegistry.PALE_MOSSY_STONE_BRICKS.get()).defaultBlockState(), 2);
                        }
                        if (blockstate.is(Blocks.MOSSY_STONE_BRICK_SLAB)) {
                            serverlevel.scheduleTick(p_383198_, Blocks.MOSSY_STONE_BRICK_SLAB, 1);
                            serverlevel.setBlock(p_383198_, (BlockState)((Block)BlockRegistry.PALE_MOSSY_STONE_BRICK_SLAB.get()).defaultBlockState().setValue((Property)SlabBlock.TYPE, (Comparable)((SlabType)blockstate.getValue((Property)SlabBlock.TYPE))), 2);
                        }
                        if (blockstate.is(Blocks.MOSSY_STONE_BRICK_STAIRS)) {
                            serverlevel.scheduleTick(p_383198_, Blocks.MOSSY_STONE_BRICK_STAIRS, 1);
                            serverlevel.setBlock(p_383198_, (BlockState)((BlockState)((BlockState)((Block)BlockRegistry.PALE_MOSSY_STONE_BRICK_STAIRS.get()).defaultBlockState().setValue((Property)StairBlock.SHAPE, (Comparable)((StairsShape)blockstate.getValue((Property)StairBlock.SHAPE)))).setValue((Property)StairBlock.HALF, (Comparable)((Half)blockstate.getValue((Property)StairBlock.HALF)))).setValue((Property)StairBlock.FACING, (Comparable)((Direction)blockstate.getValue((Property)StairBlock.FACING))), 2);
                        }
                        if (blockstate.is(Blocks.MOSSY_STONE_BRICK_WALL)) {
                            serverlevel.scheduleTick(p_383198_, Blocks.MOSSY_STONE_BRICK_WALL, 1);
                            serverlevel.setBlock(p_383198_, ((Block)BlockRegistry.PALE_MOSSY_STONE_BRICK_WALL.get()).defaultBlockState(), 2);
                        }
                        this.spawnTransformParticle(serverlevel, (BlockPos)p_383198_, this.random);
                    });
                }
            } else {
                this.spawnLingeringCloud();
            }
        }
    }

    public boolean growMushroom(ServerLevel level, BlockPos pos, BlockState state, RandomSource random) {
        Optional<Holder> optional = level.registryAccess().lookupOrThrow(Registries.CONFIGURED_FEATURE).get(((PaleCreeperVariant)this.getVariant().value()).Feature());
        BlockGrowFeatureEvent event = EventHooks.fireBlockGrowFeature((LevelAccessor)level, (RandomSource)random, (BlockPos)pos, (Holder)optional.orElse(null));
        if (event.isCanceled()) {
            return false;
        }
        optional = Optional.ofNullable(event.getFeature());
        if (optional.isEmpty()) {
            return false;
        }
        level.removeBlock(pos, false);
        if (((ConfiguredFeature)optional.get().value()).place((WorldGenLevel)level, level.getChunkSource().getGenerator(), random, pos)) {
            return true;
        }
        level.setBlock(pos, state, 3);
        return false;
    }

    public void spawnTransformParticle(ServerLevel p_383084_, BlockPos p_383042_, RandomSource p_382825_) {
        Vec3 vec3 = p_383042_.getCenter();
        double d0 = 0.5 + p_382825_.nextDouble();
        Vec3 vec31 = new Vec3(p_382825_.nextDouble() - 0.5, p_382825_.nextDouble() + 1.0, p_382825_.nextDouble() - 0.5);
        Vec3 vec32 = vec3.add(vec31.scale(d0));
        TrailParticleOption trailparticleoption = new TrailParticleOption(vec32, ((PaleCreeperVariant)this.getVariant().value()).Particle(), (int)(20.0 * d0));
        p_383084_.sendParticles((ParticleOptions)trailparticleoption, vec3.x, vec3.y, vec3.z, 1, 0.0, 0.0, 0.0, 0.0);
    }

    private void spawnLingeringCloud() {
        if (this.level().getBiome(this.blockPosition()).is(((PaleCreeperVariant)this.getVariant().value()).Biome())) {
            AreaEffectCloud areaeffectcloud = new AreaEffectCloud(this.level(), this.getX(), this.getY(), this.getZ());
            areaeffectcloud.setRadius(2.5f);
            areaeffectcloud.setRadiusOnUse(-0.5f);
            areaeffectcloud.setWaitTime(10);
            areaeffectcloud.setDuration(areaeffectcloud.getDuration() / 2);
            areaeffectcloud.setRadiusPerTick(-areaeffectcloud.getRadius() / (float)areaeffectcloud.getDuration());
            areaeffectcloud.addEffect(new MobEffectInstance(new MobEffectInstance(((PaleCreeperVariant)this.getVariant().value()).Effect(), 250, 0)));
            this.level().addFreshEntity((Entity)areaeffectcloud);
        }
    }

    public boolean isIgnited() {
        return (Boolean)this.entityData.get(DATA_IS_IGNITED);
    }

    public void ignite() {
        this.entityData.set(DATA_IS_IGNITED, (Object)true);
    }

    public boolean canDropMobsSkull() {
        return this.isPowered() && this.droppedSkulls < 1;
    }

    public void increaseDroppedSkulls() {
        ++this.droppedSkulls;
    }

    static {
        DATA_VARIANT_ID = SynchedEntityData.defineId(PaleCreeperEntity.class, EntityRegistry.PALE_CREEPER_VARIANT.get());
        DATA_SWELL_DIR = SynchedEntityData.defineId(PaleCreeperEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
        DATA_IS_POWERED = SynchedEntityData.defineId(PaleCreeperEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
        DATA_IS_IGNITED = SynchedEntityData.defineId(PaleCreeperEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    }
}

