/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.creaking_expanded.entity;

import com.belgie.creaking_expanded.entity.AI.PaleHostileCreature;
import com.belgie.creaking_expanded.registry.BlockRegistry;
import com.belgie.creaking_expanded.registry.EntityRegistry;
import com.belgie.creaking_expanded.registry.MobEffectRegistry;
import com.belgie.creaking_expanded.registry.VariantsRegistry;
import com.belgie.creaking_expanded.variants.PaleSkeletonVariant;
import com.belgie.creaking_expanded.variants.PaleSkeletonVariants;
import java.time.LocalDate;
import java.time.temporal.ChronoField;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.Identifier;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FleeSunGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RestrictSunGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.golem.IronGolem;
import net.minecraft.world.entity.animal.turtle.Turtle;
import net.minecraft.world.entity.animal.wolf.Wolf;
import net.minecraft.world.entity.monster.creaking.Creaking;
import net.minecraft.world.entity.monster.skeleton.AbstractSkeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.arrow.AbstractArrow;
import net.minecraft.world.entity.projectile.arrow.Arrow;
import net.minecraft.world.entity.variant.VariantUtils;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class PaleSkeletonEntity
extends AbstractSkeleton
implements PaleHostileCreature {
    private static final EntityDataAccessor<Holder<PaleSkeletonVariant>> DATA_VARIANT_ID = SynchedEntityData.defineId(PaleSkeletonEntity.class, EntityRegistry.PALE_SKELETON_VARIANT.get());

    public PaleSkeletonEntity(EntityType<? extends PaleSkeletonEntity> entityType, Level level) {
        super(entityType, level);
    }

    public static boolean checkStraySpawnRules(EntityType<PaleSkeletonEntity> p_219121_, ServerLevelAccessor p_219122_, EntitySpawnReason p_360760_, BlockPos p_219124_, RandomSource p_219125_) {
        return PaleSkeletonEntity.checkMonsterSpawnRules(p_219121_, (ServerLevelAccessor)p_219122_, (EntitySpawnReason)p_360760_, (BlockPos)p_219124_, (RandomSource)p_219125_) && EntitySpawnReason.isSpawner((EntitySpawnReason)p_360760_);
    }

    public Holder<PaleSkeletonVariant> getVariant() {
        return (Holder)this.entityData.get(DATA_VARIANT_ID);
    }

    public void setVariant(Holder<PaleSkeletonVariant> p_332777_) {
        this.entityData.set(DATA_VARIANT_ID, p_332777_);
    }

    public Identifier getTexture() {
        PaleSkeletonVariant variant = (PaleSkeletonVariant)this.getVariant().value();
        return variant.Texture();
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(2, (Goal)new RestrictSunGoal((PathfinderMob)this));
        this.goalSelector.addGoal(3, (Goal)new FleeSunGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Wolf.class, 6.0f, 1.0, 1.2));
        this.goalSelector.addGoal(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Turtle.class, 10, true, false, Turtle.BABY_ON_LAND_SELECTOR));
    }

    protected void defineSynchedData(SynchedEntityData.Builder p_379982_) {
        super.defineSynchedData(p_379982_);
        RegistryAccess registryaccess = this.registryAccess();
        Registry registry = registryaccess.lookupOrThrow(VariantsRegistry.PALE_SKELETON_VARIANT_REGISTRY_KEY);
        EntityDataAccessor<Holder<PaleSkeletonVariant>> var10001 = DATA_VARIANT_ID;
        Optional var10002 = registry.get(PaleSkeletonVariants.DEFAULT);
        Objects.requireNonNull(registry);
        p_379982_.define(var10001, (Object)((Holder)var10002.or(() -> ((Registry)registry).getAny()).orElseThrow()));
    }

    public void addAdditionalSaveData(ValueOutput compound) {
        super.addAdditionalSaveData(compound);
        this.getVariant().unwrapKey().ifPresent(p_344339_ -> compound.putString("variant", p_344339_.identifier().toString()));
    }

    public boolean canAttack(LivingEntity target) {
        return !this.NearCreakings() ? false : super.canAttack(target);
    }

    public boolean NearCreakings() {
        ServerLevel level = (ServerLevel)this.level();
        int size = level.getNearbyEntities(Creaking.class, BAT_RESTING_TARGETING, (LivingEntity)this, this.getBoundingBox().inflate(16.0)).size();
        if (((PaleSkeletonVariant)this.getVariant().value()).Item()) {
            return true;
        }
        return size == 0;
    }

    public void readAdditionalSaveData(ValueInput compound) {
        super.readAdditionalSaveData(compound);
        VariantUtils.readVariant((ValueInput)compound, VariantsRegistry.PALE_SKELETON_VARIANT_REGISTRY_KEY).ifPresent(this::setVariant);
        super.readAdditionalSaveData(compound);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor p_32259_, DifficultyInstance p_32260_, EntitySpawnReason p_363852_, @Nullable SpawnGroupData p_32262_) {
        Registry holder = p_32259_.registryAccess().lookupOrThrow(VariantsRegistry.PALE_SKELETON_VARIANT_REGISTRY_KEY);
        if (holder.getRandom(this.random).isPresent()) {
            this.setVariant((Holder<PaleSkeletonVariant>)((Holder)holder.getRandom(this.random).get()));
        }
        RandomSource randomsource = p_32259_.getRandom();
        this.populateDefaultEquipmentSlots(randomsource, p_32260_);
        this.populateDefaultEquipmentEnchantments(p_32259_, randomsource, p_32260_);
        this.setCanPickUpLoot(randomsource.nextFloat() < 0.55f * p_32260_.getSpecialMultiplier());
        if (this.getItemBySlot(EquipmentSlot.HEAD).isEmpty()) {
            LocalDate localdate = LocalDate.now();
            int i = localdate.get(ChronoField.DAY_OF_MONTH);
            int j = localdate.get(ChronoField.MONTH_OF_YEAR);
            if (j == 10 && i == 31 && randomsource.nextFloat() < 0.25f) {
                this.setItemSlot(EquipmentSlot.HEAD, new ItemStack(randomsource.nextFloat() < 0.1f ? (ItemLike)BlockRegistry.PALE_JACK_O_LANTERN.get() : (ItemLike)BlockRegistry.CARVED_PALE_PUMPKIN.get()));
                this.setDropChance(EquipmentSlot.HEAD, 0.0f);
            }
        }
        return p_32262_;
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.STRAY_AMBIENT;
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return SoundEvents.STRAY_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.STRAY_DEATH;
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.STRAY_STEP;
    }

    protected AbstractArrow getArrow(ItemStack arrow, float velocity, @Nullable ItemStack weapon) {
        AbstractArrow abstractarrow = super.getArrow(arrow, velocity, weapon);
        if (abstractarrow instanceof Arrow) {
            ((Arrow)abstractarrow).addEffect(new MobEffectInstance(MobEffectRegistry.FOGGY, 600));
        }
        return abstractarrow;
    }
}

