/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.creaking_expanded.entity;

import com.belgie.creaking_expanded.entity.AI.PaleHostileCreature;
import com.belgie.creaking_expanded.registry.BlockRegistry;
import com.belgie.creaking_expanded.registry.EntityRegistry;
import com.belgie.creaking_expanded.registry.MobEffectRegistry;
import com.belgie.creaking_expanded.registry.VariantsRegistry;
import com.belgie.creaking_expanded.variants.PaleZombieVariant;
import com.belgie.creaking_expanded.variants.PaleZombieVariants;
import java.time.LocalDate;
import java.time.temporal.ChronoField;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.Identifier;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveThroughVillageGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RemoveBlockGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.ZombieAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.chicken.Chicken;
import net.minecraft.world.entity.animal.golem.IronGolem;
import net.minecraft.world.entity.animal.turtle.Turtle;
import net.minecraft.world.entity.monster.creaking.Creaking;
import net.minecraft.world.entity.monster.zombie.Husk;
import net.minecraft.world.entity.monster.zombie.Zombie;
import net.minecraft.world.entity.npc.villager.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.variant.VariantUtils;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class PaleZombieEntity
extends Zombie
implements PaleHostileCreature {
    private static final EntityDataAccessor<Holder<PaleZombieVariant>> DATA_VARIANT_ID = SynchedEntityData.defineId(PaleZombieEntity.class, EntityRegistry.PALE_ZOMBIE_VARIANT.get());

    public PaleZombieEntity(EntityType<? extends PaleZombieEntity> entityType, Level level) {
        super(entityType, level);
    }

    public static boolean checkHuskSpawnRules(EntityType<Husk> p_218997_, ServerLevelAccessor p_218998_, EntitySpawnReason p_363377_, BlockPos p_219000_, RandomSource p_219001_) {
        return PaleZombieEntity.checkMonsterSpawnRules(p_218997_, (ServerLevelAccessor)p_218998_, (EntitySpawnReason)p_363377_, (BlockPos)p_219000_, (RandomSource)p_219001_) && (EntitySpawnReason.isSpawner((EntitySpawnReason)p_363377_) || p_218998_.canSeeSky(p_219000_));
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(4, (Goal)new ZombieAttackTurtleEggGoal((PathfinderMob)this, 1.0, 3));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.addBehaviourGoals();
    }

    protected void addBehaviourGoals() {
        this.goalSelector.addGoal(2, (Goal)new ZombieAttackGoal((Zombie)this, 1.0, false));
        this.goalSelector.addGoal(6, (Goal)new MoveThroughVillageGoal((PathfinderMob)this, 1.0, true, 4, () -> ((PaleZombieEntity)this).canBreakDoors()));
        this.goalSelector.addGoal(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[]{PaleZombieEntity.class}));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.targetSelector.addGoal(5, (Goal)new NearestAttackableTargetGoal((Mob)this, Turtle.class, 10, true, false, Turtle.BABY_ON_LAND_SELECTOR));
    }

    public Holder<PaleZombieVariant> getVariant() {
        return (Holder)this.entityData.get(DATA_VARIANT_ID);
    }

    public void setVariant(Holder<PaleZombieVariant> p_332777_) {
        this.entityData.set(DATA_VARIANT_ID, p_332777_);
    }

    public Identifier getTexture() {
        PaleZombieVariant variant = (PaleZombieVariant)this.getVariant().value();
        return variant.Texture();
    }

    protected void defineSynchedData(SynchedEntityData.Builder p_379982_) {
        super.defineSynchedData(p_379982_);
        RegistryAccess registryaccess = this.registryAccess();
        Registry registry = registryaccess.lookupOrThrow(VariantsRegistry.PALE_ZOMBIE_VARIANT_REGISTRY_KEY);
        EntityDataAccessor<Holder<PaleZombieVariant>> var10001 = DATA_VARIANT_ID;
        Optional var10002 = registry.get(PaleZombieVariants.DEFAULT);
        Objects.requireNonNull(registry);
        p_379982_.define(var10001, (Object)((Holder)var10002.or(() -> ((Registry)registry).getAny()).orElseThrow()));
    }

    public void addAdditionalSaveData(ValueOutput compound) {
        super.addAdditionalSaveData(compound);
        this.getVariant().unwrapKey().ifPresent(p_344339_ -> compound.putString("variant", p_344339_.identifier().toString()));
    }

    public void readAdditionalSaveData(ValueInput compound) {
        super.readAdditionalSaveData(compound);
        VariantUtils.readVariant((ValueInput)compound, VariantsRegistry.PALE_ZOMBIE_VARIANT_REGISTRY_KEY).ifPresent(this::setVariant);
        super.readAdditionalSaveData(compound);
    }

    protected boolean isSunSensitive() {
        return false;
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.HUSK_AMBIENT;
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return SoundEvents.HUSK_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.HUSK_DEATH;
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.HUSK_STEP;
    }

    public boolean doHurtTarget(ServerLevel p_376715_, Entity p_32892_) {
        boolean flag = super.doHurtTarget(p_376715_, p_32892_);
        if (flag && this.getMainHandItem().isEmpty() && p_32892_ instanceof LivingEntity) {
            float f = p_376715_.getCurrentDifficultyAt(this.blockPosition()).getEffectiveDifficulty();
            ((LivingEntity)p_32892_).addEffect(new MobEffectInstance(MobEffectRegistry.FOGGY, 140 * (int)f), (Entity)this);
        }
        return flag;
    }

    public boolean canAttack(LivingEntity target) {
        return !this.NearCreakings() ? false : super.canAttack(target);
    }

    public boolean NearCreakings() {
        ServerLevel level = (ServerLevel)this.level();
        int size = level.getNearbyEntities(Creaking.class, BAT_RESTING_TARGETING, (LivingEntity)this, this.getBoundingBox().inflate(16.0)).size();
        if (((PaleZombieVariant)this.getVariant().value()).AttacksNearCreakings()) {
            return true;
        }
        return size == 0;
    }

    protected ItemStack getSkull() {
        return ItemStack.EMPTY;
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor p_32259_, DifficultyInstance p_32260_, EntitySpawnReason p_363852_, @Nullable SpawnGroupData p_32262_) {
        Registry holder = p_32259_.registryAccess().lookupOrThrow(VariantsRegistry.PALE_ZOMBIE_VARIANT_REGISTRY_KEY);
        if (holder.getRandom(this.random).isPresent()) {
            this.setVariant((Holder<PaleZombieVariant>)((Holder)holder.getRandom(this.random).get()));
        }
        RandomSource randomsource = p_32259_.getRandom();
        SpawnGroupData p_34300_ = super.finalizeSpawn(p_32259_, p_32260_, p_363852_, p_32262_);
        float f = p_32260_.getSpecialMultiplier();
        if (p_363852_ != EntitySpawnReason.CONVERSION) {
            this.setCanPickUpLoot(randomsource.nextFloat() < 0.55f * f);
        }
        if (p_34300_ == null) {
            p_34300_ = new Zombie.ZombieGroupData(PaleZombieEntity.getSpawnAsBabyOdds((RandomSource)randomsource), true);
        }
        if (p_34300_ instanceof Zombie.ZombieGroupData) {
            Zombie.ZombieGroupData zombie$zombiegroupdata = (Zombie.ZombieGroupData)p_34300_;
            if (zombie$zombiegroupdata.isBaby) {
                this.setBaby(true);
                if (zombie$zombiegroupdata.canSpawnJockey) {
                    Chicken chicken1;
                    if ((double)randomsource.nextFloat() < 0.05) {
                        List list = p_32259_.getEntitiesOfClass(Chicken.class, this.getBoundingBox().inflate(5.0, 3.0, 5.0), EntitySelector.ENTITY_NOT_BEING_RIDDEN);
                        if (!list.isEmpty()) {
                            Chicken chicken = (Chicken)list.get(0);
                            chicken.setChickenJockey(true);
                            this.startRiding((Entity)chicken);
                        }
                    } else if ((double)randomsource.nextFloat() < 0.05 && (chicken1 = (Chicken)EntityType.CHICKEN.create(this.level(), EntitySpawnReason.JOCKEY)) != null) {
                        chicken1.snapTo(this.getX(), this.getY(), this.getZ(), this.getYRot(), 0.0f);
                        chicken1.finalizeSpawn(p_32259_, p_32260_, EntitySpawnReason.JOCKEY, (SpawnGroupData)null);
                        chicken1.setChickenJockey(true);
                        this.startRiding((Entity)chicken1);
                        p_32259_.addFreshEntity((Entity)chicken1);
                    }
                }
            }
            this.setCanBreakDoors(randomsource.nextFloat() < f * 0.1f);
            if (p_363852_ != EntitySpawnReason.CONVERSION) {
                this.populateDefaultEquipmentSlots(randomsource, p_32260_);
                this.populateDefaultEquipmentEnchantments(p_32259_, randomsource, p_32260_);
            }
        }
        if (this.getItemBySlot(EquipmentSlot.HEAD).isEmpty()) {
            LocalDate localdate = LocalDate.now();
            int i = localdate.get(ChronoField.DAY_OF_MONTH);
            int j = localdate.get(ChronoField.MONTH_OF_YEAR);
            if (j == 10 && i == 31 && randomsource.nextFloat() < 0.25f) {
                this.setItemSlot(EquipmentSlot.HEAD, new ItemStack(randomsource.nextFloat() < 0.1f ? (ItemLike)BlockRegistry.PALE_JACK_O_LANTERN.get() : (ItemLike)BlockRegistry.CARVED_PALE_PUMPKIN.get()));
                this.setDropChance(EquipmentSlot.HEAD, 0.0f);
            }
        }
        this.handleAttributes(f);
        return p_34300_;
    }

    class ZombieAttackTurtleEggGoal
    extends RemoveBlockGoal {
        ZombieAttackTurtleEggGoal(PathfinderMob mob, double speedModifier, int verticalSearchRange) {
            super(Blocks.TURTLE_EGG, mob, speedModifier, verticalSearchRange);
        }

        public void playDestroyProgressSound(LevelAccessor level, BlockPos pos) {
            level.playSound((Entity)((Player)null), pos, SoundEvents.ZOMBIE_DESTROY_EGG, SoundSource.HOSTILE, 0.5f, 0.9f + PaleZombieEntity.this.random.nextFloat() * 0.2f);
        }

        public void playBreakSound(Level level, BlockPos pos) {
            level.playSound((Entity)((Player)null), pos, SoundEvents.TURTLE_EGG_BREAK, SoundSource.BLOCKS, 0.7f, 0.9f + level.random.nextFloat() * 0.2f);
        }

        public double acceptedDistance() {
            return 1.14;
        }
    }
}

