/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.creaking_expanded.particles;

import java.util.Optional;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SingleQuadParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.particles.ParticleLimit;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;

public class CreakingEyeParticles
extends SingleQuadParticle {
    public CreakingEyeParticles(ClientLevel level, double x, double y, double z, TextureAtlasSprite sprite) {
        super(level, x, y - 0.125, z, sprite);
        this.setSize(0.01f, 0.01f);
        this.quadSize *= this.random.nextFloat() * 0.6f + 0.2f;
        this.lifetime = (int)(16.0 / (Math.random() * 0.8 + 0.2));
        this.hasPhysics = false;
        this.friction = 1.0f;
        this.gravity = 0.0f;
    }

    public CreakingEyeParticles(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, TextureAtlasSprite sprite) {
        super(level, x, y - 0.125, z, xSpeed, ySpeed, zSpeed, sprite);
        this.setSize(0.01f, 0.01f);
        this.quadSize *= this.random.nextFloat() * 0.6f + 0.6f;
        this.lifetime = (int)(16.0 / (Math.random() * 0.8 + 0.2));
        this.hasPhysics = false;
        this.friction = 1.0f;
        this.gravity = 0.0f;
    }

    public SingleQuadParticle.Layer getLayer() {
        return SingleQuadParticle.Layer.OPAQUE;
    }

    public static class SporeBlossomAirProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public SporeBlossomAirProvider(SpriteSet sprites) {
            this.sprite = sprites;
        }

        public Particle createParticle(SimpleParticleType particleType, ClientLevel p_level, double p_x, double p_y, double p_z, double xSpeed, double ySpeed, double zSpeed, RandomSource p_random) {
            CreakingEyeParticles suspendedparticle = new CreakingEyeParticles(this, p_level, p_x, p_y, p_z, 0.0, -0.8f, 0.0, this.sprite.get(p_random)){

                public Optional<ParticleLimit> getParticleLimit() {
                    return Optional.of(new ParticleLimit(500));
                }
            };
            suspendedparticle.lifetime = Mth.randomBetweenInclusive((RandomSource)p_random, (int)500, (int)1000);
            suspendedparticle.gravity = 0.01f;
            suspendedparticle.setColor(0.32f, 0.5f, 0.22f);
            return suspendedparticle;
        }
    }
}

