/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.creaking_expanded.variants;

import com.belgie.creaking_expanded.registry.VariantsRegistry;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;

public class PaleCreeperVariant {
    public static final Codec<PaleCreeperVariant> DIRECT_CODEC = RecordCodecBuilder.create(p_332779_ -> p_332779_.group((App)Identifier.CODEC.fieldOf("texture").forGetter(p_335261_ -> p_335261_.Texture), (App)Identifier.CODEC.fieldOf("charged_texture").forGetter(p_335261_ -> p_335261_.PowerTexture), (App)MobEffect.CODEC.fieldOf("non_safe_biome_effect").forGetter(p_335263_ -> p_335263_.effect), (App)ResourceKey.codec((ResourceKey)Registries.CONFIGURED_FEATURE).fieldOf("placed_feature").forGetter(p_335263_ -> p_335263_.feature), (App)ResourceKey.codec((ResourceKey)Registries.BIOME).fieldOf("safe_biome").forGetter(p_335263_ -> p_335263_.biome), (App)ExtraCodecs.POSITIVE_INT.fieldOf("particle_colour").forGetter(p_335263_ -> p_335263_.particle)).apply((Applicative)p_332779_, PaleCreeperVariant::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, PaleCreeperVariant> DIRECT_STREAM_CODEC = StreamCodec.composite((StreamCodec)Identifier.STREAM_CODEC, PaleCreeperVariant::Texture, (StreamCodec)Identifier.STREAM_CODEC, PaleCreeperVariant::PowerTexture, (StreamCodec)ByteBufCodecs.holderRegistry((ResourceKey)Registries.MOB_EFFECT), PaleCreeperVariant::Effect, (StreamCodec)ResourceKey.streamCodec((ResourceKey)Registries.CONFIGURED_FEATURE), PaleCreeperVariant::Feature, (StreamCodec)ResourceKey.streamCodec((ResourceKey)Registries.BIOME), PaleCreeperVariant::Biome, (StreamCodec)ByteBufCodecs.INT, PaleCreeperVariant::Particle, PaleCreeperVariant::new);
    public static final Codec<Holder<PaleCreeperVariant>> CODEC = RegistryFileCodec.create(VariantsRegistry.PALE_CREEPER_VARIANT_REGISTRY_KEY, DIRECT_CODEC);
    public static final StreamCodec<RegistryFriendlyByteBuf, Holder<PaleCreeperVariant>> STREAM_CODEC = ByteBufCodecs.holder(VariantsRegistry.PALE_CREEPER_VARIANT_REGISTRY_KEY, DIRECT_STREAM_CODEC);
    public final Identifier Texture;
    public final Identifier PowerTexture;
    public final int particle;
    public final Holder<MobEffect> effect;
    public final ResourceKey<ConfiguredFeature<?, ?>> feature;
    public final ResourceKey<Biome> biome;
    public final Identifier TextureFull;
    public final Identifier PowerTextureFull;

    public PaleCreeperVariant(Identifier texture, Identifier powertexture, Holder<MobEffect> effect, ResourceKey<ConfiguredFeature<?, ?>> feature, ResourceKey<Biome> biome, int particle) {
        this.Texture = texture;
        this.TextureFull = PaleCreeperVariant.fullTextureId(texture);
        this.PowerTexture = powertexture;
        this.PowerTextureFull = PaleCreeperVariant.fullTextureId(powertexture);
        this.effect = effect;
        this.feature = feature;
        this.biome = biome;
        this.particle = particle;
    }

    public static Identifier fullTextureId(Identifier texture) {
        return texture.withPath(p_335262_ -> "textures/" + p_335262_ + ".png");
    }

    public Identifier Texture() {
        return this.TextureFull;
    }

    public Identifier PowerTexture() {
        return this.PowerTextureFull;
    }

    public Holder<MobEffect> Effect() {
        return this.effect;
    }

    public ResourceKey<ConfiguredFeature<?, ?>> Feature() {
        return this.feature;
    }

    public ResourceKey<Biome> Biome() {
        return this.biome;
    }

    public int Particle() {
        return this.particle;
    }

    public int hashCode() {
        int i = 1;
        i = 31 * i + this.Texture.hashCode();
        return i;
    }
}

