/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.creaking_expanded.variants;

import com.belgie.creaking_expanded.registry.VariantsRegistry;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.RegistryFileCodec;

public class PaleSkeletonVariant {
    public static final Codec<PaleSkeletonVariant> DIRECT_CODEC = RecordCodecBuilder.create(p_332779_ -> p_332779_.group((App)Identifier.CODEC.fieldOf("texture").forGetter(p_335261_ -> p_335261_.Texture), (App)Codec.BOOL.fieldOf("attacks_near_creakings").forGetter(p_335263_ -> p_335263_.item)).apply((Applicative)p_332779_, PaleSkeletonVariant::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, PaleSkeletonVariant> DIRECT_STREAM_CODEC = StreamCodec.composite((StreamCodec)Identifier.STREAM_CODEC, PaleSkeletonVariant::Texture, (StreamCodec)ByteBufCodecs.BOOL, PaleSkeletonVariant::Item, PaleSkeletonVariant::new);
    public static final Codec<Holder<PaleSkeletonVariant>> CODEC = RegistryFileCodec.create(VariantsRegistry.PALE_SKELETON_VARIANT_REGISTRY_KEY, DIRECT_CODEC);
    public static final StreamCodec<RegistryFriendlyByteBuf, Holder<PaleSkeletonVariant>> STREAM_CODEC = ByteBufCodecs.holder(VariantsRegistry.PALE_SKELETON_VARIANT_REGISTRY_KEY, DIRECT_STREAM_CODEC);
    public final Identifier Texture;
    public final boolean item;
    public final Identifier TextureFull;

    public PaleSkeletonVariant(Identifier texture, boolean item) {
        this.Texture = texture;
        this.TextureFull = PaleSkeletonVariant.fullTextureId(texture);
        this.item = item;
    }

    public static Identifier fullTextureId(Identifier texture) {
        return texture.withPath(p_335262_ -> "textures/" + p_335262_ + ".png");
    }

    public Identifier Texture() {
        return this.TextureFull;
    }

    public boolean Item() {
        return this.item;
    }

    public boolean equals(Object other) {
        boolean var10000;
        if (other == this) {
            return true;
        }
        if (other instanceof PaleSkeletonVariant) {
            PaleSkeletonVariant CreakingVariant = (PaleSkeletonVariant)other;
            var10000 = Objects.equals(this.Texture, CreakingVariant.Texture) && Objects.equals(this.item, CreakingVariant.item);
        } else {
            var10000 = false;
        }
        return var10000;
    }

    public int hashCode() {
        int i = 1;
        i = 31 * i + this.Texture.hashCode();
        return i;
    }
}

