/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.creaking_expanded.blocks;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.level.BlockGrowFeatureEvent;

public class ModFlowerBlock
extends BushBlock
implements BonemealableBlock {
    public static final MapCodec<ModFlowerBlock> CODEC = RecordCodecBuilder.mapCodec(p_368432_ -> p_368432_.group((App)ResourceKey.codec((ResourceKey)Registries.CONFIGURED_FEATURE).fieldOf("feature").forGetter(p_304931_ -> p_304931_.feature), (App)ModFlowerBlock.propertiesCodec()).apply((Applicative)p_368432_, ModFlowerBlock::new));
    protected static final float AABB_OFFSET = 3.0f;
    protected static final VoxelShape SHAPE = Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)6.0, (double)11.0);
    private final ResourceKey<ConfiguredFeature<?, ?>> feature;

    public ModFlowerBlock(ResourceKey<ConfiguredFeature<?, ?>> feature, BlockBehaviour.Properties properties) {
        super(properties);
        this.feature = feature;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Vec3 vec3 = state.getOffset(pos);
        return SHAPE.move(vec3.x, vec3.y, vec3.z);
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (random.nextInt(25) == 0) {
            int i = 5;
            boolean j = true;
            for (BlockPos blockpos : BlockPos.betweenClosed((BlockPos)pos.offset(-4, -1, -4), (BlockPos)pos.offset(4, 1, 4))) {
                if (!level.getBlockState(blockpos).is((Block)this) || --i > 0) continue;
                return;
            }
            BlockPos blockpos1 = pos.offset(random.nextInt(3) - 1, random.nextInt(2) - random.nextInt(2), random.nextInt(3) - 1);
            for (int k = 0; k < 4; ++k) {
                if (level.isEmptyBlock(blockpos1) && state.canSurvive((LevelReader)level, blockpos1)) {
                    pos = blockpos1;
                }
                blockpos1 = pos.offset(random.nextInt(3) - 1, random.nextInt(2) - random.nextInt(2), random.nextInt(3) - 1);
            }
            if (level.isEmptyBlock(blockpos1) && state.canSurvive((LevelReader)level, blockpos1)) {
                level.setBlock(blockpos1, state, 2);
            }
        }
    }

    protected boolean mayPlaceOn(BlockState state, BlockGetter level, BlockPos pos) {
        return state.isSolidRender();
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos blockpos = pos.below();
        BlockState blockstate = level.getBlockState(blockpos);
        return this.mayPlaceOn(blockstate, (BlockGetter)level, blockpos);
    }

    public boolean growMushroom(ServerLevel level, BlockPos pos, BlockState state, RandomSource random) {
        Optional<Holder> optional = level.registryAccess().lookupOrThrow(Registries.CONFIGURED_FEATURE).get(this.feature);
        BlockGrowFeatureEvent event = EventHooks.fireBlockGrowFeature((LevelAccessor)level, (RandomSource)random, (BlockPos)pos, (Holder)optional.orElse(null));
        if (event.isCanceled()) {
            return false;
        }
        optional = Optional.ofNullable(event.getFeature());
        if (optional.isEmpty()) {
            return false;
        }
        level.removeBlock(pos, false);
        if (((ConfiguredFeature)optional.get().value()).place((WorldGenLevel)level, level.getChunkSource().getGenerator(), random, pos)) {
            return true;
        }
        level.setBlock(pos, state, 3);
        return false;
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        return true;
    }

    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return (double)random.nextFloat() < 0.4;
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        this.growMushroom(level, pos, state, random);
    }
}

