/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.creaking_expanded.variants;

import com.belgie.creaking_expanded.registry.VariantsRegistry;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.storage.loot.LootTable;

public class AncientSpriteVariant {
    public static final Codec<AncientSpriteVariant> DIRECT_CODEC = RecordCodecBuilder.create(p_332779_ -> p_332779_.group((App)ResourceLocation.CODEC.fieldOf("texture").forGetter(p_335261_ -> p_335261_.Texture), (App)ResourceLocation.CODEC.fieldOf("eye_texture").forGetter(p_335261_ -> p_335261_.EyeTexture), (App)Item.CODEC.fieldOf("feeding_item").forGetter(p_335263_ -> p_335263_.item), (App)ResourceKey.codec((ResourceKey)Registries.LOOT_TABLE).fieldOf("finished_eating_loot_table").forGetter(p_335263_ -> p_335263_.table), (App)Codec.BOOL.fieldOf("takes_damage").forGetter(p_335263_ -> p_335263_.takes_damage), (App)ExtraCodecs.intRange((int)0, (int)Integer.MAX_VALUE).fieldOf("cooldown").forGetter(p_335263_ -> p_335263_.cooldown)).apply((Applicative)p_332779_, AncientSpriteVariant::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, AncientSpriteVariant> DIRECT_STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, AncientSpriteVariant::Texture, (StreamCodec)ResourceLocation.STREAM_CODEC, AncientSpriteVariant::EyeTexture, (StreamCodec)ByteBufCodecs.holderRegistry((ResourceKey)Registries.ITEM), AncientSpriteVariant::Item, (StreamCodec)ResourceKey.streamCodec((ResourceKey)Registries.LOOT_TABLE), AncientSpriteVariant::Loottable, (StreamCodec)ByteBufCodecs.BOOL, AncientSpriteVariant::TakesDamage, (StreamCodec)ByteBufCodecs.INT, AncientSpriteVariant::cooldown, AncientSpriteVariant::new);
    public static final Codec<Holder<AncientSpriteVariant>> CODEC = RegistryFileCodec.create(VariantsRegistry.ANCIENT_SPRITE_VARIANT_REGISTRY_KEY, DIRECT_CODEC);
    public static final StreamCodec<RegistryFriendlyByteBuf, Holder<AncientSpriteVariant>> STREAM_CODEC = ByteBufCodecs.holder(VariantsRegistry.ANCIENT_SPRITE_VARIANT_REGISTRY_KEY, DIRECT_STREAM_CODEC);
    public final ResourceLocation Texture;
    public final ResourceLocation EyeTexture;
    public final ResourceKey<LootTable> table;
    public final Holder<Item> item;
    public final ResourceLocation TextureFull;
    public final ResourceLocation EyeTextureFull;
    public final boolean takes_damage;
    public final int cooldown;

    public AncientSpriteVariant(ResourceLocation texture, ResourceLocation eyetexture, Holder<Item> item, ResourceKey<LootTable> table, boolean takes_damage, int cooldown) {
        this.Texture = texture;
        this.TextureFull = AncientSpriteVariant.fullTextureId(texture);
        this.item = item;
        this.table = table;
        this.takes_damage = takes_damage;
        this.cooldown = cooldown;
        this.EyeTexture = eyetexture;
        this.EyeTextureFull = AncientSpriteVariant.fullTextureId(eyetexture);
    }

    public static ResourceLocation fullTextureId(ResourceLocation texture) {
        return texture.withPath(p_335262_ -> "textures/" + p_335262_ + ".png");
    }

    public ResourceLocation Texture() {
        return this.TextureFull;
    }

    public ResourceLocation EyeTexture() {
        return this.EyeTextureFull;
    }

    public Holder<Item> Item() {
        return this.item;
    }

    public ResourceKey<LootTable> Loottable() {
        return this.table;
    }

    public boolean TakesDamage() {
        return this.takes_damage;
    }

    public int cooldown() {
        return this.cooldown;
    }

    public boolean equals(Object other) {
        boolean var10000;
        if (other == this) {
            return true;
        }
        if (other instanceof AncientSpriteVariant) {
            AncientSpriteVariant CreakingVariant = (AncientSpriteVariant)other;
            var10000 = Objects.equals(this.Texture, CreakingVariant.Texture) && Objects.equals(this.item, CreakingVariant.item) && Objects.equals(this.table, CreakingVariant.table) && Objects.equals(this.takes_damage, CreakingVariant.takes_damage) && Objects.equals(this.cooldown, CreakingVariant.cooldown);
        } else {
            var10000 = false;
        }
        return var10000;
    }

    public int hashCode() {
        int i = 1;
        i = 31 * i + this.Texture.hashCode();
        return i;
    }
}

