/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.creaking_expanded.blocks;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.redstone.Orientation;

public class MyrrhBlock
extends Block {
    public static final MapCodec<MyrrhBlock> CODEC = MyrrhBlock.simpleCodec(MyrrhBlock::new);
    public static final IntegerProperty AGE;
    public static final BooleanProperty ACTIVE;

    public MapCodec<MyrrhBlock> codec() {
        return CODEC;
    }

    public MyrrhBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(false))).setValue((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean movedByPiston) {
        level.scheduleTick(pos, (Block)this, Mth.nextInt((RandomSource)level.getRandom(), (int)60, (int)120));
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if ((random.nextInt(8) == 0 || this.fewerNeigboursThan((BlockGetter)level, pos, 4)) && this.slightlyMelt(state, (Level)level, pos)) {
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            for (Direction direction : Direction.values()) {
                blockpos$mutableblockpos.setWithOffset((Vec3i)pos, direction);
                BlockState blockstate = level.getBlockState((BlockPos)blockpos$mutableblockpos);
                if (!blockstate.is((Block)this) || this.slightlyMelt(blockstate, (Level)level, (BlockPos)blockpos$mutableblockpos)) continue;
                level.scheduleTick((BlockPos)blockpos$mutableblockpos, (Block)this, Mth.nextInt((RandomSource)random, (int)120, (int)140));
            }
        } else {
            level.scheduleTick(pos, (Block)this, Mth.nextInt((RandomSource)random, (int)120, (int)140));
        }
    }

    public void stepOn(Level level, BlockPos pos, BlockState state, Entity entity) {
        if (((Boolean)state.getValue((Property)ACTIVE)).booleanValue() && !entity.isSteppingCarefully() && entity instanceof LivingEntity) {
            entity.hurt(level.damageSources().magic(), 2.0f);
        }
        super.stepOn(level, pos, state, entity);
    }

    private boolean slightlyMelt(BlockState state, Level level, BlockPos pos) {
        int i = (Integer)state.getValue((Property)AGE);
        if (i < 3 && ((Boolean)state.getValue((Property)ACTIVE)).booleanValue()) {
            level.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(i + 1)), 2);
            return false;
        }
        this.melt(state, level, pos);
        return true;
    }

    protected void neighborChanged(BlockState p_53579_, Level p_53580_, BlockPos p_53581_, Block p_53582_, @Nullable Orientation p_365079_, boolean p_53584_) {
        if (p_53582_.defaultBlockState().is((Block)this) && this.fewerNeigboursThan((BlockGetter)p_53580_, p_53581_, 2)) {
            this.melt(p_53579_, p_53580_, p_53581_);
        }
        super.neighborChanged(p_53579_, p_53580_, p_53581_, p_53582_, p_365079_, p_53584_);
    }

    private boolean fewerNeigboursThan(BlockGetter level, BlockPos pos, int neighborsRequired) {
        int i = 0;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (Direction direction : Direction.values()) {
            blockpos$mutableblockpos.setWithOffset((Vec3i)pos, direction);
            if (!level.getBlockState((BlockPos)blockpos$mutableblockpos).is((Block)this) || ++i < neighborsRequired) continue;
            return false;
        }
        return true;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AGE, ACTIVE});
    }

    protected ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state, boolean p_386722_) {
        return ItemStack.EMPTY;
    }

    protected void melt(BlockState state, Level level, BlockPos pos) {
        if (level.dimensionType().ultraWarm()) {
            level.removeBlock(pos, false);
        } else {
            level.setBlockAndUpdate(pos, (BlockState)((BlockState)state.setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(false))).setValue((Property)AGE, (Comparable)Integer.valueOf(0)));
            level.neighborChanged(pos, ((BlockState)((BlockState)state.setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(false))).setValue((Property)AGE, (Comparable)Integer.valueOf(0))).getBlock(), (Orientation)null);
        }
    }

    static {
        ACTIVE = BlockStateProperties.ATTACHED;
        AGE = BlockStateProperties.AGE_3;
    }
}

