/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.creaking_expanded.blocks;

import com.belgie.creaking_expanded.blocks.EyeShroomBlock;
import com.belgie.creaking_expanded.registry.BlockRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class PottedEyeBlock
extends FlowerPotBlock {
    public PottedEyeBlock(Block potted, BlockBehaviour.Properties properties) {
        super(potted, properties);
    }

    protected void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (this.isRandomlyTicking(state) && world.dimensionType().natural()) {
            boolean bl2;
            boolean bl = this.getPotted() == BlockRegistry.OPEN_EYESHROOM.get();
            boolean bl3 = bl2 = world.dimensionType().natural() && world.isMoonVisible();
            if (bl != bl2) {
                world.setBlock(pos, this.getToggledState(state), 3);
                EyeShroomBlock.Type eyeblossomState = EyeShroomBlock.Type.fromBoolean(bl).transform();
                eyeblossomState.spawnTransformParticle(world, pos, random);
                world.playSound((Entity)((Player)null), pos, eyeblossomState.longSwitchSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
        super.randomTick(state, world, pos, random);
    }

    public BlockState getToggledState(BlockState state) {
        if (state.is((Block)BlockRegistry.POTTED_OPEN_EYESHROOM.get())) {
            return ((Block)BlockRegistry.POTTED_CLOSED_EYESHROOM.get()).defaultBlockState();
        }
        return state.is((Block)BlockRegistry.POTTED_CLOSED_EYESHROOM.get()) ? ((Block)BlockRegistry.POTTED_OPEN_EYESHROOM.get()).defaultBlockState() : state;
    }
}

