/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.creaking_expanded.blocks;

import com.belgie.creaking_expanded.blockentity.ResinCampfireBlockEntity;
import com.belgie.creaking_expanded.registry.BlockEntityRegistry;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipePropertySet;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ResinCampfireBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final MapCodec<ResinCampfireBlock> CODEC = RecordCodecBuilder.mapCodec(p_368408_ -> p_368408_.group((App)Codec.BOOL.fieldOf("spawn_particles").forGetter(p_304361_ -> p_304361_.spawnParticles), (App)Codec.intRange((int)0, (int)1000).fieldOf("fire_damage").forGetter(p_304360_ -> p_304360_.fireDamage), (App)ResinCampfireBlock.propertiesCodec()).apply((Applicative)p_368408_, ResinCampfireBlock::new));
    protected static final VoxelShape SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0);
    public static final BooleanProperty LIT = BlockStateProperties.LIT;
    public static final BooleanProperty SIGNAL_FIRE = BlockStateProperties.SIGNAL_FIRE;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final EnumProperty<Direction> FACING = BlockStateProperties.HORIZONTAL_FACING;
    private static final VoxelShape VIRTUAL_FENCE_POST = Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private static final int SMOKE_DISTANCE = 5;
    private final boolean spawnParticles;
    private final int fireDamage;

    public MapCodec<ResinCampfireBlock> codec() {
        return CODEC;
    }

    public ResinCampfireBlock(boolean spawnParticles, int fireDamage, BlockBehaviour.Properties properties) {
        super(properties);
        this.spawnParticles = spawnParticles;
        this.fireDamage = fireDamage;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)LIT, (Comparable)Boolean.valueOf(true))).setValue((Property)SIGNAL_FIRE, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue(FACING, (Comparable)Direction.NORTH));
    }

    protected InteractionResult useItemOn(ItemStack p_316347_, BlockState p_51274_, Level p_51275_, BlockPos p_51276_, Player p_51277_, InteractionHand p_51278_, BlockHitResult p_51279_) {
        BlockEntity var9 = p_51275_.getBlockEntity(p_51276_);
        if (var9 instanceof ResinCampfireBlockEntity) {
            ResinCampfireBlockEntity campfireblockentity = (ResinCampfireBlockEntity)var9;
            ItemStack itemstack = p_51277_.getItemInHand(p_51278_);
            if (p_51275_.recipeAccess().propertySet(RecipePropertySet.CAMPFIRE_INPUT).test(itemstack)) {
                ServerLevel serverlevel;
                if (p_51275_ instanceof ServerLevel && campfireblockentity.placeFood(serverlevel = (ServerLevel)p_51275_, (LivingEntity)p_51277_, itemstack)) {
                    p_51277_.awardStat(Stats.INTERACT_WITH_CAMPFIRE);
                    return InteractionResult.SUCCESS_SERVER;
                }
                return InteractionResult.CONSUME;
            }
        }
        return InteractionResult.TRY_WITH_EMPTY_HAND;
    }

    protected void entityInside(BlockState p_51269_, Level p_51270_, BlockPos p_51271_, Entity p_51272_, InsideBlockEffectApplier p_395061_) {
        if (((Boolean)p_51269_.getValue((Property)LIT)).booleanValue() && p_51272_ instanceof LivingEntity) {
            p_51272_.hurt(p_51270_.damageSources().campfire(), (float)this.fireDamage);
        }
        super.entityInside(p_51269_, p_51270_, p_51271_, p_51272_, p_395061_);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos blockpos;
        Level levelaccessor = context.getLevel();
        boolean flag = levelaccessor.getFluidState(blockpos = context.getClickedPos()).getType() == Fluids.WATER;
        return (BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag))).setValue((Property)SIGNAL_FIRE, (Comparable)Boolean.valueOf(this.isSmokeSource(levelaccessor.getBlockState(blockpos.below()))))).setValue((Property)LIT, (Comparable)Boolean.valueOf(context.getLevel().isMoonVisible()))).setValue(FACING, (Comparable)context.getHorizontalDirection());
    }

    protected BlockState updateShape(BlockState p_51298_, LevelReader p_374562_, ScheduledTickAccess p_374439_, BlockPos p_51302_, Direction p_51299_, BlockPos p_51303_, BlockState p_51300_, RandomSource p_374147_) {
        if (((Boolean)p_51298_.getValue((Property)WATERLOGGED)).booleanValue()) {
            p_374439_.scheduleTick(p_51302_, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay(p_374562_));
        }
        return p_51299_ == Direction.DOWN ? (BlockState)p_51298_.setValue((Property)SIGNAL_FIRE, (Comparable)Boolean.valueOf(this.isSmokeSource(p_51300_))) : super.updateShape(p_51298_, p_374562_, p_374439_, p_51302_, p_51299_, p_51303_, p_51300_, p_374147_);
    }

    private boolean isSmokeSource(BlockState state) {
        return state.is(Blocks.HAY_BLOCK);
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (((Boolean)state.getValue((Property)LIT)).booleanValue()) {
            if (random.nextInt(10) == 0) {
                level.playLocalSound((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.CAMPFIRE_CRACKLE, SoundSource.BLOCKS, 0.5f + random.nextFloat(), random.nextFloat() * 0.7f + 0.6f, false);
            }
            if (this.spawnParticles && random.nextInt(5) == 0) {
                for (int i = 0; i < random.nextInt(1) + 1; ++i) {
                    level.addParticle((ParticleOptions)ParticleTypes.LAVA, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, (double)(random.nextFloat() / 2.0f), 5.0E-5, (double)(random.nextFloat() / 2.0f));
                }
            }
        }
    }

    public boolean placeLiquid(LevelAccessor level, BlockPos pos, BlockState state, FluidState fluidState) {
        if (!((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue() && fluidState.getType() == Fluids.WATER) {
            boolean flag = (Boolean)state.getValue((Property)LIT);
            if (flag && !level.isClientSide()) {
                level.playSound((Entity)((Player)null), pos, SoundEvents.GENERIC_EXTINGUISH_FIRE, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            level.setBlock(pos, (BlockState)((BlockState)state.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true))).setValue((Property)LIT, (Comparable)Boolean.valueOf(false)), 3);
            level.scheduleTick(pos, fluidState.getType(), fluidState.getType().getTickDelay((LevelReader)level));
            return true;
        }
        return false;
    }

    public static void makeParticles(Level level, BlockPos pos, boolean isSignalFire, boolean spawnExtraSmoke) {
        RandomSource randomsource = level.getRandom();
        SimpleParticleType simpleparticletype = isSignalFire ? ParticleTypes.CAMPFIRE_SIGNAL_SMOKE : ParticleTypes.CAMPFIRE_COSY_SMOKE;
        level.addAlwaysVisibleParticle((ParticleOptions)simpleparticletype, true, (double)pos.getX() + 0.5 + randomsource.nextDouble() / 3.0 * (double)(randomsource.nextBoolean() ? 1 : -1), (double)pos.getY() + randomsource.nextDouble() + randomsource.nextDouble(), (double)pos.getZ() + 0.5 + randomsource.nextDouble() / 3.0 * (double)(randomsource.nextBoolean() ? 1 : -1), 0.0, 0.07, 0.0);
        if (spawnExtraSmoke) {
            level.addParticle((ParticleOptions)ParticleTypes.SMOKE, (double)pos.getX() + 0.5 + randomsource.nextDouble() / 4.0 * (double)(randomsource.nextBoolean() ? 1 : -1), (double)pos.getY() + 0.4, (double)pos.getZ() + 0.5 + randomsource.nextDouble() / 4.0 * (double)(randomsource.nextBoolean() ? 1 : -1), 0.0, 0.005, 0.0);
        }
    }

    public static boolean isSmokeyPos(Level level, BlockPos pos) {
        for (int i = 1; i <= 5; ++i) {
            BlockPos blockpos = pos.below(i);
            BlockState blockstate = level.getBlockState(blockpos);
            if (ResinCampfireBlock.isLitCampfire(blockstate)) {
                return true;
            }
            boolean flag = Shapes.joinIsNotEmpty((VoxelShape)VIRTUAL_FENCE_POST, (VoxelShape)blockstate.getCollisionShape((BlockGetter)level, blockpos, CollisionContext.empty()), (BooleanOp)BooleanOp.AND);
            if (!flag) continue;
            BlockState blockstate1 = level.getBlockState(blockpos.below());
            return ResinCampfireBlock.isLitCampfire(blockstate1);
        }
        return false;
    }

    public static boolean isLitCampfire(BlockState state) {
        return state.hasProperty((Property)LIT) && (Boolean)state.getValue((Property)LIT) != false;
    }

    protected FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    protected BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue(FACING, (Comparable)rot.rotate((Direction)state.getValue(FACING)));
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue(FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{LIT, SIGNAL_FIRE, WATERLOGGED, FACING});
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new ResinCampfireBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            if (((Boolean)state.getValue((Property)LIT)).booleanValue()) {
                RecipeManager.CachedCheck cachedcheck = RecipeManager.createCheck((RecipeType)RecipeType.CAMPFIRE_COOKING);
                return ResinCampfireBlock.createTickerHelper(blockEntityType, BlockEntityRegistry.RESIN_CAMPFIRE.get(), (p_379259_, p_379260_, p_379261_, p_379262_) -> ResinCampfireBlockEntity.cookTick(serverlevel, p_379260_, p_379261_, p_379262_, (RecipeManager.CachedCheck<SingleRecipeInput, CampfireCookingRecipe>)cachedcheck));
            }
            return ResinCampfireBlock.createTickerHelper(blockEntityType, BlockEntityRegistry.RESIN_CAMPFIRE.get(), ResinCampfireBlockEntity::cooldownTick);
        }
        return (Boolean)state.getValue((Property)LIT) != false ? ResinCampfireBlock.createTickerHelper(blockEntityType, BlockEntityRegistry.RESIN_CAMPFIRE.get(), ResinCampfireBlockEntity::particleTick) : null;
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }
}

