/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.creaking_expanded.blocks;

import com.belgie.creaking_expanded.registry.BlockRegistry;
import com.belgie.creaking_expanded.registry.ItemRegistry;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;

public class TwilightBushBlock
extends BushBlock
implements BonemealableBlock {
    public static final MapCodec<TwilightBushBlock> CODEC = TwilightBushBlock.simpleCodec(TwilightBushBlock::new);
    private static final float HURT_SPEED_THRESHOLD = 0.003f;
    public static final int MAX_AGE = 3;
    public static final IntegerProperty AGE = IntegerProperty.create((String)"age", (int)0, (int)4);
    private static final VoxelShape AGE_0;
    private static final VoxelShape AGE_1;
    private static final VoxelShape AGE_2;
    private static final VoxelShape AGE_3;
    public static final BooleanProperty DAWN_BERRIES;
    public static final BooleanProperty DUSK_BERRIES;

    public TwilightBushBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)DUSK_BERRIES, (Comparable)Boolean.valueOf(false))).setValue((Property)DAWN_BERRIES, (Comparable)Boolean.valueOf(false))).setValue((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    protected ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state, boolean p_388022_) {
        return !((Level)level).isMoonVisible() ? new ItemStack((ItemLike)ItemRegistry.DAWN_BERRIES.get()) : new ItemStack((ItemLike)ItemRegistry.DUSK_BERRIES.get());
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if ((Integer)state.getValue((Property)AGE) == 0) {
            return AGE_0;
        }
        if ((Integer)state.getValue((Property)AGE) == 1) {
            return AGE_1;
        }
        if ((Integer)state.getValue((Property)AGE) == 2) {
            return AGE_2;
        }
        return AGE_3;
    }

    protected boolean isRandomlyTicking(BlockState state) {
        return (Integer)state.getValue((Property)AGE) < 3 || (Boolean)state.getValue((Property)DAWN_BERRIES) == false || (Boolean)state.getValue((Property)DUSK_BERRIES) == false;
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockState blockstate;
        int i = (Integer)state.getValue((Property)AGE);
        if (i < 3 && level.getRawBrightness(pos.above(), 0) >= 9 && ForgeHooks.onCropsGrowPre((Level)level, (BlockPos)pos, (BlockState)state, (random.nextInt(5) == 0 ? 1 : 0) != 0)) {
            blockstate = (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(i + 1));
            level.setBlock(pos, blockstate, 2);
            ForgeHooks.onCropsGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((BlockState)blockstate));
        }
        if (i == 3 && level.getRawBrightness(pos.above(), 0) >= 9 && ForgeHooks.onCropsGrowPre((Level)level, (BlockPos)pos, (BlockState)state, (random.nextInt(5) == 0 ? 1 : 0) != 0)) {
            if (level.isMoonVisible() && !((Boolean)state.getValue((Property)DAWN_BERRIES)).booleanValue()) {
                blockstate = (BlockState)((BlockState)state.setValue((Property)DUSK_BERRIES, (Comparable)Boolean.valueOf(true))).setValue((Property)AGE, (Comparable)Integer.valueOf(4));
                level.setBlock(pos, blockstate, 2);
                ForgeHooks.onCropsGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
                level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((BlockState)blockstate));
            }
            if (!level.isMoonVisible() && !((Boolean)state.getValue((Property)DUSK_BERRIES)).booleanValue()) {
                blockstate = (BlockState)((BlockState)state.setValue((Property)DAWN_BERRIES, (Comparable)Boolean.valueOf(true))).setValue((Property)AGE, (Comparable)Integer.valueOf(4));
                level.setBlock(pos, blockstate, 2);
                ForgeHooks.onCropsGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
                level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((BlockState)blockstate));
            }
        }
    }

    protected InteractionResult useItemOn(ItemStack p_316636_, BlockState p_316295_, Level p_316812_, BlockPos p_316380_, Player p_316731_, InteractionHand p_316188_, BlockHitResult p_316626_) {
        int i = (Integer)p_316295_.getValue((Property)AGE);
        boolean flag = i == 4;
        return !flag && p_316636_.is(Items.BONE_MEAL) ? InteractionResult.PASS : super.useItemOn(p_316636_, p_316295_, p_316812_, p_316380_, p_316731_, p_316188_, p_316626_);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        boolean flag;
        int i = (Integer)state.getValue((Property)AGE);
        boolean bl = flag = i == 3;
        if (((Boolean)state.getValue((Property)DAWN_BERRIES)).booleanValue() || ((Boolean)state.getValue((Property)DUSK_BERRIES)).booleanValue()) {
            int j = 1 + level.random.nextInt(2);
            if (((Boolean)state.getValue((Property)DAWN_BERRIES)).booleanValue()) {
                TwilightBushBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)ItemRegistry.DAWN_BERRIES.get(), j + (flag ? 1 : 0)));
            }
            if (((Boolean)state.getValue((Property)DUSK_BERRIES)).booleanValue()) {
                TwilightBushBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)ItemRegistry.DUSK_BERRIES.get(), j + (flag ? 1 : 0)));
            }
            level.playSound((Entity)((Player)null), pos, SoundEvents.SWEET_BERRY_BUSH_PICK_BERRIES, SoundSource.BLOCKS, 1.0f, 0.8f + level.random.nextFloat() * 0.4f);
            BlockState blockstate = (BlockState)((BlockState)((BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(3))).setValue((Property)DAWN_BERRIES, (Comparable)Boolean.valueOf(false))).setValue((Property)DUSK_BERRIES, (Comparable)Boolean.valueOf(false));
            level.setBlock(pos, blockstate, 2);
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)player, (BlockState)blockstate));
            return InteractionResult.SUCCESS;
        }
        return super.useWithoutItem(state, level, pos, player, hitResult);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AGE, DAWN_BERRIES, DUSK_BERRIES});
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        return (Integer)state.getValue((Property)AGE) < 4;
    }

    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        int i = Math.min(3, (Integer)state.getValue((Property)AGE) + 1);
        if ((Integer)state.getValue((Property)AGE) < 3) {
            level.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(i)), 2);
        } else if (level.isMoonVisible() && !((Boolean)state.getValue((Property)DAWN_BERRIES)).booleanValue()) {
            BlockState blockstate = (BlockState)((BlockState)state.setValue((Property)DUSK_BERRIES, (Comparable)Boolean.valueOf(true))).setValue((Property)AGE, (Comparable)Integer.valueOf(4));
            level.setBlock(pos, blockstate, 2);
        } else if (!level.isMoonVisible() && !((Boolean)state.getValue((Property)DUSK_BERRIES)).booleanValue()) {
            BlockState blockstate = (BlockState)((BlockState)state.setValue((Property)DAWN_BERRIES, (Comparable)Boolean.valueOf(true))).setValue((Property)AGE, (Comparable)Integer.valueOf(4));
            level.setBlock(pos, blockstate, 2);
        }
    }

    static {
        DAWN_BERRIES = BlockRegistry.DAWN_BERRIES;
        DUSK_BERRIES = BlockRegistry.DUSK_BERRIES;
        AGE_0 = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)8.0, (double)13.0);
        AGE_1 = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)11.0, (double)14.0);
        AGE_2 = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);
        AGE_3 = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    }
}

