/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.creaking_expanded.entity;

import com.belgie.creaking_expanded.registry.EntityRegistry;
import com.belgie.creaking_expanded.registry.ParticleRegistry;
import com.belgie.creaking_expanded.registry.VariantsRegistry;
import com.belgie.creaking_expanded.variants.PaleEyeVariant;
import com.belgie.creaking_expanded.variants.PaleEyeVariants;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.InterpolationHandler;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.variant.VariantUtils;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.eventbus.internal.Event;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class PaleEyeEntity
extends AbstractGolem
implements Enemy {
    private static final ResourceLocation COVERED_ARMOR_MODIFIER_ID = ResourceLocation.withDefaultNamespace((String)"covered");
    private static final AttributeModifier COVERED_ARMOR_MODIFIER;
    protected static final EntityDataAccessor<Direction> DATA_ATTACH_FACE_ID;
    protected static final EntityDataAccessor<Byte> DATA_PEEK_ID;
    private static final EntityDataAccessor<Integer> DATA_ID_ATTACK_TARGET;
    private static final EntityDataAccessor<Holder<PaleEyeVariant>> DATA_VARIANT_ID;
    protected static final int ATTACK_TIME = 30;
    static final Vector3f FORWARD;
    private float currentPeekAmountO;
    private float currentPeekAmount;
    @Nullable
    private BlockPos clientOldAttachPosition;
    private int clientSideTeleportInterpolation;
    @Nullable
    private LivingEntity clientSideCachedAttackTarget;
    private int clientSideAttackTime;

    public PaleEyeEntity(EntityType<? extends PaleEyeEntity> entityType, Level level) {
        super(entityType, level);
        this.xpReward = 5;
        this.lookControl = new ShulkerLookControl((Mob)this);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f, 0.02f, true));
        this.goalSelector.addGoal(4, (Goal)new PaleEyeAttackGoal(this));
        this.goalSelector.addGoal(7, (Goal)new ShulkerPeekGoal());
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{((Object)((Object)this)).getClass()}).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new ShulkerNearestAttackGoal(this));
        this.targetSelector.addGoal(3, (Goal)new ShulkerDefenseAttackGoal(this));
    }

    public Holder<PaleEyeVariant> getVariant() {
        return (Holder)this.entityData.get(DATA_VARIANT_ID);
    }

    public void setVariant(Holder<PaleEyeVariant> p_332777_) {
        this.entityData.set(DATA_VARIANT_ID, p_332777_);
    }

    public ResourceLocation getTexture() {
        PaleEyeVariant variant = (PaleEyeVariant)this.getVariant().value();
        return variant.Texture();
    }

    public ResourceLocation getEyeTexture() {
        PaleEyeVariant variant = (PaleEyeVariant)this.getVariant().value();
        return variant.EyeTexture();
    }

    public ResourceLocation getBeamTexture() {
        PaleEyeVariant variant = (PaleEyeVariant)this.getVariant().value();
        return variant.BeamTexture();
    }

    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }

    public SoundSource getSoundSource() {
        return SoundSource.HOSTILE;
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.SHULKER_AMBIENT;
    }

    public void playAmbientSound() {
        if (!this.isClosed()) {
            super.playAmbientSound();
        }
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.SHULKER_DEATH;
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return this.isClosed() ? SoundEvents.SHULKER_HURT_CLOSED : SoundEvents.SHULKER_HURT;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_ATTACH_FACE_ID, (Object)Direction.DOWN);
        builder.define(DATA_PEEK_ID, (Object)0);
        builder.define(DATA_ID_ATTACK_TARGET, (Object)0);
        RegistryAccess registryaccess = this.registryAccess();
        Registry registry = registryaccess.lookupOrThrow(VariantsRegistry.PALE_EYE_VARIANT_REGISTRY_KEY);
        EntityDataAccessor<Holder<PaleEyeVariant>> var10001 = DATA_VARIANT_ID;
        Optional var10002 = registry.get(PaleEyeVariants.DEFAULT);
        Objects.requireNonNull(registry);
        builder.define(var10001, (Object)((Holder)var10002.or(() -> ((Registry)registry).getAny()).orElseThrow()));
    }

    public int getAttackDuration() {
        return 30;
    }

    void setActiveAttackTarget(int activeAttackTargetId) {
        this.entityData.set(DATA_ID_ATTACK_TARGET, (Object)activeAttackTargetId);
    }

    public boolean hasActiveAttackTarget() {
        return (Integer)this.entityData.get(DATA_ID_ATTACK_TARGET) != 0;
    }

    @Nullable
    public LivingEntity getActiveAttackTarget() {
        if (!this.hasActiveAttackTarget()) {
            return null;
        }
        if (this.level().isClientSide) {
            if (this.clientSideCachedAttackTarget != null) {
                return this.clientSideCachedAttackTarget;
            }
            Entity entity = this.level().getEntity(((Integer)this.entityData.get(DATA_ID_ATTACK_TARGET)).intValue());
            if (entity instanceof LivingEntity) {
                this.clientSideCachedAttackTarget = (LivingEntity)entity;
                return this.clientSideCachedAttackTarget;
            }
            return null;
        }
        return this.getTarget();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.ATTACK_DAMAGE, 3.0).add(Attributes.MAX_HEALTH, 30.0);
    }

    protected BodyRotationControl createBodyControl() {
        return new ShulkerBodyRotationControl((Mob)this);
    }

    public void readAdditionalSaveData(ValueInput compound) {
        super.readAdditionalSaveData(compound);
        this.setAttachFace(compound.read("AttachFace", Direction.LEGACY_ID_CODEC).orElse(Direction.DOWN));
        this.entityData.set(DATA_PEEK_ID, (Object)compound.getByteOr("Peek", (byte)0));
        VariantUtils.readVariant((ValueInput)compound, VariantsRegistry.PALE_EYE_VARIANT_REGISTRY_KEY).ifPresent(this::setVariant);
    }

    public void addAdditionalSaveData(ValueOutput compound) {
        super.addAdditionalSaveData(compound);
        compound.putByte("AttachFace", (byte)this.getAttachFace().get3DDataValue());
        compound.putByte("Peek", ((Byte)this.entityData.get(DATA_PEEK_ID)).byteValue());
        this.getVariant().unwrapKey().ifPresent(p_344339_ -> compound.putString("variant", p_344339_.location().toString()));
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide && !this.isPassenger() && !this.canStayAt(this.blockPosition(), this.getAttachFace()) && ((PaleEyeVariant)this.getVariant().value()).CanTeleport()) {
            this.findNewAttachment();
        }
        if (this.updatePeekAmount()) {
            this.onPeekAmountChange();
        }
        if (this.level().isClientSide) {
            if (this.clientSideTeleportInterpolation > 0) {
                --this.clientSideTeleportInterpolation;
            } else {
                this.clientOldAttachPosition = null;
            }
        }
    }

    private void findNewAttachment() {
        Direction direction = this.findAttachableSurface(this.blockPosition());
        if (direction != null) {
            this.setAttachFace(direction);
        } else {
            this.teleportSomewhere();
        }
    }

    public void aiStep() {
        if (this.isAlive()) {
            if (this.level().isClientSide && this.hasActiveAttackTarget()) {
                LivingEntity livingentity;
                if (this.clientSideAttackTime < this.getAttackDuration()) {
                    ++this.clientSideAttackTime;
                }
                if ((livingentity = this.getActiveAttackTarget()) != null) {
                    this.getLookControl().setLookAt((Entity)livingentity, 90.0f, 90.0f);
                    this.getLookControl().tick();
                    double d5 = this.getAttackAnimationScale(0.0f);
                    double d0 = livingentity.getX() - this.getX();
                    double d1 = livingentity.getY(0.5) - this.getEyeY();
                    double d2 = livingentity.getZ() - this.getZ();
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    d0 /= d3;
                    d1 /= d3;
                    d2 /= d3;
                    double d4 = this.random.nextDouble();
                    while (d4 < d3) {
                        this.level().addParticle((ParticleOptions)ParticleRegistry.RESIN_BEAM.get(), this.getX() + d0 * (d4 += 1.8 - d5 + this.random.nextDouble() * (1.7 - d5)), this.getEyeY() + d1 * d4, this.getZ() + d2 * d4, 0.0, 0.0, 0.0);
                    }
                }
            }
            if (this.hasActiveAttackTarget()) {
                this.setYRot(this.yHeadRot);
            }
        }
        super.aiStep();
    }

    public float getAttackAnimationScale(float partialTick) {
        return ((float)this.clientSideAttackTime + partialTick) / (float)this.getAttackDuration();
    }

    public float getClientSideAttackTime() {
        return this.clientSideAttackTime;
    }

    protected AABB makeBoundingBox(Vec3 p_390436_) {
        float f = PaleEyeEntity.getPhysicalPeek(this.currentPeekAmount);
        Direction direction = this.getAttachFace().getOpposite();
        float f1 = this.getBbWidth() / 2.0f;
        return PaleEyeEntity.getProgressAabb(this.getScale(), direction, f).move(this.getX() - (double)f1, this.getY(), this.getZ() - (double)f1);
    }

    private static float getPhysicalPeek(float peek) {
        return 0.5f - Mth.sin((float)((0.5f + peek) * (float)Math.PI)) * 0.5f;
    }

    private boolean updatePeekAmount() {
        this.currentPeekAmountO = this.currentPeekAmount;
        float f = (float)this.getRawPeekAmount() * 0.01f;
        if (this.currentPeekAmount == f) {
            return false;
        }
        this.currentPeekAmount = this.currentPeekAmount > f ? Mth.clamp((float)(this.currentPeekAmount - 0.05f), (float)f, (float)1.0f) : Mth.clamp((float)(this.currentPeekAmount + 0.05f), (float)0.0f, (float)f);
        return true;
    }

    private void onPeekAmountChange() {
        this.reapplyPosition();
        float f = PaleEyeEntity.getPhysicalPeek(this.currentPeekAmount);
        float f1 = PaleEyeEntity.getPhysicalPeek(this.currentPeekAmountO);
        Direction direction = this.getAttachFace().getOpposite();
        float f2 = (f - f1) * this.getScale();
        if (!(f2 <= 0.0f)) {
            for (Entity entity : this.level().getEntities((Entity)this, PaleEyeEntity.getProgressDeltaAabb(this.getScale(), direction, f1, f).move(this.getX() - 0.5, this.getY(), this.getZ() - 0.5), EntitySelector.NO_SPECTATORS.and(p_149771_ -> !p_149771_.isPassengerOfSameVehicle((Entity)this)))) {
                if (entity instanceof PaleEyeEntity || entity.noPhysics) continue;
                entity.move(MoverType.SHULKER, new Vec3((double)(f2 * (float)direction.getStepX()), (double)(f2 * (float)direction.getStepY()), (double)(f2 * (float)direction.getStepZ())));
            }
        }
    }

    public static AABB getProgressAabb(float scale, Direction expansionDirection, float peek) {
        return PaleEyeEntity.getProgressDeltaAabb(scale, expansionDirection, -1.0f, peek);
    }

    public static AABB getProgressDeltaAabb(float scale, Direction expansionDirection, float currentPeek, float oldPeek) {
        AABB aabb = new AABB(0.0, 0.0, 0.0, (double)scale, (double)scale, (double)scale);
        double d0 = Math.max(currentPeek, oldPeek);
        double d1 = Math.min(currentPeek, oldPeek);
        return aabb.expandTowards((double)expansionDirection.getStepX() * d0 * (double)scale, (double)expansionDirection.getStepY() * d0 * (double)scale, (double)expansionDirection.getStepZ() * d0 * (double)scale).contract((double)(-expansionDirection.getStepX()) * (1.0 + d1) * (double)scale, (double)(-expansionDirection.getStepY()) * (1.0 + d1) * (double)scale, (double)(-expansionDirection.getStepZ()) * (1.0 + d1) * (double)scale);
    }

    public boolean startRiding(Entity entity, boolean force) {
        if (this.level().isClientSide()) {
            this.clientOldAttachPosition = null;
            this.clientSideTeleportInterpolation = 0;
        }
        this.setAttachFace(Direction.DOWN);
        return super.startRiding(entity, force);
    }

    public void stopRiding() {
        super.stopRiding();
        if (this.level().isClientSide) {
            this.clientOldAttachPosition = this.blockPosition();
        }
        this.yBodyRotO = 0.0f;
        this.yBodyRot = 0.0f;
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor p_149780_, DifficultyInstance p_149781_, EntitySpawnReason p_363202_, @Nullable SpawnGroupData p_149783_) {
        this.setYRot(0.0f);
        this.yHeadRot = this.getYRot();
        this.setOldPosAndRot();
        Registry holder = p_149780_.registryAccess().lookupOrThrow(VariantsRegistry.PALE_EYE_VARIANT_REGISTRY_KEY);
        if (holder.getRandom(this.random).isPresent()) {
            this.setVariant((Holder<PaleEyeVariant>)((Holder)holder.getRandom(this.random).get()));
        }
        return super.finalizeSpawn(p_149780_, p_149781_, p_363202_, p_149783_);
    }

    public void move(MoverType type, Vec3 pos) {
        if (type == MoverType.SHULKER_BOX) {
            this.teleportSomewhere();
        } else {
            super.move(type, pos);
        }
    }

    public Vec3 getDeltaMovement() {
        return Vec3.ZERO;
    }

    public void setDeltaMovement(Vec3 deltaMovement) {
    }

    public void setPos(double x, double y, double z) {
        BlockPos blockpos1;
        BlockPos blockpos = this.blockPosition();
        if (this.isPassenger()) {
            super.setPos(x, y, z);
        } else {
            super.setPos((double)Mth.floor((double)x) + 0.5, (double)Mth.floor((double)(y + 0.5)), (double)Mth.floor((double)z) + 0.5);
        }
        if (this.tickCount != 0 && !(blockpos1 = this.blockPosition()).equals((Object)blockpos)) {
            this.entityData.set(DATA_PEEK_ID, (Object)0);
            this.hasImpulse = true;
            if (this.level().isClientSide && !this.isPassenger() && !blockpos1.equals((Object)this.clientOldAttachPosition)) {
                this.clientOldAttachPosition = blockpos;
                this.clientSideTeleportInterpolation = 6;
                this.xOld = this.getX();
                this.yOld = this.getY();
                this.zOld = this.getZ();
            }
        }
    }

    @Nullable
    protected Direction findAttachableSurface(BlockPos pos) {
        for (Direction direction : Direction.values()) {
            if (!this.canStayAt(pos, direction)) continue;
            return direction;
        }
        return null;
    }

    boolean canStayAt(BlockPos pos, Direction facing) {
        if (this.isPositionBlocked(pos)) {
            return true;
        }
        Direction direction = facing.getOpposite();
        if (!this.level().loadedAndEntityCanStandOnFace(pos.relative(facing), (Entity)this, direction)) {
            return false;
        }
        AABB aabb = PaleEyeEntity.getProgressAabb(this.getScale(), direction, 1.0f).move(pos).deflate(1.0E-6);
        return this.level().noCollision((Entity)this, aabb);
    }

    private boolean isPositionBlocked(BlockPos pos) {
        BlockState blockstate = this.level().getBlockState(pos);
        if (blockstate.isAir()) {
            return false;
        }
        boolean flag = blockstate.is(Blocks.MOVING_PISTON) && pos.equals((Object)this.blockPosition());
        return !flag;
    }

    protected boolean teleportSomewhere() {
        if (!this.isNoAi() && this.isAlive()) {
            BlockPos blockpos = this.blockPosition();
            for (int i = 0; i < 5; ++i) {
                BlockPos blockpos1 = blockpos.offset(Mth.randomBetweenInclusive((RandomSource)this.random, (int)-8, (int)8), Mth.randomBetweenInclusive((RandomSource)this.random, (int)-8, (int)8), Mth.randomBetweenInclusive((RandomSource)this.random, (int)-8, (int)8));
                if (blockpos1.getY() <= this.level().getMinY() || !this.level().isEmptyBlock(blockpos1) || !this.level().getWorldBorder().isWithinBounds(blockpos1) || !this.level().noCollision((Entity)this, new AABB(blockpos1).deflate(1.0E-6))) continue;
                Direction direction = this.findAttachableSurface(blockpos1);
                if (direction != null) {
                    EntityTeleportEvent.EnderEntity event = ForgeEventFactory.onEnderManTeleport((LivingEntity)this, (double)blockpos1.getX(), (double)blockpos1.getY(), (double)blockpos1.getZ());
                    if (EntityTeleportEvent.EnderEntity.BUS.post((Event)event)) {
                        direction = null;
                    }
                    blockpos1 = BlockPos.containing((double)event.getTargetX(), (double)event.getTargetY(), (double)event.getTargetZ());
                }
                if (direction == null) continue;
                this.unRide();
                this.setAttachFace(direction);
                this.playSound(SoundEvents.SHULKER_TELEPORT, 1.0f, 1.0f);
                this.setPos((double)blockpos1.getX() + 0.5, blockpos1.getY(), (double)blockpos1.getZ() + 0.5);
                this.level().gameEvent((Holder)GameEvent.TELEPORT, blockpos, GameEvent.Context.of((Entity)this));
                this.entityData.set(DATA_PEEK_ID, (Object)0);
                this.setTarget(null);
                return true;
            }
            return false;
        }
        return false;
    }

    public InterpolationHandler getInterpolation() {
        return null;
    }

    public boolean hurtServer(ServerLevel p_389623_, DamageSource p_389564_, float p_389723_) {
        if (!this.IsVariantAbleToDamage() && !p_389564_.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            if ((double)this.getHealth() < (double)this.getMaxHealth() * 0.5 && this.random.nextInt(4) == 0) {
                this.setRawPeekAmount(0);
            }
            return true;
        }
        return super.hurtServer(p_389623_, p_389564_, p_389723_);
    }

    public boolean IsVariantAbleToDamage() {
        if (((PaleEyeVariant)this.getVariant().value()).TakesDamageWhenClosed() && this.isClosed()) {
            return true;
        }
        return !this.isClosed();
    }

    private boolean isClosed() {
        return this.getRawPeekAmount() == 0;
    }

    public boolean canBeCollidedWith() {
        return this.isAlive();
    }

    public Direction getAttachFace() {
        return (Direction)this.entityData.get(DATA_ATTACH_FACE_ID);
    }

    private void setAttachFace(Direction attachFace) {
        this.entityData.set(DATA_ATTACH_FACE_ID, (Object)attachFace);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        if (DATA_ATTACH_FACE_ID.equals(key)) {
            this.setBoundingBox(this.makeBoundingBox());
        }
        if (DATA_ID_ATTACK_TARGET.equals(key)) {
            this.clientSideAttackTime = 0;
            this.clientSideCachedAttackTarget = null;
        }
        super.onSyncedDataUpdated(key);
    }

    private int getRawPeekAmount() {
        return ((Byte)this.entityData.get(DATA_PEEK_ID)).byteValue();
    }

    void setRawPeekAmount(int peekAmount) {
        if (!this.level().isClientSide) {
            this.getAttribute(Attributes.ARMOR).removeModifier(COVERED_ARMOR_MODIFIER_ID);
            if (peekAmount == 0) {
                this.getAttribute(Attributes.ARMOR).addPermanentModifier(COVERED_ARMOR_MODIFIER);
                this.playSound(SoundEvents.SHULKER_CLOSE, 1.0f, 1.0f);
                this.gameEvent((Holder)GameEvent.CONTAINER_CLOSE);
            } else {
                this.playSound(SoundEvents.SHULKER_OPEN, 1.0f, 1.0f);
                this.gameEvent((Holder)GameEvent.CONTAINER_OPEN);
            }
        }
        this.entityData.set(DATA_PEEK_ID, (Object)((byte)peekAmount));
    }

    public float getClientPeekAmount(float partialTick) {
        return Mth.lerp((float)partialTick, (float)this.currentPeekAmountO, (float)this.currentPeekAmount);
    }

    public void recreateFromPacket(ClientboundAddEntityPacket packet) {
        super.recreateFromPacket(packet);
        this.yBodyRot = 0.0f;
        this.yBodyRotO = 0.0f;
    }

    public int getMaxHeadXRot() {
        return 180;
    }

    public int getMaxHeadYRot() {
        return 180;
    }

    public void push(Entity entity) {
    }

    @Nullable
    public Vec3 getRenderPosition(float p_149767_) {
        if (this.clientOldAttachPosition != null && this.clientSideTeleportInterpolation > 0) {
            double d0 = (double)((float)this.clientSideTeleportInterpolation - p_149767_) / 6.0;
            d0 *= d0;
            BlockPos blockpos = this.blockPosition();
            double d1 = (double)(blockpos.getX() - this.clientOldAttachPosition.getX()) * (d0 *= (double)this.getScale());
            double d2 = (double)(blockpos.getY() - this.clientOldAttachPosition.getY()) * d0;
            double d3 = (double)(blockpos.getZ() - this.clientOldAttachPosition.getZ()) * d0;
            return new Vec3(-d1, -d2, -d3);
        }
        return null;
    }

    protected float sanitizeScale(float scale) {
        return Math.min(scale, 3.0f);
    }

    static {
        DATA_VARIANT_ID = SynchedEntityData.defineId(PaleEyeEntity.class, EntityRegistry.PALE_EYE_VARIANT.get());
        COVERED_ARMOR_MODIFIER = new AttributeModifier(COVERED_ARMOR_MODIFIER_ID, 20.0, AttributeModifier.Operation.ADD_VALUE);
        DATA_ATTACH_FACE_ID = SynchedEntityData.defineId(PaleEyeEntity.class, (EntityDataSerializer)EntityDataSerializers.DIRECTION);
        DATA_PEEK_ID = SynchedEntityData.defineId(PaleEyeEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
        DATA_ID_ATTACK_TARGET = SynchedEntityData.defineId(PaleEyeEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
        FORWARD = (Vector3f)Util.make(() -> {
            Vec3i vec3i = Direction.SOUTH.getUnitVec3i();
            return new Vector3f((float)vec3i.getX(), (float)vec3i.getY(), (float)vec3i.getZ());
        });
    }

    class ShulkerLookControl
    extends LookControl {
        public ShulkerLookControl(Mob mob) {
            super(mob);
        }

        protected void clampHeadRotationToBody() {
        }

        protected Optional<Float> getYRotD() {
            Direction direction = PaleEyeEntity.this.getAttachFace().getOpposite();
            Vector3f vector3f = direction.getRotation().transform(new Vector3f((Vector3fc)FORWARD));
            Vec3i vec3i = direction.getUnitVec3i();
            Vector3f vector3f1 = new Vector3f((float)vec3i.getX(), (float)vec3i.getY(), (float)vec3i.getZ());
            vector3f1.cross((Vector3fc)vector3f);
            double d0 = this.wantedX - this.mob.getX();
            double d1 = this.wantedY - this.mob.getEyeY();
            double d2 = this.wantedZ - this.mob.getZ();
            Vector3f vector3f2 = new Vector3f((float)d0, (float)d1, (float)d2);
            float f = vector3f1.dot((Vector3fc)vector3f2);
            float f1 = vector3f.dot((Vector3fc)vector3f2);
            return !(Math.abs(f) > 1.0E-5f) && !(Math.abs(f1) > 1.0E-5f) ? Optional.empty() : Optional.of(Float.valueOf((float)(Mth.atan2((double)(-f), (double)f1) * 180.0 / 3.1415927410125732)));
        }

        protected Optional<Float> getXRotD() {
            return Optional.of(Float.valueOf(0.0f));
        }
    }

    static class PaleEyeAttackGoal
    extends Goal {
        private final PaleEyeEntity pale_eye;
        private int attackTime;

        public PaleEyeAttackGoal(PaleEyeEntity pale_eye) {
            this.pale_eye = pale_eye;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            LivingEntity livingentity = this.pale_eye.getTarget();
            return livingentity != null && livingentity.isAlive() && !this.pale_eye.isClosed();
        }

        public boolean canContinueToUse() {
            return super.canContinueToUse() && this.pale_eye.getTarget() != null && !this.pale_eye.isClosed() && this.pale_eye.distanceToSqr((Entity)this.pale_eye.getTarget()) > 9.0;
        }

        public void start() {
            this.attackTime = -10;
            this.pale_eye.getNavigation().stop();
            LivingEntity livingentity = this.pale_eye.getTarget();
            if (livingentity != null) {
                this.pale_eye.getLookControl().setLookAt((Entity)livingentity, 90.0f, 90.0f);
            }
            this.pale_eye.hasImpulse = true;
        }

        public void stop() {
            this.pale_eye.setActiveAttackTarget(0);
            this.pale_eye.setTarget(null);
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public void tick() {
            LivingEntity livingentity = this.pale_eye.getTarget();
            if (livingentity != null) {
                this.pale_eye.getNavigation().stop();
                this.pale_eye.getLookControl().setLookAt((Entity)livingentity, 90.0f, 90.0f);
                if (!this.pale_eye.hasLineOfSight((Entity)livingentity)) {
                    this.pale_eye.setTarget(null);
                } else {
                    ++this.attackTime;
                    if (this.attackTime == 0) {
                        this.pale_eye.setActiveAttackTarget(livingentity.getId());
                    } else if (this.attackTime >= this.pale_eye.getAttackDuration()) {
                        float f = 1.0f;
                        if (this.pale_eye.level().getDifficulty() == Difficulty.HARD) {
                            f += 2.0f;
                        }
                        ServerLevel serverlevel = PaleEyeAttackGoal.getServerLevel((Entity)this.pale_eye);
                        livingentity.hurtServer(serverlevel, this.pale_eye.damageSources().indirectMagic((Entity)this.pale_eye, (Entity)this.pale_eye), f);
                        this.pale_eye.doHurtTarget(serverlevel, (Entity)livingentity);
                        this.pale_eye.setTarget(null);
                    }
                    super.tick();
                }
            }
        }
    }

    class ShulkerPeekGoal
    extends Goal {
        private int peekTime;

        ShulkerPeekGoal() {
        }

        public boolean canUse() {
            return PaleEyeEntity.this.random.nextInt(ShulkerPeekGoal.reducedTickDelay((int)40)) == 0 && this.IsVariantAbleToAttack() && PaleEyeEntity.this.canStayAt(PaleEyeEntity.this.blockPosition(), PaleEyeEntity.this.getAttachFace());
        }

        public boolean IsVariantAbleToAttack() {
            if (((PaleEyeVariant)PaleEyeEntity.this.getVariant().value()).OpensAtDay() && !PaleEyeEntity.this.level().isMoonVisible()) {
                return true;
            }
            return PaleEyeEntity.this.level().isMoonVisible();
        }

        public boolean canContinueToUse() {
            return this.peekTime > 0;
        }

        public void start() {
            this.peekTime = this.adjustedTickDelay(20 * (1 + PaleEyeEntity.this.random.nextInt(3)));
            PaleEyeEntity.this.setRawPeekAmount(63);
        }

        public void stop() {
            if (PaleEyeEntity.this.getTarget() == null) {
                PaleEyeEntity.this.setRawPeekAmount(0);
            }
        }

        public void tick() {
            --this.peekTime;
        }
    }

    class ShulkerNearestAttackGoal
    extends NearestAttackableTargetGoal<Player> {
        public ShulkerNearestAttackGoal(PaleEyeEntity shulker) {
            super((Mob)shulker, Player.class, true);
        }

        public boolean canUse() {
            return PaleEyeEntity.this.level().isMoonVisible() && PaleEyeEntity.this.level().getDifficulty() == Difficulty.PEACEFUL ? false : super.canUse();
        }

        protected AABB getTargetSearchArea(double targetDistance) {
            Direction direction = ((PaleEyeEntity)this.mob).getAttachFace();
            if (direction.getAxis() == Direction.Axis.X) {
                return this.mob.getBoundingBox().inflate(4.0, targetDistance, targetDistance);
            }
            return direction.getAxis() == Direction.Axis.Z ? this.mob.getBoundingBox().inflate(targetDistance, targetDistance, 4.0) : this.mob.getBoundingBox().inflate(targetDistance, 4.0, targetDistance);
        }
    }

    static class ShulkerDefenseAttackGoal
    extends NearestAttackableTargetGoal<LivingEntity> {
        public ShulkerDefenseAttackGoal(PaleEyeEntity shulker) {
            super((Mob)shulker, LivingEntity.class, 10, true, false, (p_33501_, p_376365_) -> p_33501_ instanceof Enemy);
        }

        public boolean canUse() {
            return this.mob.getTeam() == null ? false : super.canUse();
        }

        protected AABB getTargetSearchArea(double targetDistance) {
            Direction direction = ((PaleEyeEntity)this.mob).getAttachFace();
            if (direction.getAxis() == Direction.Axis.X) {
                return this.mob.getBoundingBox().inflate(4.0, targetDistance, targetDistance);
            }
            return direction.getAxis() == Direction.Axis.Z ? this.mob.getBoundingBox().inflate(targetDistance, targetDistance, 4.0) : this.mob.getBoundingBox().inflate(targetDistance, 4.0, targetDistance);
        }
    }

    static class ShulkerBodyRotationControl
    extends BodyRotationControl {
        public ShulkerBodyRotationControl(Mob mob) {
            super(mob);
        }

        public void clientTick() {
        }
    }

    static class PaleEyeAttackSelector
    implements TargetingConditions.Selector {
        private final PaleEyeEntity pale_eye;

        public PaleEyeAttackSelector(PaleEyeEntity pale_eye) {
            this.pale_eye = pale_eye;
        }

        public boolean test(@Nullable LivingEntity entity, ServerLevel p_376639_) {
            return entity instanceof Player && entity.distanceToSqr((Entity)this.pale_eye) > 9.0;
        }
    }
}

