/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.creaking_expanded.blocks;

import com.belgie.creaking_expanded.registry.BlockRegistry;
import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RedstoneTorchBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ResinLanternBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final MapCodec<ResinLanternBlock> CODEC = ResinLanternBlock.simpleCodec(ResinLanternBlock::new);
    public static final BooleanProperty HANGING;
    public static final BooleanProperty WATERLOGGED;
    public static final BooleanProperty STABLE;
    protected static final VoxelShape AABB;
    protected static final VoxelShape HANGING_AABB;
    public static final BooleanProperty LIT;

    public MapCodec<ResinLanternBlock> codec() {
        return CODEC;
    }

    public ResinLanternBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)STABLE, (Comparable)Boolean.valueOf(false))).setValue((Property)LIT, (Comparable)Boolean.valueOf(false))).setValue((Property)HANGING, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluidstate = context.getLevel().getFluidState(context.getClickedPos());
        for (Direction direction : context.getNearestLookingDirections()) {
            BlockState blockstate;
            if (direction.getAxis() != Direction.Axis.Y || !(blockstate = (BlockState)this.defaultBlockState().setValue((Property)HANGING, (Comparable)Boolean.valueOf(direction == Direction.UP))).canSurvive((LevelReader)context.getLevel(), context.getClickedPos())) continue;
            return (BlockState)((BlockState)blockstate.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.getType() == Fluids.WATER))).setValue((Property)LIT, (Comparable)Boolean.valueOf(context.getLevel().isMoonVisible()));
        }
        return null;
    }

    protected InteractionResult useItemOn(ItemStack p_316844_, BlockState p_316365_, Level p_316306_, BlockPos p_316497_, Player p_316824_, InteractionHand p_316436_, BlockHitResult p_316125_) {
        boolean i = (Boolean)p_316365_.getValue((Property)STABLE);
        boolean flag = false;
        if (!i) {
            Item item = p_316844_.getItem();
            if (p_316844_.is(Items.RESIN_BRICK)) {
                p_316306_.playSound((Entity)p_316824_, p_316824_.getX(), p_316824_.getY(), p_316824_.getZ(), SoundEvents.HONEYCOMB_WAX_ON, SoundSource.BLOCKS, 1.0f, 1.0f);
                p_316306_.setBlock(p_316497_, (BlockState)p_316365_.setValue((Property)STABLE, (Comparable)Boolean.valueOf(true)), 3);
                if (!p_316824_.isCreative()) {
                    p_316844_.shrink(1);
                }
                flag = true;
                p_316306_.levelEvent((Entity)p_316824_, 3003, p_316497_, 0);
                p_316306_.gameEvent((Entity)p_316824_, (Holder)GameEvent.BLOCK_CHANGE, p_316497_);
                if (!p_316306_.isClientSide() && flag) {
                    p_316824_.awardStat(Stats.ITEM_USED.get((Object)item));
                }
                return InteractionResult.SUCCESS;
            }
        } else if (i) {
            Item item = p_316844_.getItem();
            if (p_316844_.is(ItemTags.HOES)) {
                p_316306_.playSound((Entity)p_316824_, p_316824_.getX(), p_316824_.getY(), p_316824_.getZ(), SoundEvents.HONEYCOMB_WAX_ON, SoundSource.BLOCKS, 1.0f, 1.0f);
                p_316306_.setBlock(p_316497_, (BlockState)p_316365_.setValue((Property)STABLE, (Comparable)Boolean.valueOf(false)), 3);
                p_316844_.hurtAndBreak(1, (LivingEntity)p_316824_, LivingEntity.getSlotForHand((InteractionHand)p_316436_));
                flag = true;
                p_316306_.levelEvent((Entity)p_316824_, 3004, p_316497_, 0);
                p_316306_.gameEvent((Entity)p_316824_, (Holder)GameEvent.BLOCK_CHANGE, p_316497_);
                if (!p_316306_.isClientSide() && flag) {
                    p_316824_.awardStat(Stats.ITEM_USED.get((Object)item));
                }
                return InteractionResult.SUCCESS;
            }
        }
        return super.useItemOn(p_316844_, p_316365_, p_316306_, p_316497_, p_316824_, p_316436_, p_316125_);
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return (Boolean)state.getValue((Property)HANGING) != false ? HANGING_AABB : AABB;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{LIT, HANGING, WATERLOGGED, STABLE});
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        Direction direction = ResinLanternBlock.getConnectedDirection(state).getOpposite();
        return Block.canSupportCenter((LevelReader)level, (BlockPos)pos.relative(direction), (Direction)direction.getOpposite());
    }

    protected boolean isRandomlyTicking(BlockState state) {
        return (Boolean)state.getValue((Property)STABLE) == false;
    }

    protected static Direction getConnectedDirection(BlockState state) {
        return (Boolean)state.getValue((Property)HANGING) != false ? Direction.DOWN : Direction.UP;
    }

    protected BlockState updateShape(BlockState p_153483_, LevelReader p_374491_, ScheduledTickAccess p_374260_, BlockPos p_153487_, Direction p_153484_, BlockPos p_153488_, BlockState p_153485_, RandomSource p_374175_) {
        if (((Boolean)p_153483_.getValue((Property)WATERLOGGED)).booleanValue()) {
            p_374260_.scheduleTick(p_153487_, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay(p_374491_));
        }
        return ResinLanternBlock.getConnectedDirection(p_153483_).getOpposite() == p_153484_ && !p_153483_.canSurvive(p_374491_, p_153487_) ? Blocks.AIR.defaultBlockState() : super.updateShape(p_153483_, p_374491_, p_374260_, p_153487_, p_153484_, p_153488_, p_153485_, p_374175_);
    }

    protected FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    protected void randomTick(BlockState p_382824_, ServerLevel p_382831_, BlockPos p_382957_, RandomSource p_382888_) {
        if (!((Boolean)p_382824_.getValue((Property)STABLE)).booleanValue()) {
            this.tryChangingState(p_382824_, p_382831_, p_382957_, p_382888_);
        }
        super.randomTick(p_382824_, p_382831_, p_382957_, p_382888_);
    }

    protected void tick(BlockState p_382808_, ServerLevel p_383005_, BlockPos p_383211_, RandomSource p_383088_) {
        if (!((Boolean)p_382808_.getValue((Property)STABLE)).booleanValue()) {
            this.tryChangingState(p_382808_, p_383005_, p_383211_, p_383088_);
        }
        super.tick(p_382808_, p_383005_, p_383211_, p_383088_);
    }

    private void tryChangingState(BlockState p_383235_, ServerLevel p_383091_, BlockPos p_383073_, RandomSource p_383038_) {
        p_383091_.setBlock(p_383073_, p_383091_.isMoonVisible() ? (BlockState)((BlockState)((Block)BlockRegistry.RESIN_LANTERN.get()).defaultBlockState().setValue((Property)LIT, (Comparable)Boolean.valueOf(true))).setValue((Property)HANGING, (Comparable)((Boolean)p_383235_.getValue((Property)HANGING))) : (BlockState)((BlockState)((Block)BlockRegistry.RESIN_LANTERN.get()).defaultBlockState().setValue((Property)LIT, (Comparable)Boolean.valueOf(false))).setValue((Property)HANGING, (Comparable)((Boolean)p_383235_.getValue((Property)HANGING))), 3);
        p_383091_.gameEvent((Holder)GameEvent.BLOCK_CHANGE, p_383073_, GameEvent.Context.of((BlockState)p_383235_));
        BlockPos.betweenClosed((BlockPos)p_383073_.offset(-3, -2, -3), (BlockPos)p_383073_.offset(3, 2, 3)).forEach(p_383198_ -> {
            BlockState blockstate = p_383091_.getBlockState(p_383198_);
            if (blockstate == p_383235_) {
                double d0 = Math.sqrt(p_383073_.distSqr((Vec3i)p_383198_));
                int i = p_383038_.nextIntBetweenInclusive((int)(d0 * 5.0), (int)(d0 * 10.0));
                p_383091_.scheduleTick(p_383198_, p_383235_.getBlock(), i);
            }
        });
    }

    static {
        LIT = RedstoneTorchBlock.LIT;
        HANGING = BlockStateProperties.HANGING;
        STABLE = BlockRegistry.STABLE;
        WATERLOGGED = BlockStateProperties.WATERLOGGED;
        AABB = Shapes.or((VoxelShape)Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)7.0, (double)11.0), (VoxelShape)Block.box((double)6.0, (double)7.0, (double)6.0, (double)10.0, (double)9.0, (double)10.0));
        HANGING_AABB = Shapes.or((VoxelShape)Block.box((double)5.0, (double)1.0, (double)5.0, (double)11.0, (double)8.0, (double)11.0), (VoxelShape)Block.box((double)6.0, (double)8.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0));
    }
}

