/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.creaking_expanded.blocks;

import com.belgie.creaking_expanded.registry.BlockRegistry;
import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseTorchBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RedstoneTorchBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;

public class ResinTorchBlock
extends BaseTorchBlock {
    public static final MapCodec<ResinTorchBlock> CODEC = ResinTorchBlock.simpleCodec(ResinTorchBlock::new);
    public static final BooleanProperty LIT = RedstoneTorchBlock.LIT;
    public static final BooleanProperty STABLE = BlockRegistry.STABLE;
    private static final int EYEBLOSSOM_XZ_RANGE = 3;
    private static final int EYEBLOSSOM_Y_RANGE = 2;

    public MapCodec<? extends ResinTorchBlock> codec() {
        return CODEC;
    }

    public ResinTorchBlock(BlockBehaviour.Properties p_383158_) {
        super(p_383158_);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)STABLE, (Comparable)Boolean.valueOf(false))).setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    protected void randomTick(BlockState p_382824_, ServerLevel p_382831_, BlockPos p_382957_, RandomSource p_382888_) {
        if (!((Boolean)p_382824_.getValue((Property)STABLE)).booleanValue()) {
            this.tryChangingState(p_382824_, p_382831_, p_382957_, p_382888_);
        }
        super.randomTick(p_382824_, p_382831_, p_382957_, p_382888_);
    }

    protected void tick(BlockState p_382808_, ServerLevel p_383005_, BlockPos p_383211_, RandomSource p_383088_) {
        if (!((Boolean)p_382808_.getValue((Property)STABLE)).booleanValue()) {
            this.tryChangingState(p_382808_, p_383005_, p_383211_, p_383088_);
        }
        super.tick(p_382808_, p_383005_, p_383211_, p_383088_);
    }

    protected boolean isRandomlyTicking(BlockState state) {
        return (Boolean)state.getValue((Property)STABLE) == false;
    }

    protected InteractionResult useItemOn(ItemStack p_316844_, BlockState p_316365_, Level p_316306_, BlockPos p_316497_, Player p_316824_, InteractionHand p_316436_, BlockHitResult p_316125_) {
        boolean i = (Boolean)p_316365_.getValue((Property)STABLE);
        boolean flag = false;
        if (!i) {
            Item item = p_316844_.getItem();
            if (p_316844_.is(Items.RESIN_BRICK)) {
                p_316306_.playSound((Entity)p_316824_, p_316824_.getX(), p_316824_.getY(), p_316824_.getZ(), SoundEvents.HONEYCOMB_WAX_ON, SoundSource.BLOCKS, 1.0f, 1.0f);
                p_316306_.setBlock(p_316497_, (BlockState)p_316365_.setValue((Property)STABLE, (Comparable)Boolean.valueOf(true)), 3);
                if (!p_316824_.isCreative()) {
                    p_316844_.shrink(1);
                }
                flag = true;
                p_316306_.levelEvent((Entity)p_316824_, 3003, p_316497_, 0);
                p_316306_.gameEvent((Entity)p_316824_, (Holder)GameEvent.BLOCK_CHANGE, p_316497_);
                if (!p_316306_.isClientSide() && flag) {
                    p_316824_.awardStat(Stats.ITEM_USED.get((Object)item));
                }
                return InteractionResult.SUCCESS;
            }
        } else if (i) {
            Item item = p_316844_.getItem();
            if (p_316844_.is(ItemTags.HOES)) {
                p_316306_.playSound((Entity)p_316824_, p_316824_.getX(), p_316824_.getY(), p_316824_.getZ(), SoundEvents.HONEYCOMB_WAX_ON, SoundSource.BLOCKS, 1.0f, 1.0f);
                p_316306_.setBlock(p_316497_, (BlockState)p_316365_.setValue((Property)STABLE, (Comparable)Boolean.valueOf(false)), 3);
                p_316844_.hurtAndBreak(1, (LivingEntity)p_316824_, LivingEntity.getSlotForHand((InteractionHand)p_316436_));
                flag = true;
                p_316306_.levelEvent((Entity)p_316824_, 3004, p_316497_, 0);
                p_316306_.gameEvent((Entity)p_316824_, (Holder)GameEvent.BLOCK_CHANGE, p_316497_);
                if (!p_316306_.isClientSide() && flag) {
                    p_316824_.awardStat(Stats.ITEM_USED.get((Object)item));
                }
                return InteractionResult.SUCCESS;
            }
        }
        return super.useItemOn(p_316844_, p_316365_, p_316306_, p_316497_, p_316824_, p_316436_, p_316125_);
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (((Boolean)state.getValue((Property)LIT)).booleanValue()) {
            double d0 = (double)pos.getX() + 0.5;
            double d1 = (double)pos.getY() + 0.7;
            double d2 = (double)pos.getZ() + 0.5;
            level.addParticle((ParticleOptions)ParticleTypes.SMOKE, d0, d1, d2, 0.0, 0.0, 0.0);
            level.addParticle((ParticleOptions)ParticleTypes.FLAME, d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    private void tryChangingState(BlockState p_383235_, ServerLevel p_383091_, BlockPos p_383073_, RandomSource p_383038_) {
        if (p_383091_.isMoonVisible() && !((Boolean)p_383235_.getValue((Property)LIT)).booleanValue()) {
            p_383091_.setBlock(p_383073_, (BlockState)((Block)BlockRegistry.RESIN_TORCH.get()).defaultBlockState().setValue((Property)LIT, (Comparable)Boolean.valueOf(true)), 3);
            p_383091_.gameEvent((Holder)GameEvent.BLOCK_CHANGE, p_383073_, GameEvent.Context.of((BlockState)p_383235_));
            BlockPos.betweenClosed((BlockPos)p_383073_.offset(-3, -2, -3), (BlockPos)p_383073_.offset(3, 2, 3)).forEach(p_383198_ -> {
                BlockState blockstate = p_383091_.getBlockState(p_383198_);
                if (blockstate == p_383235_) {
                    double d0 = Math.sqrt(p_383073_.distSqr((Vec3i)p_383198_));
                    int i = p_383038_.nextIntBetweenInclusive((int)(d0 * 5.0), (int)(d0 * 10.0));
                    p_383091_.scheduleTick(p_383198_, p_383235_.getBlock(), i);
                }
            });
        } else if (!p_383091_.isMoonVisible() && ((Boolean)p_383235_.getValue((Property)LIT)).booleanValue()) {
            p_383091_.setBlock(p_383073_, (BlockState)((Block)BlockRegistry.RESIN_TORCH.get()).defaultBlockState().setValue((Property)LIT, (Comparable)Boolean.valueOf(false)), 3);
            p_383091_.gameEvent((Holder)GameEvent.BLOCK_CHANGE, p_383073_, GameEvent.Context.of((BlockState)p_383235_));
            BlockPos.betweenClosed((BlockPos)p_383073_.offset(-3, -2, -3), (BlockPos)p_383073_.offset(3, 2, 3)).forEach(p_383198_ -> {
                BlockState blockstate = p_383091_.getBlockState(p_383198_);
                if (blockstate == p_383235_) {
                    double d0 = Math.sqrt(p_383073_.distSqr((Vec3i)p_383198_));
                    int i = p_383038_.nextIntBetweenInclusive((int)(d0 * 5.0), (int)(d0 * 10.0));
                    p_383091_.scheduleTick(p_383198_, p_383235_.getBlock(), i);
                }
            });
        }
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)LIT, (Comparable)Boolean.valueOf(context.getLevel().isMoonVisible()));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{LIT, STABLE});
    }
}

