/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.creaking_expanded.entity.renderer;

import com.belgie.creaking_expanded.CreakingExpanded;
import com.belgie.creaking_expanded.entity.AI.PaleEyeEyeLayer;
import com.belgie.creaking_expanded.entity.PaleEyeEntity;
import com.belgie.creaking_expanded.entity.model.PaleEyeModel;
import com.belgie.creaking_expanded.entity.renderstate.PaleEyeRenderState;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionfc;

public class PaleEyeRenderer
extends MobRenderer<PaleEyeEntity, PaleEyeRenderState, PaleEyeModel<PaleEyeRenderState>> {
    public PaleEyeRenderer(EntityRendererProvider.Context p_174370_) {
        super(p_174370_, new PaleEyeModel(p_174370_.bakeLayer(CreakingExpanded.EntityBits.PALE_EYE)), 0.0f);
        this.addLayer(new PaleEyeEyeLayer((RenderLayerParent<PaleEyeRenderState, PaleEyeModel<PaleEyeRenderState>>)this));
    }

    public Vec3 getRenderOffset(PaleEyeRenderState p_360997_) {
        return p_360997_.renderOffset;
    }

    public boolean shouldRender(PaleEyeEntity livingEntity, Frustum camera, double camX, double camY, double camZ) {
        LivingEntity livingentity;
        if (super.shouldRender((Entity)livingEntity, camera, camX, camY, camZ)) {
            return true;
        }
        Vec3 vec3 = livingEntity.getRenderPosition(0.0f);
        if (vec3 == null) {
            return false;
        }
        if (livingEntity.hasActiveAttackTarget() && (livingentity = livingEntity.getActiveAttackTarget()) != null) {
            Vec3 vec8 = this.getPosition(livingentity, (double)livingentity.getBbHeight() * 0.5, 1.0f);
            Vec3 vec31 = this.getPosition((LivingEntity)livingEntity, livingEntity.getEyeHeight(), 1.0f);
            return camera.isVisible(new AABB(vec31.x, vec31.y, vec31.z, vec8.x, vec8.y, vec8.z));
        }
        EntityType entitytype = livingEntity.getType();
        float f = entitytype.getHeight() / 2.0f;
        float f1 = entitytype.getWidth() / 2.0f;
        Vec3 vec31 = Vec3.atBottomCenterOf((Vec3i)livingEntity.blockPosition());
        return camera.isVisible(new AABB(vec3.x, vec3.y + (double)f, vec3.z, vec31.x, vec31.y + (double)f, vec31.z).inflate((double)f1, (double)f, (double)f1));
    }

    public ResourceLocation getTextureLocation(PaleEyeRenderState p_362880_) {
        return p_362880_.texture;
    }

    public PaleEyeRenderState createRenderState() {
        return new PaleEyeRenderState();
    }

    public void extractRenderState(PaleEyeEntity p_365400_, PaleEyeRenderState p_361284_, float p_360863_) {
        super.extractRenderState((LivingEntity)p_365400_, (LivingEntityRenderState)p_361284_, p_360863_);
        p_361284_.renderOffset = Objects.requireNonNullElse(p_365400_.getRenderPosition(p_360863_), Vec3.ZERO);
        p_361284_.peekAmount = p_365400_.getClientPeekAmount(p_360863_);
        p_361284_.yHeadRot = p_365400_.yHeadRot;
        p_361284_.yBodyRot = p_365400_.yBodyRot;
        p_361284_.attachFace = p_365400_.getAttachFace();
        p_361284_.Type = p_365400_.getVariant();
        p_361284_.texture = p_365400_.getTexture();
        p_361284_.eye_texture = p_365400_.getEyeTexture();
        p_361284_.beam_texture = p_365400_.getBeamTexture();
        p_361284_.eyePosition = p_365400_.getEyePosition(p_360863_);
        Entity entity = PaleEyeRenderer.getEntityToLookAt(p_365400_);
        if (entity != null) {
            p_361284_.lookDirection = p_365400_.getViewVector(p_360863_);
            p_361284_.lookAtPosition = entity.getEyePosition(p_360863_);
        } else {
            p_361284_.lookDirection = null;
            p_361284_.lookAtPosition = null;
        }
        LivingEntity livingentity = p_365400_.getActiveAttackTarget();
        if (livingentity != null) {
            p_361284_.attackScale = p_365400_.getAttackAnimationScale(p_360863_);
            p_361284_.attackTime = p_365400_.getClientSideAttackTime() + p_360863_;
            p_361284_.attackTargetPosition = this.getPosition(livingentity, (double)livingentity.getBbHeight() * 0.5, p_360863_);
        } else {
            p_361284_.attackTargetPosition = null;
        }
    }

    protected void setupRotations(PaleEyeRenderState p_364147_, PoseStack p_115908_, float p_115909_, float p_115910_) {
        super.setupRotations((LivingEntityRenderState)p_364147_, p_115908_, p_115909_ + 180.0f, p_115910_);
        p_115908_.rotateAround((Quaternionfc)p_364147_.attachFace.getOpposite().getRotation(), 0.0f, 0.5f, 0.0f);
    }

    private Vec3 getPosition(LivingEntity livingEntity, double yOffset, float partialTick) {
        double d0 = Mth.lerp((double)partialTick, (double)livingEntity.xOld, (double)livingEntity.getX());
        double d1 = Mth.lerp((double)partialTick, (double)livingEntity.yOld, (double)livingEntity.getY()) + yOffset;
        double d2 = Mth.lerp((double)partialTick, (double)livingEntity.zOld, (double)livingEntity.getZ());
        return new Vec3(d0, d1, d2);
    }

    public void render(PaleEyeRenderState p_363200_, PoseStack p_114793_, MultiBufferSource p_114794_, int p_114795_) {
        super.render((LivingEntityRenderState)p_363200_, p_114793_, p_114794_, p_114795_);
        Vec3 vec3 = p_363200_.attackTargetPosition;
        if (vec3 != null) {
            float f = p_363200_.attackTime * 0.5f % 1.0f;
            p_114793_.pushPose();
            p_114793_.translate(0.0f, p_363200_.eyeHeight, 0.0f);
            PaleEyeRenderer.renderBeam(p_114793_, p_114794_.getBuffer(RenderType.eyes((ResourceLocation)p_363200_.beam_texture)), vec3.subtract(p_363200_.eyePosition), p_363200_.attackTime, p_363200_.attackScale, f);
            p_114793_.popPose();
        }
    }

    private static void renderBeam(PoseStack p_363906_, VertexConsumer p_365218_, Vec3 p_360399_, float p_363920_, float p_363755_, float p_361709_) {
        float f = (float)(p_360399_.length() + 1.0);
        p_360399_ = p_360399_.normalize();
        float f1 = (float)Math.acos(p_360399_.y);
        float f2 = 1.5707964f - (float)Math.atan2(p_360399_.z, p_360399_.x);
        p_363906_.mulPose((Quaternionfc)Axis.YP.rotationDegrees(f2 * 57.295776f));
        p_363906_.mulPose((Quaternionfc)Axis.XP.rotationDegrees(f1 * 57.295776f));
        float f3 = p_363920_ * 0.05f * -1.5f;
        float f4 = p_363755_ * p_363755_;
        int i = 64 + (int)(f4 * 191.0f);
        int j = 32 + (int)(f4 * 191.0f);
        int k = 128 - (int)(f4 * 191.0f);
        float f5 = 0.2f;
        float f6 = 0.282f;
        float f7 = Mth.cos((float)(f3 + 2.3561945f)) * 0.282f;
        float f8 = Mth.sin((float)(f3 + 2.3561945f)) * 0.282f;
        float f9 = Mth.cos((float)(f3 + 0.7853982f)) * 0.282f;
        float f10 = Mth.sin((float)(f3 + 0.7853982f)) * 0.282f;
        float f11 = Mth.cos((float)(f3 + 3.926991f)) * 0.282f;
        float f12 = Mth.sin((float)(f3 + 3.926991f)) * 0.282f;
        float f13 = Mth.cos((float)(f3 + 5.4977875f)) * 0.282f;
        float f14 = Mth.sin((float)(f3 + 5.4977875f)) * 0.282f;
        float f15 = Mth.cos((float)(f3 + (float)Math.PI)) * 0.2f;
        float f16 = Mth.sin((float)(f3 + (float)Math.PI)) * 0.2f;
        float f17 = Mth.cos((float)(f3 + 0.0f)) * 0.2f;
        float f18 = Mth.sin((float)(f3 + 0.0f)) * 0.2f;
        float f19 = Mth.cos((float)(f3 + 1.5707964f)) * 0.2f;
        float f20 = Mth.sin((float)(f3 + 1.5707964f)) * 0.2f;
        float f21 = Mth.cos((float)(f3 + 4.712389f)) * 0.2f;
        float f22 = Mth.sin((float)(f3 + 4.712389f)) * 0.2f;
        float f23 = 0.0f;
        float f24 = 0.4999f;
        float f25 = -1.0f + p_361709_;
        float f26 = f25 + f * 2.5f;
        PoseStack.Pose posestack$pose = p_363906_.last();
        PaleEyeRenderer.vertex(p_365218_, posestack$pose, f15, f, f16, i, j, k, 0.4999f, f26);
        PaleEyeRenderer.vertex(p_365218_, posestack$pose, f15, 0.0f, f16, i, j, k, 0.4999f, f25);
        PaleEyeRenderer.vertex(p_365218_, posestack$pose, f17, 0.0f, f18, i, j, k, 0.0f, f25);
        PaleEyeRenderer.vertex(p_365218_, posestack$pose, f17, f, f18, i, j, k, 0.0f, f26);
        PaleEyeRenderer.vertex(p_365218_, posestack$pose, f19, f, f20, i, j, k, 0.4999f, f26);
        PaleEyeRenderer.vertex(p_365218_, posestack$pose, f19, 0.0f, f20, i, j, k, 0.4999f, f25);
        PaleEyeRenderer.vertex(p_365218_, posestack$pose, f21, 0.0f, f22, i, j, k, 0.0f, f25);
        PaleEyeRenderer.vertex(p_365218_, posestack$pose, f21, f, f22, i, j, k, 0.0f, f26);
        float f27 = Mth.floor((float)p_363920_) % 2 == 0 ? 0.5f : 0.0f;
        PaleEyeRenderer.vertex(p_365218_, posestack$pose, f7, f, f8, i, j, k, 0.5f, f27 + 0.5f);
        PaleEyeRenderer.vertex(p_365218_, posestack$pose, f9, f, f10, i, j, k, 1.0f, f27 + 0.5f);
        PaleEyeRenderer.vertex(p_365218_, posestack$pose, f13, f, f14, i, j, k, 1.0f, f27);
        PaleEyeRenderer.vertex(p_365218_, posestack$pose, f11, f, f12, i, j, k, 0.5f, f27);
    }

    private static void vertex(VertexConsumer consumer, PoseStack.Pose pose, float x, float y, float z, int red, int green, int blue, float u, float v) {
        consumer.addVertex(pose, x, y, z).setColor(red, green, blue, 255).setUv(u, v).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 1.0f, 0.0f);
    }

    @Nullable
    private static Entity getEntityToLookAt(PaleEyeEntity p_364936_) {
        Entity entity = Minecraft.getInstance().getCameraEntity();
        return p_364936_.hasActiveAttackTarget() ? p_364936_.getActiveAttackTarget() : entity;
    }
}

