/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.creaking_expanded.items;

import com.belgie.creaking_expanded.items.CustomBucketItem;
import com.belgie.creaking_expanded.util.CustomBucketable;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluids;

public class SpritelingBucketItem
extends CustomBucketItem {
    private final EntityType<? extends Mob> type;
    private final SoundEvent emptySound;

    public SpritelingBucketItem(EntityType<? extends Mob> type, SoundEvent emptySound, Item.Properties properties) {
        super(Fluids.EMPTY, properties);
        this.type = type;
        this.emptySound = emptySound;
    }

    public void checkExtraContent(@Nullable Player player, Level level, ItemStack containerStack, BlockPos pos) {
        if (level instanceof ServerLevel) {
            this.spawn(player, (ServerLevel)level, containerStack, pos);
            level.gameEvent((Entity)player, (Holder)GameEvent.ENTITY_PLACE, pos);
        }
    }

    @Override
    protected void playEmptySound(@Nullable Player player, LevelAccessor level, BlockPos pos) {
        level.playSound((Entity)player, pos, this.emptySound, SoundSource.NEUTRAL, 1.0f, 1.0f);
    }

    private void spawn(@Nullable Player player, ServerLevel serverLevel, ItemStack bucketedMobStack, BlockPos pos) {
        Mob mob = (Mob)this.type.create(serverLevel, EntityType.createDefaultStackConfig((Level)serverLevel, (ItemStack)bucketedMobStack, (LivingEntity)((Player)null)), pos, EntitySpawnReason.BUCKET, true, false);
        if (mob instanceof CustomBucketable) {
            CustomBucketable bucketable = (CustomBucketable)mob;
            CustomData customdata = (CustomData)bucketedMobStack.getOrDefault(DataComponents.BUCKET_ENTITY_DATA, (Object)CustomData.EMPTY);
            bucketable.loadFromBucketTag(customdata.copyTag());
            bucketable.setFromBucket(true);
        }
        if (mob != null) {
            serverLevel.addFreshEntityWithPassengers((Entity)mob);
            mob.playAmbientSound();
            mob.getLookControl().setLookAt(player.getX(), mob.getEyeY() * player.getEyeY(), player.getZ());
        }
    }
}

