/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.creaking_expanded;

import com.belgie.creaking_expanded.Config;
import com.belgie.creaking_expanded.entity.CreakingGolem;
import com.belgie.creaking_expanded.entity.PaleCreeperEntity;
import com.belgie.creaking_expanded.entity.PaleEyeEntity;
import com.belgie.creaking_expanded.entity.SpriteEntity;
import com.belgie.creaking_expanded.entity.model.AncientSpriteModel;
import com.belgie.creaking_expanded.entity.model.CreakingGuardModel;
import com.belgie.creaking_expanded.entity.model.PaleEyeModel;
import com.belgie.creaking_expanded.entity.renderer.AncientSpriteRenderer;
import com.belgie.creaking_expanded.entity.renderer.FriendlyCreakingRenderer;
import com.belgie.creaking_expanded.entity.renderer.PaleCreeperRenderer;
import com.belgie.creaking_expanded.entity.renderer.PaleEyeRenderer;
import com.belgie.creaking_expanded.registry.BlockEntityRegistry;
import com.belgie.creaking_expanded.registry.BlockRegistry;
import com.belgie.creaking_expanded.registry.EntityRegistry;
import com.belgie.creaking_expanded.registry.ItemRegistry;
import com.belgie.creaking_expanded.registry.MenuRegistry;
import com.belgie.creaking_expanded.registry.ModEvents;
import com.belgie.creaking_expanded.registry.ModGamerules;
import com.belgie.creaking_expanded.registry.ParticleRegistry;
import com.mojang.logging.LogUtils;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.slf4j.Logger;

@Mod(value="creaking_expanded")
public class CreakingExpanded {
    public static final String MODID = "creaking_expanded";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"creaking_expanded");
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> EXAMPLE_TAB = CREATIVE_MODE_TABS.register("creaking_expanded_tab", () -> CreativeModeTab.builder().title((Component)Component.translatable((String)"itemGroup.creaking_expanded_tab")).icon(() -> ((Block)BlockRegistry.SIGHT_BLOCK.get()).asItem().getDefaultInstance()).displayItems((parameters, output) -> {
        for (DeferredHolder item : ItemRegistry.ITEMS.getEntries()) {
            output.accept((ItemLike)item.get());
        }
    }).build());
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> WOOD_BLOCKS = CREATIVE_MODE_TABS.register("creaking_expanded_wood_tab", () -> CreativeModeTab.builder().title((Component)Component.translatable((String)"itemGroup.creaking_expanded_wood_tab")).icon(() -> ((Block)BlockRegistry.PETRIFIED_OAK_LOG.get()).asItem().getDefaultInstance()).displayItems((parameters, output) -> {
        for (DeferredHolder item : BlockRegistry.WOODS.getEntries()) {
            output.accept((ItemLike)((Block)item.get()).asItem());
        }
    }).build());

    public CreakingExpanded(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::commonSetup);
        BlockRegistry.BLOCKS.register(modEventBus);
        BlockRegistry.WOODS.register(modEventBus);
        ItemRegistry.ITEMS.register(modEventBus);
        ItemRegistry.WOODS.register(modEventBus);
        CREATIVE_MODE_TABS.register(modEventBus);
        MenuRegistry.MENU.register(modEventBus);
        ParticleRegistry.PARTICLE.register(modEventBus);
        BlockEntityRegistry.BLOCK_ENTITY.register(modEventBus);
        EntityRegistry.ENTITY.register(modEventBus);
        EntityRegistry.DATA.register(modEventBus);
        NeoForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(this::handleRegisterMenuScreens);
        modEventBus.addListener(this::addCreative);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            ModGamerules.init();
            NeoForge.EVENT_BUS.addListener(ModEvents::ItemClick);
            NeoForge.EVENT_BUS.addListener(ModEvents::Living);
            NeoForge.EVENT_BUS.addListener(ModEvents::SleepingEvent);
            NeoForge.EVENT_BUS.addListener(ModEvents::StopPhantomsInPaleGarden);
        });
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
    }

    private void handleRegisterMenuScreens(RegisterMenuScreensEvent event) {
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
    }

    @EventBusSubscriber(modid="creaking_expanded", bus=EventBusSubscriber.Bus.MOD)
    public static class Register {
        @SubscribeEvent
        public static void registerAttributes(EntityAttributeCreationEvent event) {
            event.put(EntityRegistry.FRIENDLY_CREAKING.get(), CreakingGolem.createAttributes().build());
            event.put(EntityRegistry.PALE_EYE.get(), PaleEyeEntity.createAttributes().build());
            event.put(EntityRegistry.ANCIENT_SPRITE.get(), SpriteEntity.createAttributes().build());
            event.put(EntityRegistry.PALE_CREEPER.get(), PaleCreeperEntity.createAttributes().build());
        }
    }

    @EventBusSubscriber(modid="creaking_expanded", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class EntityBits {
        public static final ModelLayerLocation CREAKING_GUARD = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"creaking_expanded", (String)"creaking_guard"), "main");
        public static final ModelLayerLocation PALE_EYE = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"creaking_expanded", (String)"pale_eye"), "main");
        public static final ModelLayerLocation ANCIENT_SPRITE = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"creaking_expanded", (String)"ancient_sprite"), "main");
        public static final ModelLayerLocation CREAKING_GUARD_ARMOR = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"creaking_expanded", (String)"creaking_guard_armor"), "main");

        @SubscribeEvent
        public static void registerEntityRenders(EntityRenderersEvent.RegisterRenderers event) {
            event.registerEntityRenderer(EntityRegistry.FRIENDLY_CREAKING.get(), FriendlyCreakingRenderer::new);
            event.registerEntityRenderer(EntityRegistry.PALE_EYE.get(), PaleEyeRenderer::new);
            event.registerEntityRenderer(EntityRegistry.ANCIENT_SPRITE.get(), AncientSpriteRenderer::new);
            event.registerEntityRenderer(EntityRegistry.PALE_CREEPER.get(), PaleCreeperRenderer::new);
        }

        @SubscribeEvent
        public static void registerEntityModels(EntityRenderersEvent.RegisterLayerDefinitions event) {
            event.registerLayerDefinition(PALE_EYE, PaleEyeModel::createBodyLayer);
            event.registerLayerDefinition(CREAKING_GUARD, CreakingGuardModel::createMesh);
            event.registerLayerDefinition(ANCIENT_SPRITE, AncientSpriteModel::createBodyLayer);
            event.registerLayerDefinition(CREAKING_GUARD_ARMOR, CreakingGuardModel::createArmorMesh);
        }
    }

    @EventBusSubscriber(modid="creaking_expanded", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
        }
    }
}

