/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.creaking_expanded.blocks;

import com.belgie.creaking_expanded.registry.BlockRegistry;
import com.belgie.creaking_expanded.registry.ParticleRegistry;
import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class NightSporeBlock
extends Block {
    public static final MapCodec<NightSporeBlock> CODEC = NightSporeBlock.simpleCodec(NightSporeBlock::new);
    private static final VoxelShape SHAPE = Block.box((double)2.0, (double)13.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    private static final int ADD_PARTICLE_ATTEMPTS = 14;
    private static final int PARTICLE_XZ_RADIUS = 10;
    private static final int PARTICLE_Y_MAX = 10;
    public static BooleanProperty BLOOMING = BlockStateProperties.BLOOM;

    public MapCodec<NightSporeBlock> codec() {
        return CODEC;
    }

    public NightSporeBlock(BlockBehaviour.Properties p_154697_) {
        super(p_154697_);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)BLOOMING, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)BLOOMING, (Comparable)Boolean.valueOf(context.getLevel().isNight()));
    }

    protected boolean propagatesSkylightDown(BlockState p_380235_) {
        return true;
    }

    protected boolean canSurvive(BlockState p_380096_, LevelReader p_379969_, BlockPos p_380283_) {
        return this.canStayAtPosition((BlockGetter)p_379969_, p_380283_);
    }

    private boolean canStayAtPosition(BlockGetter p_379546_, BlockPos p_379355_) {
        BlockPos blockpos = p_379355_.relative(Direction.UP);
        BlockState blockstate = p_379546_.getBlockState(blockpos);
        return MultifaceBlock.canAttachTo((BlockGetter)p_379546_, (Direction)Direction.UP, (BlockPos)blockpos, (BlockState)blockstate);
    }

    protected BlockState updateShape(BlockState p_380182_, LevelReader p_380219_, ScheduledTickAccess p_380011_, BlockPos p_380024_, Direction p_380101_, BlockPos p_380258_, BlockState p_379654_, RandomSource p_379547_) {
        if (!this.canStayAtPosition((BlockGetter)p_380219_, p_380024_)) {
            p_380011_.scheduleTick(p_380024_, (Block)this, 1);
        }
        return p_380182_;
    }

    protected void tick(BlockState p_381085_, ServerLevel p_381014_, BlockPos p_381010_, RandomSource p_380962_) {
        this.tryChangingState(p_381085_, p_381014_, p_381010_, p_380962_);
        if (!this.canStayAtPosition((BlockGetter)p_381014_, p_381010_)) {
            p_381014_.destroyBlock(p_381010_, true);
        }
    }

    protected void randomTick(BlockState p_382824_, ServerLevel p_382831_, BlockPos p_382957_, RandomSource p_382888_) {
        this.tryChangingState(p_382824_, p_382831_, p_382957_, p_382888_);
        super.randomTick(p_382824_, p_382831_, p_382957_, p_382888_);
    }

    private void tryChangingState(BlockState p_383235_, ServerLevel p_383091_, BlockPos p_383073_, RandomSource p_383038_) {
        p_383091_.setBlock(p_383073_, p_383091_.isNight() ? (BlockState)((Block)BlockRegistry.NIGHTBLOSSOM.get()).defaultBlockState().setValue((Property)BLOOMING, (Comparable)Boolean.valueOf(true)) : (BlockState)((Block)BlockRegistry.NIGHTBLOSSOM.get()).defaultBlockState().setValue((Property)BLOOMING, (Comparable)Boolean.valueOf(false)), 3);
        p_383091_.gameEvent((Holder)GameEvent.BLOCK_CHANGE, p_383073_, GameEvent.Context.of((BlockState)p_383235_));
        BlockPos.betweenClosed((BlockPos)p_383073_.offset(-3, -2, -3), (BlockPos)p_383073_.offset(3, 2, 3)).forEach(p_383198_ -> {
            BlockState blockstate = p_383091_.getBlockState(p_383198_);
            if (blockstate == p_383235_) {
                double d0 = Math.sqrt(p_383073_.distSqr((Vec3i)p_383198_));
                int i = p_383038_.nextIntBetweenInclusive((int)(d0 * 5.0), (int)(d0 * 10.0));
                p_383091_.scheduleTick(p_383198_, p_383235_.getBlock(), i);
            }
        });
    }

    public void animateTick(BlockState p_222503_, Level p_222504_, BlockPos p_222505_, RandomSource p_222506_) {
        BlockState blockstate;
        int i = p_222505_.getX();
        int j = p_222505_.getY();
        int k = p_222505_.getZ();
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        if (((Boolean)p_222503_.getValue((Property)BLOOMING)).booleanValue()) {
            for (int l = 0; l < 2; ++l) {
                blockpos$mutableblockpos.set(i + Mth.nextInt((RandomSource)p_222506_, (int)-10, (int)10), j - p_222506_.nextInt(10), k + Mth.nextInt((RandomSource)p_222506_, (int)-10, (int)10));
                BlockState blockstate2 = p_222504_.getBlockState((BlockPos)blockpos$mutableblockpos);
                if (blockstate2.isCollisionShapeFullBlock((BlockGetter)p_222504_, (BlockPos)blockpos$mutableblockpos)) continue;
                p_222504_.addParticle((ParticleOptions)ParticleRegistry.CREAKING_EYES.get(), (double)blockpos$mutableblockpos.getX() + p_222506_.nextDouble(), (double)blockpos$mutableblockpos.getY() + p_222506_.nextDouble(), (double)blockpos$mutableblockpos.getZ() + p_222506_.nextDouble(), 0.0, 0.0, 0.0);
            }
        }
        if (p_222506_.nextInt(500) == 0 && ((blockstate = p_222504_.getBlockState(p_222505_.above())).is(BlockTags.PALE_OAK_LOGS) || blockstate.is(Blocks.PALE_OAK_LEAVES))) {
            p_222504_.playLocalSound((double)p_222505_.getX(), (double)p_222505_.getY(), (double)p_222505_.getZ(), SoundEvents.PALE_HANGING_MOSS_IDLE, SoundSource.BLOCKS, 1.0f, 1.0f, false);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BLOOMING});
    }

    protected VoxelShape getShape(BlockState p_154699_, BlockGetter p_154700_, BlockPos p_154701_, CollisionContext p_154702_) {
        return SHAPE;
    }
}

