/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.creaking_expanded.blocks;

import com.belgie.creaking_expanded.blockentity.ResinPulserBlockEntity;
import com.belgie.creaking_expanded.registry.BlockEntityRegistry;
import com.belgie.creaking_expanded.registry.ParticleRegistry;
import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ResinPulserBlock
extends BaseEntityBlock {
    public static final MapCodec<ResinPulserBlock> CODEC = ResinPulserBlock.simpleCodec(ResinPulserBlock::new);
    public static final BooleanProperty PARTICLES = BlockStateProperties.DISARMED;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;

    public MapCodec<ResinPulserBlock> codec() {
        return CODEC;
    }

    public ResinPulserBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)PARTICLES, (Comparable)Boolean.valueOf(true))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (!player.mayBuild()) {
            return super.useWithoutItem(state, level, pos, player, hitResult);
        }
        if (!level.isClientSide) {
            BlockState blockstate = (BlockState)state.cycle((Property)PARTICLES);
            level.setBlock(pos, blockstate, 2);
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)player, (BlockState)blockstate));
        }
        return InteractionResult.SUCCESS;
    }

    protected boolean useShapeForLightOcclusion(BlockState state) {
        return true;
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new ResinPulserBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return ResinPulserBlock.createTickerHelper(blockEntityType, BlockEntityRegistry.RESIN_PULER.get(), ResinPulserBlockEntity::tick);
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.makeShape();
    }

    public VoxelShape makeShape() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.125, (double)0.0, (double)0.125, (double)0.875, (double)0.1875, (double)0.875), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.25, (double)0.1875, (double)0.25, (double)0.75, (double)0.9375, (double)0.75), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{PARTICLES, POWERED});
    }

    public void animateTick(BlockState p_222503_, Level p_222504_, BlockPos p_222505_, RandomSource p_222506_) {
        if (((Boolean)p_222503_.getValue((Property)PARTICLES)).booleanValue()) {
            int i = p_222505_.getX();
            int j = p_222505_.getY();
            int k = p_222505_.getZ();
            for (int l = 0; l < 6; ++l) {
                BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
                blockpos$mutableblockpos.set(i + Mth.nextInt((RandomSource)p_222506_, (int)-32, (int)32), j - p_222506_.nextInt(10), k + Mth.nextInt((RandomSource)p_222506_, (int)-32, (int)32));
                BlockState blockstate = p_222504_.getBlockState((BlockPos)blockpos$mutableblockpos);
                if (blockstate.isCollisionShapeFullBlock((BlockGetter)p_222504_, (BlockPos)blockpos$mutableblockpos)) continue;
                p_222504_.addParticle((ParticleOptions)ParticleRegistry.RESIN_MOTH.get(), (double)blockpos$mutableblockpos.getX() + p_222506_.nextDouble(), (double)blockpos$mutableblockpos.getY() + p_222506_.nextDouble(), (double)blockpos$mutableblockpos.getZ() + p_222506_.nextDouble(), 0.0, 0.0, 0.0);
            }
        }
    }
}

