/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.creaking_expanded.blocks;

import com.belgie.creaking_expanded.CreakingExpanded;
import com.belgie.creaking_expanded.registry.BlockRegistry;
import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.BaseTorchBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RedstoneTorchBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;

public class ResinTorchBlock
extends BaseTorchBlock {
    public static final MapCodec<ResinTorchBlock> CODEC = ResinTorchBlock.simpleCodec(ResinTorchBlock::new);
    public static final BooleanProperty LIT = RedstoneTorchBlock.LIT;
    private static final int EYEBLOSSOM_XZ_RANGE = 3;
    private static final int EYEBLOSSOM_Y_RANGE = 2;

    public MapCodec<? extends ResinTorchBlock> codec() {
        return CODEC;
    }

    public ResinTorchBlock(BlockBehaviour.Properties p_383158_) {
        super(p_383158_);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    protected void randomTick(BlockState p_382824_, ServerLevel p_382831_, BlockPos p_382957_, RandomSource p_382888_) {
        this.tryChangingState(p_382824_, p_382831_, p_382957_, p_382888_);
        super.randomTick(p_382824_, p_382831_, p_382957_, p_382888_);
    }

    protected void tick(BlockState p_382808_, ServerLevel p_383005_, BlockPos p_383211_, RandomSource p_383088_) {
        this.tryChangingState(p_382808_, p_383005_, p_383211_, p_383088_);
        super.tick(p_382808_, p_383005_, p_383211_, p_383088_);
    }

    private void tryChangingState(BlockState p_383235_, ServerLevel p_383091_, BlockPos p_383073_, RandomSource p_383038_) {
        if (p_383091_.isNight() && !((Boolean)p_383235_.getValue((Property)LIT)).booleanValue()) {
            CreakingExpanded.LOGGER.info("Ticking Night");
            p_383091_.setBlock(p_383073_, (BlockState)((Block)BlockRegistry.RESIN_TORCH.get()).defaultBlockState().setValue((Property)LIT, (Comparable)Boolean.valueOf(true)), 3);
            p_383091_.gameEvent((Holder)GameEvent.BLOCK_CHANGE, p_383073_, GameEvent.Context.of((BlockState)p_383235_));
            BlockPos.betweenClosed((BlockPos)p_383073_.offset(-3, -2, -3), (BlockPos)p_383073_.offset(3, 2, 3)).forEach(p_383198_ -> {
                BlockState blockstate = p_383091_.getBlockState(p_383198_);
                if (blockstate == p_383235_) {
                    double d0 = Math.sqrt(p_383073_.distSqr((Vec3i)p_383198_));
                    int i = p_383038_.nextIntBetweenInclusive((int)(d0 * 5.0), (int)(d0 * 10.0));
                    p_383091_.scheduleTick(p_383198_, p_383235_.getBlock(), i);
                }
            });
        } else if (p_383091_.isDay() && ((Boolean)p_383235_.getValue((Property)LIT)).booleanValue()) {
            CreakingExpanded.LOGGER.info("Ticking Day");
            p_383091_.setBlock(p_383073_, (BlockState)((Block)BlockRegistry.RESIN_TORCH.get()).defaultBlockState().setValue((Property)LIT, (Comparable)Boolean.valueOf(false)), 3);
            p_383091_.gameEvent((Holder)GameEvent.BLOCK_CHANGE, p_383073_, GameEvent.Context.of((BlockState)p_383235_));
            BlockPos.betweenClosed((BlockPos)p_383073_.offset(-3, -2, -3), (BlockPos)p_383073_.offset(3, 2, 3)).forEach(p_383198_ -> {
                BlockState blockstate = p_383091_.getBlockState(p_383198_);
                if (blockstate == p_383235_) {
                    double d0 = Math.sqrt(p_383073_.distSqr((Vec3i)p_383198_));
                    int i = p_383038_.nextIntBetweenInclusive((int)(d0 * 5.0), (int)(d0 * 10.0));
                    p_383091_.scheduleTick(p_383198_, p_383235_.getBlock(), i);
                }
            });
        }
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)LIT, (Comparable)Boolean.valueOf(context.getLevel().isNight()));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{LIT});
    }
}

