/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.creaking_expanded.blocks;

import com.belgie.creaking_expanded.registry.BlockRegistry;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.serialization.MapCodec;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RedstoneTorchBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.TorchBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ResinWallTorchBlock
extends TorchBlock {
    public static final MapCodec<ResinWallTorchBlock> CODEC = ResinWallTorchBlock.simpleCodec(ResinWallTorchBlock::new);
    public static final EnumProperty<Direction> FACING;
    protected static final float AABB_OFFSET = 2.5f;
    private static final Map<Direction, VoxelShape> AABBS;
    public static final BooleanProperty LIT;

    public MapCodec<ResinWallTorchBlock> codec() {
        return CODEC;
    }

    public ResinWallTorchBlock(BlockBehaviour.Properties properties) {
        super(ParticleTypes.WAX_ON, properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)LIT, (Comparable)Boolean.valueOf(false))).setValue(FACING, (Comparable)Direction.NORTH));
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return ResinWallTorchBlock.getShape(state);
    }

    public static VoxelShape getShape(BlockState state) {
        return AABBS.get(state.getValue(FACING));
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return ResinWallTorchBlock.canSurvive(level, pos, (Direction)state.getValue(FACING));
    }

    public static boolean canSurvive(LevelReader level, BlockPos pos, Direction facing) {
        BlockPos blockpos = pos.relative(facing.getOpposite());
        BlockState blockstate = level.getBlockState(blockpos);
        return blockstate.isFaceSturdy((BlockGetter)level, blockpos, facing);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction[] adirection;
        BlockState blockstate = this.defaultBlockState();
        Level levelreader = context.getLevel();
        BlockPos blockpos = context.getClickedPos();
        Direction[] var6 = adirection = context.getNearestLookingDirections();
        int var7 = adirection.length;
        for (int var8 = 0; var8 < var7; ++var8) {
            Direction direction1;
            Direction direction = var6[var8];
            if (!direction.getAxis().isHorizontal() || !(blockstate = (BlockState)((BlockState)blockstate.setValue(FACING, (Comparable)(direction1 = direction.getOpposite()))).setValue((Property)LIT, (Comparable)Boolean.valueOf(context.getLevel().isNight()))).canSurvive((LevelReader)levelreader, blockpos)) continue;
            return blockstate;
        }
        return null;
    }

    protected BlockState updateShape(BlockState p_58143_, LevelReader p_374329_, ScheduledTickAccess p_374207_, BlockPos p_58147_, Direction p_58144_, BlockPos p_58148_, BlockState p_58145_, RandomSource p_374234_) {
        return p_58144_.getOpposite() == p_58143_.getValue(FACING) && !p_58143_.canSurvive(p_374329_, p_58147_) ? Blocks.AIR.defaultBlockState() : p_58143_;
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        Direction direction = (Direction)state.getValue(FACING);
        double d0 = (double)pos.getX() + 0.5;
        double d1 = (double)pos.getY() + 0.7;
        double d2 = (double)pos.getZ() + 0.5;
        double d3 = 0.22;
        double d4 = 0.27;
        Direction direction1 = direction.getOpposite();
        level.addParticle((ParticleOptions)ParticleTypes.SMOKE, d0 + 0.27 * (double)direction1.getStepX(), d1 + 0.22, d2 + 0.27 * (double)direction1.getStepZ(), 0.0, 0.0, 0.0);
        level.addParticle((ParticleOptions)ParticleTypes.WAX_ON, d0 + 0.27 * (double)direction1.getStepX(), d1 + 0.22, d2 + 0.27 * (double)direction1.getStepZ(), 0.0, 0.0, 0.0);
    }

    protected BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue(FACING, (Comparable)rotation.rotate((Direction)state.getValue(FACING)));
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue(FACING)));
    }

    protected void randomTick(BlockState p_382824_, ServerLevel p_382831_, BlockPos p_382957_, RandomSource p_382888_) {
        this.tryChangingState(p_382824_, p_382831_, p_382957_, p_382888_);
        super.randomTick(p_382824_, p_382831_, p_382957_, p_382888_);
    }

    protected void tick(BlockState p_382808_, ServerLevel p_383005_, BlockPos p_383211_, RandomSource p_383088_) {
        this.tryChangingState(p_382808_, p_383005_, p_383211_, p_383088_);
        super.tick(p_382808_, p_383005_, p_383211_, p_383088_);
    }

    private void tryChangingState(BlockState p_383235_, ServerLevel p_383091_, BlockPos p_383073_, RandomSource p_383038_) {
        p_383091_.setBlock(p_383073_, p_383091_.isNight() ? (BlockState)((BlockState)((Block)BlockRegistry.RESIN_WALL_TORCH.get()).defaultBlockState().setValue((Property)LIT, (Comparable)Boolean.valueOf(true))).setValue(FACING, (Comparable)((Direction)p_383235_.getValue(FACING))) : (BlockState)((BlockState)((Block)BlockRegistry.RESIN_WALL_TORCH.get()).defaultBlockState().setValue((Property)LIT, (Comparable)Boolean.valueOf(false))).setValue(FACING, (Comparable)((Direction)p_383235_.getValue(FACING))), 3);
        p_383091_.gameEvent((Holder)GameEvent.BLOCK_CHANGE, p_383073_, GameEvent.Context.of((BlockState)p_383235_));
        BlockPos.betweenClosed((BlockPos)p_383073_.offset(-3, -2, -3), (BlockPos)p_383073_.offset(3, 2, 3)).forEach(p_383198_ -> {
            BlockState blockstate = p_383091_.getBlockState(p_383198_);
            if (blockstate == p_383235_) {
                double d0 = Math.sqrt(p_383073_.distSqr((Vec3i)p_383198_));
                int i = p_383038_.nextIntBetweenInclusive((int)(d0 * 5.0), (int)(d0 * 10.0));
                p_383091_.scheduleTick(p_383198_, p_383235_.getBlock(), i);
            }
        });
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, LIT});
    }

    static {
        LIT = RedstoneTorchBlock.LIT;
        FACING = HorizontalDirectionalBlock.FACING;
        AABBS = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.box((double)5.5, (double)3.0, (double)11.0, (double)10.5, (double)13.0, (double)16.0), (Object)Direction.SOUTH, (Object)Block.box((double)5.5, (double)3.0, (double)0.0, (double)10.5, (double)13.0, (double)5.0), (Object)Direction.WEST, (Object)Block.box((double)11.0, (double)3.0, (double)5.5, (double)16.0, (double)13.0, (double)10.5), (Object)Direction.EAST, (Object)Block.box((double)0.0, (double)3.0, (double)5.5, (double)5.0, (double)13.0, (double)10.5)));
    }
}

