/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.creaking_expanded.datagen;

import com.belgie.creaking_expanded.datagen.ModBlockLootTableProvider;
import com.belgie.creaking_expanded.datagen.ModBlockStateProvider;
import com.belgie.creaking_expanded.datagen.ModBlockTagProvider;
import com.belgie.creaking_expanded.datagen.ModItemModelProvider;
import com.belgie.creaking_expanded.datagen.ModItemTagProvider;
import com.belgie.creaking_expanded.datagen.ModLangGenerators;
import com.belgie.creaking_expanded.datagen.ModRecipeProvider;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="creaking_expanded", bus=EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent.Client event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(true, (DataProvider)new LootTableProvider(packOutput, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(ModBlockLootTableProvider::new, LootContextParamSets.BLOCK)), lookupProvider));
        generator.addProvider(true, (DataProvider)new ModRecipeProvider.Runner(packOutput, lookupProvider));
        ModBlockTagProvider blockTagsProvider = new ModBlockTagProvider(packOutput, lookupProvider, existingFileHelper);
        generator.addProvider(true, (DataProvider)blockTagsProvider);
        generator.addProvider(true, (DataProvider)new ModItemTagProvider(packOutput, lookupProvider, blockTagsProvider.contentsGetter(), existingFileHelper));
    }

    @SubscribeEvent
    public static void gatherDataServer(GatherDataEvent.Server event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(true, (DataProvider)new ModLangGenerators(packOutput));
        generator.addProvider(true, (DataProvider)new ModItemModelProvider(packOutput, existingFileHelper));
        generator.addProvider(true, (DataProvider)new ModBlockStateProvider(packOutput, existingFileHelper));
    }
}

