/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.creaking_expanded.entity;

import com.belgie.creaking_expanded.registry.EntityRegistry;
import com.belgie.creaking_expanded.registry.LootTableRegistry;
import com.belgie.creaking_expanded.registry.TagRegistry;
import io.netty.buffer.ByteBuf;
import java.util.function.IntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.control.JumpControl;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class SpriteEntity
extends Animal {
    private static final EntityDataAccessor<Boolean> CAN_MOVE = SynchedEntityData.defineId(SpriteEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> IS_SLEEPING;
    private static final EntityDataAccessor<Boolean> IS_EATING;
    private static final EntityDataAccessor<Integer> GIVE_COOLDOWN;
    public int COOLDOWN = 0;
    private static final EntityDataAccessor<State> DATA_STATE;
    private static final EntityDataAccessor<Integer> DATA_DROP_SEED_AT_TICK;
    public final AnimationState eatingAnimation = new AnimationState();
    public final AnimationState sleepingAnimation = new AnimationState();
    public final AnimationState idleAnimation = new AnimationState();

    public SpriteEntity(EntityType<? extends SpriteEntity> p_380212_, Level p_379294_) {
        super(p_380212_, p_379294_);
        this.lookControl = new CreakingLookControl(this);
        this.moveControl = new CreakingMoveControl(this);
        this.jumpControl = new CreakingJumpControl(this);
        GroundPathNavigation groundpathnavigation = (GroundPathNavigation)this.getNavigation();
        groundpathnavigation.setCanFloat(true);
        this.xpReward = 0;
    }

    protected BodyRotationControl createBodyControl() {
        return new CreakingBodyRotationControl(this);
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        return null;
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (itemstack.is(TagRegistry.ANCIENT_SPRITE_EATS) && this.EatingCoolDown() == 0 && this.getState() != State.SLEEPING && this.getState() != State.EATING) {
            this.transitionTo(State.EATING);
            if (!player.isCreative()) {
                itemstack.shrink(1);
            }
            this.SetEatingCoolDown(6000);
            this.level().playSound(player, (Entity)this, SoundEvents.AMETHYST_BLOCK_CHIME, SoundSource.NEUTRAL, 2.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(player, hand);
    }

    public boolean hurtServer(ServerLevel p_389623_, DamageSource p_389564_, float p_389723_) {
        if (!p_389564_.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            return true;
        }
        return super.hurtServer(p_389623_, p_389564_, p_389723_);
    }

    protected void defineSynchedData(SynchedEntityData.Builder p_379982_) {
        super.defineSynchedData(p_379982_);
        p_379982_.define(DATA_STATE, (Object)State.IDLING);
        p_379982_.define(DATA_DROP_SEED_AT_TICK, (Object)0);
        p_379982_.define(CAN_MOVE, (Object)false);
        p_379982_.define(IS_EATING, (Object)false);
        p_379982_.define(IS_SLEEPING, (Object)false);
        p_379982_.define(GIVE_COOLDOWN, (Object)0);
    }

    public int EatingCoolDown() {
        return (Integer)this.entityData.get(GIVE_COOLDOWN);
    }

    public void SetEatingCoolDown(int cool) {
        this.entityData.set(GIVE_COOLDOWN, (Object)cool);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 1.0).add(Attributes.MOVEMENT_SPEED, (double)0.4f).add(Attributes.ATTACK_DAMAGE, 3.0).add(Attributes.FOLLOW_RANGE, 32.0).add(Attributes.STEP_HEIGHT, 1.0625);
    }

    public boolean canMove() {
        return (Boolean)this.entityData.get(CAN_MOVE);
    }

    public boolean isEating() {
        return this.getState() == State.EATING;
    }

    public boolean isSleeping() {
        return this.getState() == State.SLEEPING;
    }

    private State getState() {
        return (State)((Object)this.entityData.get(DATA_STATE));
    }

    private SpriteEntity setState(State state) {
        this.entityData.set(DATA_STATE, (Object)state);
        return this;
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        if (DATA_STATE.equals(key)) {
            State sniffer$state = this.getState();
            this.resetAnimations();
            switch (sniffer$state.ordinal()) {
                case 0: {
                    this.idleAnimation.startIfStopped(this.tickCount);
                    break;
                }
                case 1: {
                    this.sleepingAnimation.startIfStopped(this.tickCount);
                    break;
                }
                case 2: {
                    this.eatingAnimation.startIfStopped(this.tickCount);
                    break;
                }
            }
            this.refreshDimensions();
        }
        super.onSyncedDataUpdated(key);
    }

    private void resetAnimations() {
        this.idleAnimation.stop();
        this.eatingAnimation.stop();
        this.sleepingAnimation.stop();
    }

    public SpriteEntity transitionTo(State state) {
        switch (state.ordinal()) {
            case 0: {
                this.setState(State.IDLING);
                break;
            }
            case 1: {
                this.setState(State.SLEEPING);
                break;
            }
            case 2: {
                this.setState(State.EATING).OnEatingStart();
            }
        }
        return this;
    }

    public void tick() {
        if (this.EatingCoolDown() != 0) {
            this.SetEatingCoolDown(this.EatingCoolDown() - 1);
        }
        switch (this.getState().ordinal()) {
            case 2: {
                this.emitDiggingParticles(this.eatingAnimation).giveMorningGift();
            }
        }
        if (this.getState() == State.IDLING) {
            this.idleAnimation.startIfStopped(this.tickCount);
        }
        if (this.level().isNight() && this.getState() != State.IDLING && this.getState() != State.EATING) {
            this.transitionTo(State.IDLING);
        }
        if (this.level().isDay() && this.getState() != State.SLEEPING) {
            this.transitionTo(State.SLEEPING);
        }
        super.tick();
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor p_146746_, DifficultyInstance p_146747_, EntitySpawnReason p_363316_, @Nullable SpawnGroupData p_146749_) {
        this.setState(State.IDLING);
        return super.finalizeSpawn(p_146746_, p_146747_, p_363316_, p_146749_);
    }

    private SpriteEntity emitDiggingParticles(AnimationState animationState) {
        boolean flag1;
        boolean flag = animationState.getTimeInMillis((float)this.tickCount) > 800L && animationState.getTimeInMillis((float)this.tickCount) < 4700L;
        boolean bl = flag1 = animationState.getTimeInMillis((float)this.tickCount) > 6900L && animationState.getTimeInMillis((float)this.tickCount) < 7000L;
        if (flag) {
            BlockPos blockpos = this.getOnPos().above();
            BlockState blockstate = this.level().getBlockState(blockpos.below());
            if (blockstate.getRenderShape() != RenderShape.INVISIBLE) {
                for (int i = 0; i < 30; ++i) {
                    Vec3 vec3 = this.getBoundingBox().getCenter();
                    this.level().addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, Blocks.CREAKING_HEART.defaultBlockState()), vec3.x, vec3.y, vec3.z, 0.0, 0.0, 0.0);
                }
                if (this.tickCount % 10 == 0) {
                    this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), blockstate.getSoundType((LevelReader)this.level(), blockpos.below(), (Entity)this).getHitSound(), this.getSoundSource(), 0.5f, 0.5f, false);
                }
            }
        }
        if (flag1) {
            this.transitionTo(State.IDLING);
        }
        if (this.tickCount % 10 == 0) {
            this.level().gameEvent((Holder)GameEvent.ENTITY_ACTION, this.getOnPos().above(), GameEvent.Context.of((Entity)this));
        }
        return this;
    }

    private SpriteEntity OnEatingStart() {
        this.entityData.set(DATA_DROP_SEED_AT_TICK, (Object)(this.tickCount + 130));
        return this;
    }

    public boolean isPushable() {
        return false;
    }

    public void push(double p_388562_, double p_388936_, double p_387604_) {
        if (this.canMove()) {
            super.push(p_388562_, p_388936_, p_387604_);
        }
    }

    public boolean fireImmune() {
        return true;
    }

    public boolean canBeNameTagged() {
        return false;
    }

    protected boolean canAddPassenger(Entity p_389469_) {
        return false;
    }

    protected boolean couldAcceptPassenger() {
        return false;
    }

    protected void addPassenger(Entity p_389484_) {
        throw new IllegalStateException("Should never addPassenger without checking couldAcceptPassenger()");
    }

    public boolean canUsePortal(boolean p_389552_) {
        return false;
    }

    public void knockback(double p_379489_, double p_380324_, double p_379735_) {
        if (this.canMove()) {
            super.knockback(p_379489_, p_380324_, p_379735_);
        }
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("EatingCooldown", this.EatingCoolDown());
        compound.putString("State", this.getState().name());
    }

    public boolean canBeLeashed() {
        return false;
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        this.SetEatingCoolDown(compound.getInt("EatingCooldown"));
        this.setState(State.byName(compound.getString("State")));
        super.readAdditionalSaveData(compound);
    }

    public boolean checkCanMove() {
        return false;
    }

    private void giveMorningGift() {
        Level var2 = this.level();
        if (var2 instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)var2;
            if ((Integer)this.entityData.get(DATA_DROP_SEED_AT_TICK) == this.tickCount) {
                BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
                blockpos$mutableblockpos.set((Vec3i)this.blockPosition());
                blockpos$mutableblockpos.set((Vec3i)this.blockPosition());
                this.dropFromGiftLootTable(serverlevel, LootTableRegistry.ANCIENT_SPRITE_TRADES, (p_375797_, p_375798_) -> {
                    if (!p_375798_.isEmpty()) {
                        Vec3 vec3 = this.getBoundingBox().getCenter();
                        Vec3 vec31 = this.position().add(0.0, 1.5, 0.0);
                        DefaultDispenseItemBehavior.spawnItem((Level)var2, (ItemStack)p_375798_, (int)12, (Direction)this.getDirection(), (Position)vec31);
                    }
                });
            }
        }
    }

    public float getWalkTargetValue(BlockPos p_379756_, LevelReader p_380102_) {
        return 0.0f;
    }

    public boolean isFood(ItemStack itemStack) {
        return false;
    }

    static {
        IS_EATING = SynchedEntityData.defineId(SpriteEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
        IS_SLEEPING = SynchedEntityData.defineId(SpriteEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
        GIVE_COOLDOWN = SynchedEntityData.defineId(SpriteEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
        DATA_STATE = SynchedEntityData.defineId(SpriteEntity.class, EntityRegistry.SNIFFER_STATE.get());
        DATA_DROP_SEED_AT_TICK = SynchedEntityData.defineId(SpriteEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    }

    class CreakingLookControl
    extends LookControl {
        public CreakingLookControl(SpriteEntity p_379883_) {
            super((Mob)p_379883_);
        }

        public void tick() {
            if (SpriteEntity.this.canMove()) {
                super.tick();
            }
        }
    }

    class CreakingMoveControl
    extends MoveControl {
        public CreakingMoveControl(SpriteEntity p_380148_) {
            super((Mob)p_380148_);
        }

        public void tick() {
            if (SpriteEntity.this.canMove()) {
                super.tick();
            }
        }
    }

    class CreakingJumpControl
    extends JumpControl {
        public CreakingJumpControl(SpriteEntity p_379900_) {
            super((Mob)p_379900_);
        }

        public void tick() {
            if (SpriteEntity.this.canMove()) {
                super.tick();
            } else {
                SpriteEntity.this.setJumping(false);
            }
        }
    }

    class CreakingBodyRotationControl
    extends BodyRotationControl {
        public CreakingBodyRotationControl(SpriteEntity p_380382_) {
            super((Mob)p_380382_);
        }

        public void clientTick() {
            if (SpriteEntity.this.canMove()) {
                super.clientTick();
            }
        }
    }

    public static enum State implements StringRepresentable
    {
        IDLING(0),
        SLEEPING(1),
        EATING(2);

        public static final StringRepresentable.EnumCodec<State> CODEC;
        public static final IntFunction<State> BY_ID;
        public static final StreamCodec<ByteBuf, State> STREAM_CODEC;
        private final int id;

        private State(int id) {
            this.id = id;
        }

        public int id() {
            return this.id;
        }

        static State byName(String p_364149_) {
            return (State)CODEC.byName(p_364149_, (Enum)IDLING);
        }

        public String getSerializedName() {
            return this.name();
        }

        static {
            CODEC = StringRepresentable.fromEnum(State::values);
            BY_ID = ByIdMap.continuous(State::id, (Object[])State.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, State::id);
        }
    }
}

