/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.creaking_expanded.entity.model;

import com.belgie.creaking_expanded.entity.renderstate.CreakingGuardRenderState;
import java.util.List;
import net.minecraft.client.animation.definitions.CreakingAnimation;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CreakingGuardModel
extends EntityModel<CreakingGuardRenderState> {
    public static final List<ModelPart> NO_PARTS = List.of();
    public final ModelPart root;
    private final ModelPart head;
    private final List<ModelPart> headParts;

    public CreakingGuardModel(ModelPart p_380297_) {
        super(p_380297_);
        this.root = p_380297_;
        ModelPart modelpart = p_380297_.getChild("root");
        ModelPart modelpart1 = modelpart.getChild("upper_body");
        this.head = modelpart1.getChild("head");
        this.headParts = List.of(this.head);
    }

    public static LayerDefinition createMesh() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition partdefinition1 = partdefinition.addOrReplaceChild("root", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition partdefinition2 = partdefinition1.addOrReplaceChild("upper_body", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head = partdefinition2.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -10.0f, -3.0f, 6.0f, 10.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(28, 31).addBox(-3.0f, -13.0f, -3.0f, 6.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(12, 40).addBox(3.0f, -13.0f, 0.0f, 9.0f, 14.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(34, 12).addBox(-12.0f, -14.0f, 0.0f, 9.0f, 14.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-0.5f, (float)-6.0f, (float)0.5f));
        PartDefinition body = partdefinition2.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 16).addBox(-4.5f, -13.0f, -3.0f, 9.0f, 13.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(24, 0).addBox(-3.0f, -14.0f, -3.0f, 6.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-0.5f, (float)8.0f, (float)1.0f));
        PartDefinition left_arm = partdefinition2.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(52, 12).addBox(0.0f, -3.0f, -1.5f, 3.0f, 21.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(46, 0).addBox(0.0f, 18.0f, -1.5f, 3.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)4.0f, (float)-3.0f, (float)0.5f));
        PartDefinition right_arm = partdefinition2.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(52, 12).addBox(-3.0f, -3.0f, -1.5f, 3.0f, 21.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(46, 0).addBox(-3.0f, 18.0f, -1.5f, 3.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-5.0f, (float)-3.0f, (float)0.5f));
        PartDefinition left_leg = partdefinition1.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(0, 34).addBox(-1.5f, -3.0f, -1.5f, 3.0f, 19.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(45, 55).addBox(-0.5f, 15.7f, -4.5f, 5.0f, 0.0f, 9.0f, new CubeDeformation(0.0f)).texOffs(12, 34).addBox(-1.5f, -6.0f, -1.5f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.5f, (float)8.0f, (float)0.5f));
        PartDefinition right_leg = partdefinition1.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(0, 34).addBox(-1.5f, -3.0f, -1.5f, 3.0f, 19.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(45, 46).addBox(-3.5f, 15.7f, -4.5f, 5.0f, 0.0f, 9.0f, new CubeDeformation(0.0f)).texOffs(12, 34).addBox(-1.5f, -6.0f, -1.5f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.5f, (float)8.0f, (float)0.5f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public static LayerDefinition createArmorMesh() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition partdefinition1 = partdefinition.addOrReplaceChild("root", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition partdefinition2 = partdefinition1.addOrReplaceChild("upper_body", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head = partdefinition2.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -10.0f, -3.0f, 6.0f, 10.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(28, 31).addBox(-3.0f, -13.0f, -3.0f, 6.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(12, 40).addBox(3.0f, -13.0f, 0.0f, 9.0f, 14.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(34, 12).addBox(-12.0f, -14.0f, 0.0f, 9.0f, 14.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-0.5f, (float)-6.0f, (float)0.5f));
        PartDefinition body = partdefinition2.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 16).addBox(-4.5f, -13.0f, -3.0f, 9.0f, 13.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(24, 0).addBox(-3.0f, -14.0f, -3.0f, 6.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-0.5f, (float)8.0f, (float)1.0f));
        PartDefinition left_arm = partdefinition2.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(52, 12).addBox(0.0f, -3.0f, -1.5f, 3.0f, 21.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(46, 0).addBox(0.0f, 18.0f, -1.5f, 3.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)4.0f, (float)-3.0f, (float)0.5f));
        PartDefinition right_arm = partdefinition2.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(52, 12).addBox(-3.0f, -3.0f, -1.5f, 3.0f, 21.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(46, 0).addBox(-3.0f, 18.0f, -1.5f, 3.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-5.0f, (float)-3.0f, (float)0.5f));
        PartDefinition left_leg = partdefinition1.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(0, 34).addBox(-1.5f, -3.0f, -1.5f, 3.0f, 19.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(45, 55).addBox(-0.5f, 15.7f, -4.5f, 5.0f, 0.0f, 9.0f, new CubeDeformation(0.0f)).texOffs(12, 34).addBox(-1.5f, -6.0f, -1.5f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.5f, (float)8.0f, (float)0.5f));
        PartDefinition right_leg = partdefinition1.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(0, 34).addBox(-1.5f, -3.0f, -1.5f, 3.0f, 19.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(45, 46).addBox(-3.5f, 15.7f, -4.5f, 5.0f, 0.0f, 9.0f, new CubeDeformation(0.0f)).texOffs(12, 34).addBox(-1.5f, -6.0f, -1.5f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.5f, (float)8.0f, (float)0.5f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(CreakingGuardRenderState p_380306_) {
        super.setupAnim((EntityRenderState)p_380306_);
        this.head.xRot = p_380306_.xRot * ((float)Math.PI / 180);
        this.head.yRot = p_380306_.yRot * ((float)Math.PI / 180);
        if (p_380306_.canMove) {
            this.animateWalk(CreakingAnimation.CREAKING_WALK, p_380306_.walkAnimationPos, p_380306_.walkAnimationSpeed, 1.0f, 1.0f);
        }
        this.animate(p_380306_.attackAnimationState, CreakingAnimation.CREAKING_ATTACK, p_380306_.ageInTicks);
        this.animate(p_380306_.invulnerabilityAnimationState, CreakingAnimation.CREAKING_INVULNERABLE, p_380306_.ageInTicks);
        this.animate(p_380306_.deathAnimationState, CreakingAnimation.CREAKING_DEATH, p_380306_.ageInTicks);
    }

    public List<ModelPart> getHeadModelParts(CreakingGuardRenderState p_379307_) {
        return !p_379307_.eyesGlowing ? NO_PARTS : this.headParts;
    }

    public ModelPart getHead() {
        return this.head;
    }
}

