/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.creaking_expanded.entity.model;

import com.belgie.creaking_expanded.entity.renderstate.PaleEyeRenderState;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.util.Mth;

public class PaleEyeModel
extends EntityModel<PaleEyeRenderState> {
    private final ModelPart Base;
    private final ModelPart Lid;
    private final ModelPart Eye;

    public PaleEyeModel(ModelPart root) {
        super(root, RenderType::entityCutoutNoCullZOffset);
        this.Base = root.getChild("Base");
        this.Lid = root.getChild("Lid");
        this.Eye = root.getChild("Eye");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition Eye = partdefinition.addOrReplaceChild("Eye", CubeListBuilder.create().texOffs(32, 24).addBox(-5.0f, -4.0f, -1.0f, 10.0f, 7.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition Base = partdefinition.addOrReplaceChild("Base", CubeListBuilder.create().texOffs(0, 34).addBox(-8.0f, -14.0f, -8.0f, 16.0f, 14.0f, 16.0f, new CubeDeformation(0.0f)).texOffs(0, 34).addBox(-8.0f, -10.0f, -8.0f, 16.0f, 0.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition Lid = partdefinition.addOrReplaceChild("Lid", CubeListBuilder.create().texOffs(0, 0).addBox(-8.0f, 1.0f, -8.0f, 16.0f, 4.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(PaleEyeRenderState p_362026_) {
        super.setupAnim((EntityRenderState)p_362026_);
        float f = (0.5f + p_362026_.peekAmount) * (float)Math.PI;
        float f1 = -1.0f + Mth.sin((float)f);
        float f2 = 0.0f;
        if (f > (float)Math.PI) {
            f2 = Mth.sin((float)(p_362026_.ageInTicks * 0.1f)) * 0.7f;
        }
        this.Lid.setPos(0.0f, 0.0f + Mth.sin((float)f) * 8.0f + f2, 0.0f);
        this.Eye.setPos(0.0f, 10.0f + Mth.sin((float)f) * 8.0f + f2, 0.0f);
        if (p_362026_.peekAmount > 0.3f) {
            this.Lid.yRot = f1 * f1 * f1 * f1 * (float)Math.PI * 0.125f;
            this.Eye.yRot = f1 * f1 * f1 * f1 * (float)Math.PI * 0.125f;
        } else {
            this.Lid.yRot = 0.0f;
            this.Eye.yRot = 0.0f;
        }
        this.Eye.xRot = p_362026_.xRot * ((float)Math.PI / 180);
        this.Eye.yRot = (p_362026_.yHeadRot - 180.0f - p_362026_.yBodyRot) * ((float)Math.PI / 180);
    }
}

