/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.creaking_expanded.entity.renderer;

import com.belgie.creaking_expanded.entity.PaleCreeperEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.CreeperModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.CreeperPowerLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.CreeperRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PaleCreeperRenderer
extends MobRenderer<PaleCreeperEntity, CreeperRenderState, CreeperModel> {
    private static final ResourceLocation CREEPER_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"creaking_expanded", (String)"textures/entity/pale_creeper.png");

    public PaleCreeperRenderer(EntityRendererProvider.Context p_173958_) {
        super(p_173958_, (EntityModel)new CreeperModel(p_173958_.bakeLayer(ModelLayers.CREEPER)), 0.5f);
        this.addLayer((RenderLayer)new CreeperPowerLayer((RenderLayerParent)this, p_173958_.getModelSet()));
    }

    protected void scale(CreeperRenderState p_362568_, PoseStack p_114047_) {
        float f = p_362568_.swelling;
        float f1 = 1.0f + Mth.sin((float)(f * 100.0f)) * f * 0.01f;
        f = Mth.clamp((float)f, (float)0.0f, (float)1.0f);
        f *= f;
        f *= f;
        float f2 = (1.0f + f * 0.4f) * f1;
        float f3 = (1.0f + f * 0.1f) / f1;
        p_114047_.scale(f2, f3, f2);
    }

    protected float getWhiteOverlayProgress(CreeperRenderState p_360678_) {
        float f = p_360678_.swelling;
        return (int)(f * 10.0f) % 2 == 0 ? 0.0f : Mth.clamp((float)f, (float)0.5f, (float)1.0f);
    }

    public ResourceLocation getTextureLocation(CreeperRenderState p_363813_) {
        return CREEPER_LOCATION;
    }

    public CreeperRenderState createRenderState() {
        return new CreeperRenderState();
    }

    public void extractRenderState(PaleCreeperEntity p_364394_, CreeperRenderState p_361451_, float p_364659_) {
        super.extractRenderState((LivingEntity)p_364394_, (LivingEntityRenderState)p_361451_, p_364659_);
        p_361451_.swelling = p_364394_.getSwelling(p_364659_);
        p_361451_.isPowered = p_364394_.isPowered();
    }
}

