/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.creaking_expanded.entity.renderer;

import com.belgie.creaking_expanded.CreakingExpanded;
import com.belgie.creaking_expanded.entity.PaleEyeEntity;
import com.belgie.creaking_expanded.entity.model.PaleEyeModel;
import com.belgie.creaking_expanded.entity.renderstate.PaleEyeRenderState;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PaleEyeRenderer
extends MobRenderer<PaleEyeEntity, PaleEyeRenderState, PaleEyeModel> {
    private static final Map<PaleEyeEntity.Variant, ResourceLocation> TEXTURES = (Map)Util.make((Object)Maps.newHashMap(), p_359287_ -> {
        p_359287_.put(PaleEyeEntity.Variant.PALE_OAK, ResourceLocation.fromNamespaceAndPath((String)"creaking_expanded", (String)"textures/entity/pale_eye.png"));
        p_359287_.put(PaleEyeEntity.Variant.PALE_MOSS, ResourceLocation.fromNamespaceAndPath((String)"creaking_expanded", (String)"textures/entity/pale_eye_moss.png"));
        p_359287_.put(PaleEyeEntity.Variant.CREAKING_HEART, ResourceLocation.fromNamespaceAndPath((String)"creaking_expanded", (String)"textures/entity/pale_eye_creaking.png"));
    });

    public PaleEyeRenderer(EntityRendererProvider.Context p_174370_) {
        super(p_174370_, (EntityModel)new PaleEyeModel(p_174370_.bakeLayer(CreakingExpanded.EntityBits.PALE_EYE)), 0.0f);
    }

    public Vec3 getRenderOffset(PaleEyeRenderState p_360997_) {
        return p_360997_.renderOffset;
    }

    public boolean shouldRender(PaleEyeEntity livingEntity, Frustum camera, double camX, double camY, double camZ) {
        if (super.shouldRender((Entity)livingEntity, camera, camX, camY, camZ)) {
            return true;
        }
        Vec3 vec3 = livingEntity.getRenderPosition(0.0f);
        if (vec3 == null) {
            return false;
        }
        EntityType entitytype = livingEntity.getType();
        float f = entitytype.getHeight() / 2.0f;
        float f1 = entitytype.getWidth() / 2.0f;
        Vec3 vec31 = Vec3.atBottomCenterOf((Vec3i)livingEntity.blockPosition());
        return camera.isVisible(new AABB(vec3.x, vec3.y + (double)f, vec3.z, vec31.x, vec31.y + (double)f, vec31.z).inflate((double)f1, (double)f, (double)f1));
    }

    public ResourceLocation getTextureLocation(PaleEyeRenderState p_362880_) {
        return TEXTURES.get((Object)p_362880_.Type);
    }

    public PaleEyeRenderState createRenderState() {
        return new PaleEyeRenderState();
    }

    public void extractRenderState(PaleEyeEntity p_365400_, PaleEyeRenderState p_361284_, float p_360863_) {
        super.extractRenderState((LivingEntity)p_365400_, (LivingEntityRenderState)p_361284_, p_360863_);
        p_361284_.renderOffset = Objects.requireNonNullElse(p_365400_.getRenderPosition(p_360863_), Vec3.ZERO);
        p_361284_.peekAmount = p_365400_.getClientPeekAmount(p_360863_);
        p_361284_.yHeadRot = p_365400_.yHeadRot;
        p_361284_.yBodyRot = p_365400_.yBodyRot;
        p_361284_.attachFace = p_365400_.getAttachFace();
        p_361284_.Type = p_365400_.getVariant();
    }

    protected void setupRotations(PaleEyeRenderState p_364147_, PoseStack p_115908_, float p_115909_, float p_115910_) {
        super.setupRotations((LivingEntityRenderState)p_364147_, p_115908_, p_115909_ + 180.0f, p_115910_);
        p_115908_.rotateAround(p_364147_.attachFace.getOpposite().getRotation(), 0.0f, 0.5f, 0.0f);
    }
}

