/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.creaking_expanded.particles;

import java.util.Optional;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.ParticleGroup;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class CreakingEyeParticles
extends TextureSheetParticle {
    protected CreakingEyeParticles(ClientLevel level, SpriteSet sprites, double x, double y, double z) {
        super(level, x, y - 0.125, z);
        this.setSize(0.01f, 0.01f);
        this.pickSprite(sprites);
        this.quadSize *= this.random.nextFloat() * 0.6f + 0.2f;
        this.lifetime = (int)(16.0 / (Math.random() * 0.8 + 0.2));
        this.hasPhysics = false;
        this.friction = 1.0f;
        this.gravity = 0.0f;
    }

    CreakingEyeParticles(ClientLevel level, SpriteSet sprites, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        super(level, x, y - 0.125, z, xSpeed, ySpeed, zSpeed);
        this.setSize(0.01f, 0.01f);
        this.pickSprite(sprites);
        this.quadSize *= this.random.nextFloat() * 0.6f + 0.6f;
        this.lifetime = (int)(16.0 / (Math.random() * 0.8 + 0.2));
        this.hasPhysics = false;
        this.friction = 1.0f;
        this.gravity = 0.0f;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class MothAirProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;
        public static final ParticleGroup MOTH = new ParticleGroup(50);

        public MothAirProvider(SpriteSet sprites) {
            this.sprite = sprites;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel p_level, double p_x, double p_y, double p_z, double xSpeed, double ySpeed, double zSpeed) {
            CreakingEyeParticles suspendedparticle = new CreakingEyeParticles(this, p_level, this.sprite, p_x, p_y, p_z, 0.0, -0.8f, 0.0){

                public Optional<ParticleGroup> getParticleGroup() {
                    return Optional.of(MOTH);
                }
            };
            suspendedparticle.lifetime = Mth.randomBetweenInclusive((RandomSource)p_level.random, (int)500, (int)1000);
            suspendedparticle.gravity = 0.01f;
            return suspendedparticle;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class SporeBlossomAirProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;
        public static final ParticleGroup MOTH = new ParticleGroup(500);

        public SporeBlossomAirProvider(SpriteSet sprites) {
            this.sprite = sprites;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel p_level, double p_x, double p_y, double p_z, double xSpeed, double ySpeed, double zSpeed) {
            CreakingEyeParticles suspendedparticle = new CreakingEyeParticles(this, p_level, this.sprite, p_x, p_y, p_z, 0.0, -0.8f, 0.0){

                public Optional<ParticleGroup> getParticleGroup() {
                    return Optional.of(MOTH);
                }
            };
            suspendedparticle.lifetime = Mth.randomBetweenInclusive((RandomSource)p_level.random, (int)500, (int)1000);
            suspendedparticle.gravity = 0.01f;
            return suspendedparticle;
        }
    }
}

