/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.creaking_expanded.registry;

import com.belgie.creaking_expanded.entity.CreakingGolem;
import com.belgie.creaking_expanded.entity.PaleCreeperEntity;
import com.belgie.creaking_expanded.entity.PaleEyeEntity;
import com.belgie.creaking_expanded.entity.SpriteEntity;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public class EntityRegistry {
    public static final DeferredRegister<EntityType<?>> ENTITY = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"creaking_expanded");
    public static final DeferredRegister<EntityDataSerializer<?>> DATA = DeferredRegister.create((Registry)NeoForgeRegistries.ENTITY_DATA_SERIALIZERS, (String)"creaking_expanded");
    public static final Supplier<EntityDataSerializer<SpriteEntity.State>> SNIFFER_STATE = DATA.register("sprite_state", () -> EntityDataSerializer.forValueType(SpriteEntity.State.STREAM_CODEC));
    public static final Supplier<EntityType<CreakingGolem>> FRIENDLY_CREAKING = ENTITY.register("creaking_guard", () -> EntityType.Builder.of(CreakingGolem::new, (MobCategory)MobCategory.MONSTER).noSummon().fireImmune().sized(0.6f, 2.7f).eyeHeight(2.3f).clientTrackingRange(8).build(ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"creaking_expanded", (String)"creaking_guard"))));
    public static final Supplier<EntityType<PaleEyeEntity>> PALE_EYE = ENTITY.register("pale_eye", () -> EntityType.Builder.of(PaleEyeEntity::new, (MobCategory)MobCategory.MONSTER).fireImmune().canSpawnFarFromPlayer().sized(1.0f, 1.0f).eyeHeight(1.0f).clientTrackingRange(10).build(ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"creaking_expanded", (String)"pale_eye"))));
    public static final Supplier<EntityType<SpriteEntity>> ANCIENT_SPRITE = ENTITY.register("ancient_sprite", () -> EntityType.Builder.of(SpriteEntity::new, (MobCategory)MobCategory.MONSTER).fireImmune().sized(2.0f, 2.8f).eyeHeight(1.8f).clientTrackingRange(8).build(ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"creaking_expanded", (String)"ancient_sprite"))));
    public static final Supplier<EntityType<PaleCreeperEntity>> PALE_CREEPER = ENTITY.register("pale_creeper", () -> EntityType.Builder.of(PaleCreeperEntity::new, (MobCategory)MobCategory.MONSTER).sized(0.6f, 1.7f).eyeHeight(1.4f).clientTrackingRange(10).build(ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"creaking_expanded", (String)"pale_creeper"))));

    @EventBusSubscriber(modid="creaking_expanded", bus=EventBusSubscriber.Bus.MOD)
    public static class EntityPlacements {
        @SubscribeEvent
        public static void Attributes(RegisterSpawnPlacementsEvent e) {
            e.register(PALE_CREEPER.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::checkMonsterSpawnRules, RegisterSpawnPlacementsEvent.Operation.AND);
        }
    }
}

