/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.resourcefish.block;

import com.benbenlaw.resourcefish.block.CaviarProcessorBlock;
import com.benbenlaw.resourcefish.block.NestBlock;
import com.benbenlaw.resourcefish.block.TankControllerBlock;
import com.benbenlaw.resourcefish.item.ResourceFishItems;
import java.util.function.Supplier;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ResourceFishBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.createBlocks((String)"resourcefish");
    public static final DeferredBlock<Block> TANK_CONTROLLER = ResourceFishBlocks.registerBlock("tank_controller", () -> new TankControllerBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BRICKS).sound(SoundType.STONE).noOcclusion()));
    public static final DeferredBlock<Block> CAVIAR_PROCESSOR = ResourceFishBlocks.registerBlock("caviar_processor", () -> new CaviarProcessorBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BRICKS).sound(SoundType.STONE).noOcclusion()));
    public static final DeferredBlock<Block> NEST = ResourceFishBlocks.registerBlock("nest", () -> new NestBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SAND).sound(SoundType.SAND).lightLevel(state -> 7).noOcclusion()));

    private static <T extends Block> DeferredBlock<T> registerBlock(String name, Supplier<T> block) {
        DeferredBlock toReturn = (DeferredBlock)BLOCKS.register(name, block);
        ResourceFishBlocks.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> void registerBlockItem(String name, DeferredBlock<T> block) {
        ResourceFishItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }
}

