/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.resourcefish.data.builders;

import com.benbenlaw.core.recipe.ChanceResult;
import com.benbenlaw.resourcefish.entities.ResourceFishEntity;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.common.conditions.ICondition;

public class ResourceFishBuilder
implements DataProvider {
    private final PackOutput output;
    private final List<FishDefinition> fishes = new ArrayList<FishDefinition>();

    public ResourceFishBuilder(PackOutput output) {
        this.output = output;
    }

    public ResourceFishBuilder addFish(FishDefinition fish) {
        this.fishes.add(fish);
        return this;
    }

    public CompletableFuture<?> run(CachedOutput cache) {
        Path outputFolder = this.output.getOutputFolder(PackOutput.Target.DATA_PACK);
        ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>();
        for (FishDefinition fish : this.fishes) {
            JsonObject json = new JsonObject();
            json.addProperty("main_color", String.format("#%08X", fish.mainColor));
            json.addProperty("pattern_color", String.format("#%08X", fish.patternColor));
            JsonArray dropItems = new JsonArray();
            for (ChanceResult result : fish.dropItems) {
                dropItems.add((JsonElement)ChanceResult.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)result).result().orElseThrow());
            }
            json.add("drop_items", (JsonElement)dropItems);
            json.addProperty("drop_interval", (Number)fish.dropIntervalTicks);
            if (!fish.patterns.isEmpty()) {
                JsonArray patterns = new JsonArray();
                for (ResourceFishEntity.Pattern pattern : fish.patterns) {
                    patterns.add(pattern.name().toLowerCase());
                }
                json.add("patterns", (JsonElement)patterns);
            }
            if (!fish.models.isEmpty()) {
                JsonArray models = new JsonArray();
                for (ResourceFishEntity.Pattern.Base model : fish.models) {
                    models.add(model.name().toLowerCase());
                }
                json.add("models", (JsonElement)models);
            }
            if (!fish.biomes.isEmpty()) {
                JsonArray biomes = new JsonArray();
                for (String biome : fish.biomes) {
                    biomes.add(biome);
                }
                json.add("biomes", (JsonElement)biomes);
            }
            if (!fish.conditions.isEmpty()) {
                ICondition.writeConditions((DynamicOps)JsonOps.INSTANCE, (JsonObject)json, fish.conditions);
            }
            Path path = outputFolder.resolve(fish.id.getNamespace() + "/fish/" + fish.id.getPath() + ".json");
            futures.add(DataProvider.saveStable((CachedOutput)cache, (JsonElement)json, (Path)path));
        }
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
    }

    public String getName() {
        return "Resource Fish Builder";
    }

    public static Builder builder(String id) {
        return new Builder(ResourceLocation.fromNamespaceAndPath((String)"resourcefish", (String)id));
    }

    public static class FishDefinition {
        public final ResourceLocation id;
        public final int mainColor;
        public final int patternColor;
        public final List<ChanceResult> dropItems;
        public final int dropIntervalTicks;
        public final List<ResourceFishEntity.Pattern> patterns;
        public final List<ResourceFishEntity.Pattern.Base> models;
        public final List<String> biomes;
        public final List<ICondition> conditions;

        public FishDefinition(ResourceLocation id, int mainColor, int patternColor, List<ChanceResult> dropItems, int dropIntervalTicks, List<ResourceFishEntity.Pattern> patterns, List<ResourceFishEntity.Pattern.Base> models, List<String> biomes, List<ICondition> conditions) {
            this.id = id;
            this.mainColor = mainColor;
            this.patternColor = patternColor;
            this.dropItems = dropItems;
            this.dropIntervalTicks = dropIntervalTicks;
            this.patterns = patterns;
            this.models = models;
            this.biomes = biomes;
            this.conditions = conditions;
        }
    }

    public static class Builder {
        private final ResourceLocation id;
        private int mainColor = 0xFFFFFF;
        private int patternColor = 0;
        private List<ChanceResult> dropItems = new ArrayList<ChanceResult>();
        private int dropIntervalTicks = 600;
        private List<ResourceFishEntity.Pattern> patterns = new ArrayList<ResourceFishEntity.Pattern>();
        private List<ResourceFishEntity.Pattern.Base> models = new ArrayList<ResourceFishEntity.Pattern.Base>();
        private List<String> biomes = new ArrayList<String>();
        private List<ICondition> conditions = new ArrayList<ICondition>();

        public Builder(ResourceLocation id) {
            this.id = id;
        }

        public Builder mainColor(int color) {
            this.mainColor = color;
            return this;
        }

        public Builder patternColor(int color) {
            this.patternColor = color;
            return this;
        }

        public Builder dropItems(List<ChanceResult> items) {
            this.dropItems = items;
            return this;
        }

        public Builder dropInterval(int ticks) {
            this.dropIntervalTicks = ticks;
            return this;
        }

        public Builder patterns(List<ResourceFishEntity.Pattern> patterns) {
            this.patterns = patterns;
            return this;
        }

        public Builder models(List<ResourceFishEntity.Pattern.Base> models) {
            this.models = models;
            return this;
        }

        public Builder biomes(List<String> biomes) {
            this.biomes = biomes;
            return this;
        }

        public Builder conditions(List<ICondition> conditions) {
            this.conditions = conditions;
            return this;
        }

        public FishDefinition build() {
            return new FishDefinition(this.id, this.mainColor, this.patternColor, this.dropItems, this.dropIntervalTicks, this.patterns, this.models, this.biomes, this.conditions);
        }
    }
}

