/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.resourcefish.integration.fish;

import com.benbenlaw.resourcefish.entities.ResourceFishEntity;
import com.benbenlaw.resourcefish.integration.fish.FishIngredient;
import com.benbenlaw.resourcefish.util.ResourceType;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.ingredients.IIngredientRenderer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.joml.Quaternionf;

public class FishIngredientRenderer
implements IIngredientRenderer<FishIngredient> {
    public void render(GuiGraphics guiGraphics, FishIngredient ingredient) {
        ResourceFishEntity fish;
        Minecraft mc = Minecraft.getInstance();
        if (mc.level != null && (fish = ingredient.getCachedEntity((Level)mc.level)) != null) {
            if (fish.getVariant().model() == ResourceFishEntity.Pattern.Base.LARGE) {
                this.renderFish(guiGraphics, 6, 12, 28, fish);
            }
            if (fish.getVariant().model() == ResourceFishEntity.Pattern.Base.SMALL) {
                this.renderFish(guiGraphics, 6, 8, 28, fish);
            }
        }
    }

    private void renderFish(GuiGraphics guiGraphics, int x, int y, int size, ResourceFishEntity fish) {
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        poseStack.translate((float)x, (float)y, 50.0f);
        poseStack.mulPose(Axis.ZP.rotationDegrees(-87.0f));
        poseStack.mulPose(Axis.YP.rotationDegrees(-20.0f));
        poseStack.mulPose(Axis.XP.rotationDegrees(-50.0f));
        float scale = size;
        poseStack.scale(scale, scale, scale);
        EntityRenderDispatcher dispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
        dispatcher.overrideCameraOrientation(new Quaternionf(0.0f, 0.0f, 0.0f, 1.0f));
        dispatcher.setRenderShadow(false);
        MultiBufferSource.BufferSource buffer = Minecraft.getInstance().renderBuffers().bufferSource();
        ResourceType resourceType = fish.getResourceType();
        fish.setResourceType(resourceType);
        if (fish.getVariant() == null) {
            fish.setVariant(ResourceFishEntity.generateVariant(resourceType, Minecraft.getInstance().level.getRandom()));
        }
        RenderSystem.runAsFancy(() -> dispatcher.render((Entity)fish, 0.0, 0.0, 0.0, 0.0f, 1.0f, poseStack, (MultiBufferSource)buffer, 0xF000F0));
        buffer.endBatch();
        dispatcher.setRenderShadow(true);
        poseStack.popPose();
    }

    public List<Component> getTooltip(FishIngredient ingredient, TooltipFlag flag) {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        String name = ingredient.getFishType().getPath();
        String formattedName = Arrays.stream(name.split("_")).map(s -> Character.toUpperCase(s.charAt(0)) + s.substring(1)).collect(Collectors.joining(" "));
        MutableComponent resourceFish = Component.translatable((String)"jei.resourcefish.resource_fish");
        tooltip.add((Component)Component.literal((String)(formattedName + " ")).append((Component)resourceFish));
        ResourceType resourceType = ResourceType.get(ingredient.getFishType());
        if (resourceType != null && resourceType.getBiomes() != null && !resourceType.getBiomes().isEmpty()) {
            List<String> biomes = resourceType.getBiomes();
            ArrayList<MutableComponent> biomeComponents = new ArrayList<MutableComponent>();
            tooltip.add((Component)Component.translatable((String)"jei.resourcefish.spawn_biome").withStyle(ChatFormatting.GOLD));
            for (String biome : biomes) {
                if (biome.startsWith("#")) {
                    String tagBiome = biome.substring(1).replace(":", ".");
                    MutableComponent translated = Component.translatable((String)("tag.worldgen.biome." + tagBiome));
                    biomeComponents.add(Component.literal((String)"- ").append((Component)translated).withStyle(ChatFormatting.GOLD));
                    continue;
                }
                String biomeKey = biome.substring(biome.indexOf(":") + 1);
                String capitalizedBiome = Arrays.stream(biomeKey.split("_")).map(s -> Character.toUpperCase(s.charAt(0)) + s.substring(1)).collect(Collectors.joining(" "));
                biomeComponents.add(Component.literal((String)("- " + capitalizedBiome)).withStyle(ChatFormatting.GOLD));
            }
            tooltip.addAll(biomeComponents);
        }
        return tooltip;
    }
}

