/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.resourcefish.item;

import com.benbenlaw.resourcefish.block.ResourceFishBlocks;
import com.benbenlaw.resourcefish.item.ResourceFishDataComponents;
import com.benbenlaw.resourcefish.item.ResourceFishItems;
import com.benbenlaw.resourcefish.util.ResourceType;
import java.util.function.Supplier;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ResourceFishCreativeTab {
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"resourcefish");
    public static final Supplier<CreativeModeTab> RESOURCE_FISH_TAB = CREATIVE_MODE_TABS.register("resource_fish", () -> CreativeModeTab.builder().withTabsBefore(new ResourceKey[]{CreativeModeTabs.COMBAT}).icon(() -> ((Item)ResourceFishItems.RESOURCE_FISH_BUCKET.get()).asItem().getDefaultInstance()).title((Component)Component.translatable((String)"itemGroup.resourcefish")).displayItems((parameters, output) -> {
        ItemStack stack;
        output.accept(((Block)ResourceFishBlocks.NEST.get()).asItem().getDefaultInstance());
        output.accept(((Block)ResourceFishBlocks.TANK_CONTROLLER.get()).asItem().getDefaultInstance());
        output.accept(((Block)ResourceFishBlocks.CAVIAR_PROCESSOR.get()).asItem().getDefaultInstance());
        output.accept(((Item)ResourceFishItems.DEPTH_UPGRADE_1.get()).asItem().getDefaultInstance());
        output.accept(((Item)ResourceFishItems.DEPTH_UPGRADE_2.get()).asItem().getDefaultInstance());
        output.accept(((Item)ResourceFishItems.DEPTH_UPGRADE_3.get()).asItem().getDefaultInstance());
        output.accept(((Item)ResourceFishItems.WIDTH_UPGRADE_1.get()).asItem().getDefaultInstance());
        output.accept(((Item)ResourceFishItems.WIDTH_UPGRADE_2.get()).asItem().getDefaultInstance());
        output.accept(((Item)ResourceFishItems.WIDTH_UPGRADE_3.get()).asItem().getDefaultInstance());
        output.accept(((Item)ResourceFishItems.SPEED_UPGRADE_1.get()).asItem().getDefaultInstance());
        output.accept(((Item)ResourceFishItems.SPEED_UPGRADE_2.get()).asItem().getDefaultInstance());
        output.accept(((Item)ResourceFishItems.SPEED_UPGRADE_3.get()).asItem().getDefaultInstance());
        output.accept(((Item)ResourceFishItems.TANK_UPGRADE.get()).asItem().getDefaultInstance());
        output.accept(((Item)ResourceFishItems.INFUSING_UPGRADE.get()).asItem().getDefaultInstance());
        output.accept(((Item)ResourceFishItems.BREEDING_UPGRADE.get()).asItem().getDefaultInstance());
        output.accept(((Item)ResourceFishItems.ROUND_ROBIN_UPGRADE.get()).asItem().getDefaultInstance());
        output.accept(((Item)ResourceFishItems.BASIC_FISH_FOOD.get()).asItem().getDefaultInstance());
        output.accept(((Item)ResourceFishItems.METALLIC_FISH_FOOD.get()).asItem().getDefaultInstance());
        output.accept(((Item)ResourceFishItems.CRYSTAL_FISH_FOOD.get()).asItem().getDefaultInstance());
        output.accept(((Item)ResourceFishItems.NETHER_FISH_FOOD.get()).asItem().getDefaultInstance());
        output.accept(((Item)ResourceFishItems.BASIC_MOB_FISH_FOOD.get()).asItem().getDefaultInstance());
        for (ResourceType type : ResourceType.getAll()) {
            stack = new ItemStack((ItemLike)ResourceFishItems.RESOURCE_FISH_BUCKET.get());
            stack.set(ResourceFishDataComponents.FISH_TYPE, (Object)type.getId());
            CompoundTag tag = new CompoundTag();
            tag.putString("id", type.getId().toString());
            tag.putString("BucketResourceType", type.getId().toString());
            tag.putInt("BucketPattern", 0);
            tag.putInt("BucketModel", 0);
            tag.putBoolean("allowedToDrop", true);
            stack.set(DataComponents.BUCKET_ENTITY_DATA, (Object)CustomData.of((CompoundTag)tag));
            output.accept(stack);
        }
        for (ResourceType type : ResourceType.getAll()) {
            stack = new ItemStack((ItemLike)ResourceFishItems.RESOURCE_FISH_SPAWN_EGG.get());
            stack.set(ResourceFishDataComponents.FISH_TYPE, (Object)type.getId());
            output.accept(stack);
        }
        for (ResourceType type : ResourceType.getAll()) {
            stack = new ItemStack((ItemLike)ResourceFishItems.CAVIAR.get());
            stack.set(ResourceFishDataComponents.FISH_TYPE, (Object)type.getId());
            output.accept(stack);
        }
    }).build());
}

