/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.resourcefish.recipe;

import com.benbenlaw.resourcefish.block.entity.CaviarProcessorBlockEntity;
import com.benbenlaw.resourcefish.item.ResourceFishItems;
import com.benbenlaw.resourcefish.recipe.CaviarProcessorRecipeInput;
import com.benbenlaw.resourcefish.util.SizedIngredientChanceResult;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public record CaviarProcessorRecipe(ItemStack caviar, NonNullList<SizedIngredientChanceResult> results, FluidStack fluidStack) implements Recipe<RecipeInput>
{
    public boolean matches(RecipeInput container, Level level) {
        int[] inputs = CaviarProcessorBlockEntity.INPUT_SLOTS;
        int[] upgradeSlots = CaviarProcessorBlockEntity.UPGRADE_SLOTS;
        for (int input : inputs) {
            ItemStack stack = container.getItem(input);
            if (stack.isEmpty() || this.caviar.isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)this.caviar, (ItemStack)stack)) continue;
            if (this.fluidStack.isEmpty()) {
                return true;
            }
            if (!(container instanceof CaviarProcessorRecipeInput)) continue;
            CaviarProcessorRecipeInput caviarProcessorRecipeInput = (CaviarProcessorRecipeInput)container;
            for (int upgradeSlot : upgradeSlots) {
                int canFill;
                IFluidHandler tank;
                FluidStack current;
                ItemStack upgradeStack = caviarProcessorRecipeInput.getItemHandler().getStackInSlot(upgradeSlot);
                if (upgradeStack.isEmpty() || !upgradeStack.is((Item)ResourceFishItems.TANK_UPGRADE.get()) || !(current = (tank = caviarProcessorRecipeInput.getFluidHandler()).getFluidInTank(0)).isEmpty() && !current.is(this.fluidStack.getFluid()) || (canFill = tank.fill(this.fluidStack.copy(), IFluidHandler.FluidAction.SIMULATE)) < this.fluidStack.getAmount()) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    public ItemStack getResultItem(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        if (!this.results.isEmpty()) {
            return ((SizedIngredientChanceResult)this.results.getFirst()).output().getItems()[0];
        }
        return ItemStack.EMPTY;
    }

    public List<SizedIngredient> getResults() {
        return this.getRollResults().stream().map(SizedIngredientChanceResult::output).collect(Collectors.toList()).reversed();
    }

    public NonNullList<SizedIngredientChanceResult> getRollResults() {
        return this.results;
    }

    public List<ItemStack> rollResults(RandomSource rand) {
        ArrayList<ItemStack> results = new ArrayList<ItemStack>();
        NonNullList<SizedIngredientChanceResult> rollResults = this.getRollResults();
        for (SizedIngredientChanceResult output : rollResults) {
            ItemStack stack = output.rollOutput(rand);
            if (stack.isEmpty()) continue;
            results.add(stack);
        }
        return results;
    }

    public ItemStack assemble(RecipeInput container, HolderLookup.Provider provider) {
        if (this.results.isEmpty()) {
            return ItemStack.EMPTY;
        }
        return ((SizedIngredientChanceResult)this.results.getFirst()).output().getItems()[0];
    }

    public boolean canCraftInDimensions(int p_43999_, int p_44000_) {
        return false;
    }

    public RecipeSerializer<?> getSerializer() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> getType() {
        return Type.INSTANCE;
    }

    public static class Serializer
    implements RecipeSerializer<CaviarProcessorRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public final MapCodec<CaviarProcessorRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ItemStack.CODEC.fieldOf("caviar").forGetter(CaviarProcessorRecipe::caviar), (App)Codec.list(SizedIngredientChanceResult.CODEC).fieldOf("results").flatXmap(chanceResults -> {
            NonNullList nonNullList = NonNullList.create();
            nonNullList.addAll((Collection)chanceResults);
            return DataResult.success((Object)nonNullList);
        }, DataResult::success).forGetter(CaviarProcessorRecipe::getRollResults), (App)FluidStack.OPTIONAL_CODEC.fieldOf("output_fluid").forGetter(CaviarProcessorRecipe::fluidStack)).apply((Applicative)instance, CaviarProcessorRecipe::new));
        private final StreamCodec<RegistryFriendlyByteBuf, CaviarProcessorRecipe> STREAM_CODEC = StreamCodec.of(Serializer::write, Serializer::read);

        public MapCodec<CaviarProcessorRecipe> codec() {
            return this.CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, CaviarProcessorRecipe> streamCodec() {
            return this.STREAM_CODEC;
        }

        private static CaviarProcessorRecipe read(RegistryFriendlyByteBuf buffer) {
            ItemStack caviar = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            int size = buffer.readVarInt();
            NonNullList outputs = NonNullList.create();
            for (int i = 0; i < size; ++i) {
                outputs.add((Object)SizedIngredientChanceResult.read(buffer));
            }
            FluidStack fluidStack = (FluidStack)FluidStack.OPTIONAL_STREAM_CODEC.decode((Object)buffer);
            return new CaviarProcessorRecipe(caviar, (NonNullList<SizedIngredientChanceResult>)outputs, fluidStack);
        }

        private static CaviarProcessorRecipe write(RegistryFriendlyByteBuf buffer, CaviarProcessorRecipe recipe) {
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.caviar);
            buffer.writeVarInt(recipe.results.size());
            for (SizedIngredientChanceResult output : recipe.results) {
                output.write(buffer);
            }
            FluidStack.OPTIONAL_STREAM_CODEC.encode((Object)buffer, (Object)recipe.fluidStack);
            return recipe;
        }
    }

    public static class Type
    implements RecipeType<CaviarProcessorRecipe> {
        public static final Type INSTANCE = new Type();

        private Type() {
        }
    }
}

