/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.core.block.colored;

import com.benbenlaw.core.block.colored.ColoredBlock;
import com.benbenlaw.core.block.colored.ColoredTallGrassBlock;
import com.benbenlaw.core.block.colored.util.BlockTypeColorFinder;
import com.benbenlaw.core.block.colored.util.ColorMap;
import com.benbenlaw.core.block.colored.util.IColored;
import com.benbenlaw.core.item.CoreDataComponents;
import com.benbenlaw.core.item.colored.ColoredBlockItem;
import com.benbenlaw.core.item.colored.ColoredItem;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.GrassBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.lighting.LightEngine;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColoredGrassBlock
extends GrassBlock
implements IColored,
BonemealableBlock {
    public static Map<DyeColor, ResourceKey<ConfiguredFeature<?, ?>>> VEGETATION_PLACEMENT_MAP = new HashMap();
    public static final EnumProperty<DyeColor> COLOR = EnumProperty.create((String)"color", DyeColor.class);
    public static final BooleanProperty LIT = BlockStateProperties.LIT;
    public static ColoredBlock DIRT;
    public static ColoredTallGrassBlock SHORT_GRASS_BLOCK;
    public static ResourceKey<ConfiguredFeature<?, ?>> VEGETATION_PLACEMENT;

    public ColoredGrassBlock(BlockBehaviour.Properties properties, ColoredBlock dirt, ColoredTallGrassBlock shortGrassBlock, ResourceKey<ConfiguredFeature<?, ?>> vegetationPlacement) {
        super(properties);
        DIRT = dirt;
        SHORT_GRASS_BLOCK = shortGrassBlock;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(COLOR, (Comparable)DyeColor.WHITE)).setValue((Property)LIT, (Comparable)Boolean.FALSE)).setValue((Property)SNOWY, (Comparable)Boolean.FALSE));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{COLOR, LIT, SNOWY});
    }

    @Override
    public int getColor(int index) {
        DyeColor color = DyeColor.values()[index % DyeColor.values().length];
        return ColorMap.getColorValue(color);
    }

    @Override
    public int getColor(int index, ItemStack stack) {
        return this.getColor(index);
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        DyeColor color;
        Function<BlockState, DyeColor> colorFunction = BlockTypeColorFinder.BLOCK_TYPE_COLOR_FINDER.get(state.getBlock().getClass());
        DyeColor dyeColor = color = colorFunction != null ? colorFunction.apply(state) : DyeColor.WHITE;
        if (!ColoredGrassBlock.canBeGrass(state, (LevelReader)level, pos)) {
            if (!level.isAreaLoaded(pos, 1)) {
                return;
            }
            level.setBlockAndUpdate(pos, (BlockState)DIRT.defaultBlockState().setValue(ColoredBlock.COLOR, (Comparable)color));
        } else {
            if (!level.isAreaLoaded(pos, 3)) {
                return;
            }
            if (level.getMaxLocalRawBrightness(pos.above()) >= 9) {
                BlockState blockstate = (BlockState)this.defaultBlockState().setValue(COLOR, (Comparable)color);
                for (int i = 0; i < 4; ++i) {
                    BlockPos blockpos = pos.offset(random.nextInt(3) - 1, random.nextInt(5) - 3, random.nextInt(3) - 1);
                    if (!level.getBlockState(blockpos).is((Block)DIRT) || !ColoredGrassBlock.canPropagate(blockstate, (LevelReader)level, blockpos)) continue;
                    level.setBlockAndUpdate(blockpos, (BlockState)blockstate.setValue((Property)SNOWY, (Comparable)Boolean.valueOf(level.getBlockState(blockpos.above()).is(Blocks.SNOW))));
                }
            }
        }
    }

    private static boolean canBeGrass(BlockState state, LevelReader levelReader, BlockPos pos) {
        BlockPos blockpos = pos.above();
        BlockState blockstate = levelReader.getBlockState(blockpos);
        if (blockstate.is(Blocks.SNOW) && (Integer)blockstate.getValue((Property)SnowLayerBlock.LAYERS) == 1) {
            return true;
        }
        if (blockstate.getFluidState().getAmount() == 8) {
            return false;
        }
        int i = LightEngine.getLightBlockInto((BlockGetter)levelReader, (BlockState)state, (BlockPos)pos, (BlockState)blockstate, (BlockPos)blockpos, (Direction)Direction.UP, (int)blockstate.getLightBlock((BlockGetter)levelReader, blockpos));
        return i < levelReader.getMaxLightLevel();
    }

    private static boolean canPropagate(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos blockpos = pos.above();
        return ColoredGrassBlock.canBeGrass(state, level, pos) && !level.getFluidState(blockpos).is(FluidTags.WATER);
    }

    public boolean isValidBonemealTarget(LevelReader p_256229_, BlockPos p_256432_, BlockState p_255677_) {
        return p_256229_.getBlockState(p_256432_.above()).isAir();
    }

    public boolean isBonemealSuccess(Level p_221275_, RandomSource p_221276_, BlockPos p_221277_, BlockState p_221278_) {
        return true;
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos blockPos, BlockState state) {
        DyeColor color = (DyeColor)state.getValue(COLOR);
        level.registryAccess().registry(Registries.CONFIGURED_FEATURE).flatMap(registry -> registry.getHolder(VEGETATION_PLACEMENT_MAP.get(color))).ifPresent(feature -> {
            BlockPos targetPos = blockPos;
            if (level.getBlockState(targetPos).is(state.getBlock()) && level.getBlockState(targetPos.above()).isAir()) {
                ((ConfiguredFeature)feature.value()).place((WorldGenLevel)level, level.getChunkSource().getGenerator(), random, targetPos.above());
            }
            for (int i = 0; i < 128; ++i) {
                BlockPos spreadPos = blockPos.offset(random.nextInt(5) - 2, random.nextInt(3) - 1, random.nextInt(5) - 2);
                BlockState spreadState = level.getBlockState(spreadPos);
                if (spreadState.is(state.getBlock()) && ((DyeColor)spreadState.getValue(COLOR)).equals((Object)state.getValue(COLOR))) {
                    if (!(random.nextFloat() < 0.4f)) continue;
                    if (random.nextBoolean()) {
                        BlockPos abovePos = spreadPos.above();
                        if (!level.getBlockState(abovePos).isAir()) continue;
                        ((ConfiguredFeature)feature.value()).place((WorldGenLevel)level, level.getChunkSource().getGenerator(), random, abovePos);
                        continue;
                    }
                    BlockPos belowPos = spreadPos.below();
                    if (!level.getBlockState(belowPos).isAir()) continue;
                    ((ConfiguredFeature)feature.value()).place((WorldGenLevel)level, level.getChunkSource().getGenerator(), random, belowPos);
                    continue;
                }
                if (!level.getBlockState(spreadPos).isAir()) continue;
                ((ConfiguredFeature)feature.value()).place((WorldGenLevel)level, level.getChunkSource().getGenerator(), random, spreadPos);
            }
        });
    }

    public static void updateVegetationPlacementMap(DyeColor color, ResourceKey<ConfiguredFeature<?, ?>> vegetationPlacement) {
        VEGETATION_PLACEMENT_MAP.put(color, vegetationPlacement);
    }

    public BonemealableBlock.Type getType() {
        return BonemealableBlock.Type.NEIGHBOR_SPREADER;
    }

    @NotNull
    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        List drops = super.getDrops(state, builder);
        DyeColor color = (DyeColor)state.getValue(COLOR);
        for (ItemStack drop : drops) {
            if (drop.getItem() instanceof BlockItem && ((BlockItem)drop.getItem()).getBlock() == this) {
                drop.set(CoreDataComponents.COLOR, (Object)color.toString());
                drop.set(CoreDataComponents.LIT, (Object)((Boolean)state.getValue((Property)LIT)));
            }
            if (!(drop.getItem() instanceof ColoredBlockItem) && !(drop.getItem() instanceof ColoredItem)) continue;
            drop.set(CoreDataComponents.COLOR, (Object)color.toString());
            drop.set(CoreDataComponents.LIT, (Object)((Boolean)state.getValue((Property)LIT)));
        }
        return drops;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        if (state.getBlock() instanceof ColoredGrassBlock) {
            DyeColor color = (DyeColor)state.getValue(COLOR);
            ItemStack stack = new ItemStack((ItemLike)this);
            stack.set(CoreDataComponents.COLOR, (Object)color.toString());
            stack.set(CoreDataComponents.LIT, (Object)((Boolean)state.getValue((Property)LIT)));
            return stack;
        }
        return super.getCloneItemStack(state, target, level, pos, player);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(level, pos, state, placer, stack);
        if (stack.get(CoreDataComponents.COLOR) != null && stack.get(CoreDataComponents.LIT) != null) {
            String colorString = (String)stack.get(CoreDataComponents.COLOR);
            assert (colorString != null);
            DyeColor dyeColor = ColorMap.getDyeColor(colorString);
            Boolean lit = (Boolean)stack.get(CoreDataComponents.LIT);
            assert (lit != null);
            BlockState newState = (BlockState)((BlockState)state.setValue(COLOR, (Comparable)dyeColor)).setValue((Property)LIT, (Comparable)lit);
            level.setBlockAndUpdate(pos, newState);
        } else {
            level.setBlockAndUpdate(pos, state);
        }
    }
}

