/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.core.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;

public class RecipeIDCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"recipeID").executes(RecipeIDCommand::execute)).then(Commands.argument((String)"modid", (ArgumentType)StringArgumentType.string()).executes(RecipeIDCommand::executeWithMod)));
    }

    private static int execute(CommandContext<CommandSourceStack> context) {
        return RecipeIDCommand.process(context, null);
    }

    private static int executeWithMod(CommandContext<CommandSourceStack> context) {
        String modid = StringArgumentType.getString(context, (String)"modid");
        return RecipeIDCommand.process(context, modid);
    }

    private static int process(CommandContext<CommandSourceStack> context, String modFilter) {
        Entity entity = ((CommandSourceStack)context.getSource()).getEntity();
        if (!(entity instanceof ServerPlayer)) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"Only players can use this command."));
            return 0;
        }
        ServerPlayer player = (ServerPlayer)entity;
        ItemStack heldItem = player.getMainHandItem();
        if (heldItem.isEmpty()) {
            player.sendSystemMessage((Component)Component.literal((String)"You're not holding any item."));
            return 0;
        }
        RecipeManager recipeManager = player.level().getRecipeManager();
        Collection recipes = recipeManager.getRecipes();
        int found = 0;
        for (RecipeHolder recipe : recipes) {
            ResourceLocation id = recipe.id();
            if (modFilter != null && !id.getNamespace().equals(modFilter) || !ItemStack.isSameItem((ItemStack)recipe.value().getResultItem((HolderLookup.Provider)player.level().registryAccess()), (ItemStack)heldItem)) continue;
            ResourceLocation typeId = BuiltInRegistries.RECIPE_TYPE.getKey((Object)recipe.value().getType());
            String hoverText = "Click to copy ID: " + String.valueOf(id) + "\nRecipe Type: " + String.valueOf(typeId != null ? typeId : "unknown");
            MutableComponent clickableId = Component.literal((String)id.toString()).withStyle(style -> style.withColor(ChatFormatting.GREEN).withUnderlined(Boolean.valueOf(true)).withClickEvent(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, id.toString())).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)hoverText))));
            player.sendSystemMessage((Component)Component.literal((String)"Recipe ID: ").append((Component)clickableId));
            ++found;
        }
        if (found == 0) {
            String message = "No recipe found that outputs this item" + (String)(modFilter != null ? " in mod '" + modFilter + "'." : ".");
            player.sendSystemMessage((Component)Component.literal((String)message));
        }
        return 1;
    }
}

