/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.core.item.colored;

import com.benbenlaw.core.block.colored.util.ColorMap;
import com.benbenlaw.core.item.CoreDataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ColoredItem
extends Item {
    public ColoredItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public Component getName(ItemStack stack) {
        if (stack.get(CoreDataComponents.COLOR) != null) {
            String colorString = (String)stack.get(CoreDataComponents.COLOR);
            assert (colorString != null);
            DyeColor color = ColorMap.getDyeColor(colorString);
            MutableComponent colorComponent = Component.translatable((String)ColorMap.getTranslationKey(colorString));
            MutableComponent litComponent = Component.translatable((String)"color.bblcore.lit");
            StringBuilder nameBuilder = new StringBuilder(super.getName(stack).getString()).append(" - ").append(colorComponent.getString());
            if (Boolean.TRUE.equals(stack.get(CoreDataComponents.LIT))) {
                nameBuilder.append(" - ").append(litComponent.getString());
            }
            TextColor textColor = color != DyeColor.BLACK ? TextColor.fromRgb((int)ColorMap.getColorValue(color)) : TextColor.fromRgb((int)0x3C3C3C);
            return Component.literal((String)nameBuilder.toString()).withStyle(style -> style.withColor(textColor));
        }
        return Component.literal((String)super.getName(stack).getString());
    }
}

