/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.core.util;

import com.benbenlaw.core.tag.ModdedTagBuilder;
import com.benbenlaw.core.util.ColorList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;

public class CoreTags {

    public static class Fluids {
        public static TagKey<Fluid> tag(String modName, String name) {
            return FluidTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)modName, (String)name));
        }

        public static TagKey<Fluid> commonTag(String name) {
            return FluidTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)name));
        }
    }

    public static class Items {
        public static final TagKey<Item> NETHER_PORTAL_FRAME = Items.tag("bblcore", "nether_portal_frame");
        public static final TagKey<Item> BANNED_FROM_COLORING = Items.tag("bblcore", "banned_from_coloring");
        public static final Map<String, TagKey<Item>> COLOR_TAGS = new HashMap<String, TagKey<Item>>();

        public static TagKey<Item> tag(String modName, String name) {
            return ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)modName, (String)name));
        }

        public static TagKey<Item> commonTag(String name) {
            return ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)name));
        }

        static {
            for (String color : ColorList.COLORS) {
                COLOR_TAGS.put(color, ModdedTagBuilder.createItemTag("bblcore", "tintable/" + color));
            }
        }
    }

    public static class Blocks {
        public static final TagKey<Block> NETHER_PORTAL_FRAME = Blocks.tag("bblcore", "nether_portal_frame");
        public static final TagKey<Block> CLIMBABLE_BLOCKS = Blocks.tag("bblcore", "climbable_blocks");
        public static final TagKey<Block> BANNED_FROM_COLORING = Blocks.tag("bblcore", "banned_from_coloring");
        public static final Map<String, TagKey<Block>> COLOR_TAGS = new HashMap<String, TagKey<Block>>();

        public static TagKey<Block> tag(String modName, String name) {
            return BlockTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)modName, (String)name));
        }

        public static TagKey<Block> commonTag(String name) {
            return BlockTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)name));
        }

        static {
            for (String color : ColorList.COLORS) {
                COLOR_TAGS.put(color, ModdedTagBuilder.createBlockTag("bblcore", "tintable/" + color));
            }
        }
    }
}

