/*
 * Decompiled with CFR 0.152.
 */
package net.arsenal.datagen;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;

public abstract class WeaponAttributeGenerator
implements DataProvider {
    private final CompletableFuture<HolderLookup.Provider> registryLookup;
    protected final FabricDataOutput dataOutput;
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();

    public WeaponAttributeGenerator(FabricDataOutput dataOutput, CompletableFuture<HolderLookup.Provider> registryLookup) {
        this.dataOutput = dataOutput;
        this.registryLookup = registryLookup;
    }

    public abstract void generateWeaponAttributes(Builder var1);

    private static WeaponAttributesFile createFileContent(String preset) {
        return new WeaponAttributesFile("bettercombat:" + preset);
    }

    public CompletableFuture<?> run(CachedOutput writer) {
        Builder builder = new Builder();
        this.generateWeaponAttributes(builder);
        List<Entry> entries = builder.entries;
        ArrayList<CompletableFuture> writes = new ArrayList<CompletableFuture>();
        for (Entry entry : entries) {
            WeaponAttributesFile content = WeaponAttributeGenerator.createFileContent(entry.preset);
            JsonElement json = gson.toJsonTree((Object)content);
            Path path = this.getFilePath(entry.id());
            writes.add(DataProvider.saveStable((CachedOutput)writer, (JsonElement)json, (Path)path));
        }
        return CompletableFuture.allOf(writes.toArray(new CompletableFuture[0]));
    }

    public String getName() {
        return "Weapon Attributes File Generator";
    }

    private Path getFilePath(ResourceLocation id) {
        return this.dataOutput.createPathProvider(PackOutput.Target.DATA_PACK, "weapon_attributes").json(id);
    }

    private record WeaponAttributesFile(String parent) {
    }

    public static class Builder {
        public final List<Entry> entries = new ArrayList<Entry>();
    }

    public record Entry(ResourceLocation id, String preset) {
    }
}

