/*
 * Decompiled with CFR 0.152.
 */
package net.arsenal.spell;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.arsenal.spell.ArsenalEffects;
import net.arsenal.spell.ArsenalProjectiles;
import net.arsenal.spell.ArsenalSounds;
import net.fabric_extras.ranged_weapon.api.EntityAttributes_RangedWeapon;
import net.minecraft.ChatFormatting;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.spell_engine.api.config.AttributeModifier;
import net.spell_engine.api.datagen.SpellBuilder;
import net.spell_engine.api.effect.Effects;
import net.spell_engine.api.spell.ExternalSpellSchools;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.fx.ParticleBatch;
import net.spell_engine.api.spell.fx.Sound;
import net.spell_engine.client.gui.SpellTooltip;
import net.spell_engine.client.util.Color;
import net.spell_engine.fx.SpellEngineParticles;
import net.spell_engine.fx.SpellEngineSounds;
import net.spell_power.api.SpellSchools;
import org.jetbrains.annotations.Nullable;

public class ArsenalSpells {
    public static final List<Entry> all = new ArrayList<Entry>();
    private static final ResourceLocation HOLY_DECELERATE = SpellEngineParticles.MagicParticles.get((SpellEngineParticles.MagicParticles.Shape)SpellEngineParticles.MagicParticles.Shape.HOLY, (SpellEngineParticles.MagicParticles.Motion)SpellEngineParticles.MagicParticles.Motion.DECELERATE).id();
    private static final ResourceLocation SPARK_DECELERATE = SpellEngineParticles.MagicParticles.get((SpellEngineParticles.MagicParticles.Shape)SpellEngineParticles.MagicParticles.Shape.SPARK, (SpellEngineParticles.MagicParticles.Motion)SpellEngineParticles.MagicParticles.Motion.DECELERATE).id();
    private static final ResourceLocation SPARK_FLOAT = SpellEngineParticles.MagicParticles.get((SpellEngineParticles.MagicParticles.Shape)SpellEngineParticles.MagicParticles.Shape.SPARK, (SpellEngineParticles.MagicParticles.Motion)SpellEngineParticles.MagicParticles.Motion.FLOAT).id();
    private static final ResourceLocation STRIPE_FLOAT = SpellEngineParticles.MagicParticles.get((SpellEngineParticles.MagicParticles.Shape)SpellEngineParticles.MagicParticles.Shape.STRIPE, (SpellEngineParticles.MagicParticles.Motion)SpellEngineParticles.MagicParticles.Motion.FLOAT).id();
    private static final ResourceLocation SPELL_ASCEND = SpellEngineParticles.MagicParticles.get((SpellEngineParticles.MagicParticles.Shape)SpellEngineParticles.MagicParticles.Shape.SPELL, (SpellEngineParticles.MagicParticles.Motion)SpellEngineParticles.MagicParticles.Motion.ASCEND).id();
    private static long HOLY_COLOR = Color.HOLY.toRGBA();
    public static Entry radiance_melee = ArsenalSpells.add(ArsenalSpells.radiance_melee());
    public static Entry radiance_ranged = ArsenalSpells.add(ArsenalSpells.radiance_ranged());
    public static Entry radiance_spell = ArsenalSpells.add(ArsenalSpells.radiance_spell());
    public static Entry stunning_melee = ArsenalSpells.add(ArsenalSpells.stunning_melee());
    public static Entry exploding_melee = ArsenalSpells.add(ArsenalSpells.exploding_melee());
    public static final Color WITHER_COLOR = Color.from((int)0x333333);
    public static Entry wither_melee = ArsenalSpells.add(ArsenalSpells.wither_melee());
    public static Entry wither_ranged = ArsenalSpells.add(ArsenalSpells.wither_ranged());
    public static Entry flame_cloud_melee = ArsenalSpells.add(ArsenalSpells.flame_cloud_melee());
    public static Entry flame_cloud_ranged = ArsenalSpells.add(ArsenalSpells.flame_cloud_ranged());
    public static Entry flame_cloud_spell = ArsenalSpells.add(ArsenalSpells.flame_cloud_spell());
    public static Entry poison_cloud_melee = ArsenalSpells.add(ArsenalSpells.poison_cloud_melee());
    public static Entry poison_cloud_ranged = ArsenalSpells.add(ArsenalSpells.poison_cloud_ranged());
    public static Entry slowing_melee = ArsenalSpells.add(ArsenalSpells.slowing_melee());
    public static Color LEECHING_COLOR = Color.from((int)0xFF3333);
    public static Entry leeching_melee = ArsenalSpells.add(ArsenalSpells.leeching_melee());
    public static Entry leeching_spell = ArsenalSpells.add(ArsenalSpells.leeching_spell());
    public static Entry swirling_melee = ArsenalSpells.add(ArsenalSpells.swirling_melee());
    public static final Color GUARDING_COLOR = Color.from((int)0x66CCFF);
    public static Entry guarding_strike_melee = ArsenalSpells.add(ArsenalSpells.guarding_strike_melee());
    public static Color SUNDERING_COLOR = Color.from((int)0x595959);
    public static Entry sundering_melee = ArsenalSpells.add(ArsenalSpells.sundering_melee());
    public static Color UNYIELDING_COLOR = Color.from((int)16730707);
    public static Entry unyielding_shield = ArsenalSpells.add(ArsenalSpells.unyielding_shield());
    public static Entry guarding_shield = ArsenalSpells.add(ArsenalSpells.guarding_shield());
    public static final Color SPIKED_COLOR = Color.from((int)0xBFBFBF);
    public static Entry spiked_shield = ArsenalSpells.add(ArsenalSpells.spiked_shield());
    public static Entry bonus_shot_ranged = ArsenalSpells.add(ArsenalSpells.bonus_shot_ranged());
    private static final float RAMPAGING_DURATION = 12.0f;
    private static final float RAMPAGING_COOLDOWN = 20.0f;
    public static Color RAMPAGING_COLOR = Color.from((int)16729882);
    public static Entry rampaging_melee = ArsenalSpells.add(ArsenalSpells.rampaging_melee());
    public static Color FOCUSING_COLOR = Color.from((int)0x99FF66);
    public static Entry rampaging_ranged = ArsenalSpells.add(ArsenalSpells.rampaging_ranged());
    public static final Color SURGING_COLOR = Color.from((int)0x99FFFF);
    public static Entry rampaging_spell = ArsenalSpells.add(ArsenalSpells.rampaging_spell());
    public static final Color FROST_CLOUD_COLOR = Color.from((int)0xCCFFFF);
    public static Entry frost_cloud_spell = ArsenalSpells.add(ArsenalSpells.frost_cloud_spell());
    public static Color COOLDOWN_SHOT_COLOR = Color.from((int)0xFFCCFF);
    public static Entry cooldown_shot_spell = ArsenalSpells.add(ArsenalSpells.cooldown_shot_spell());
    public static final Color SHOCKWAVE_COLOR = Color.from((int)11003381);
    public static Entry shockwave_melee = ArsenalSpells.add(ArsenalSpells.shockwave_melee());
    public static Entry shockwave_area_spell = ArsenalSpells.add(ArsenalSpells.shockwave_area_spell());
    public static final Color CHAIN_REACTION_COLOR = Color.from((int)14999551);
    public static Entry chain_reaction_spell = ArsenalSpells.add(ArsenalSpells.chain_reaction_spell());
    public static Entry guardian_heal = ArsenalSpells.add(ArsenalSpells.guardian_heal());
    public static final Color COOLDOWN_HEAL_COLOR = Color.from((int)0xFFCC99);
    public static Entry cooldown_heal = ArsenalSpells.add(ArsenalSpells.cooldown_heal());

    private static Entry add(Entry entry) {
        all.add(entry);
        return entry;
    }

    private static Spell activeSpellBase() {
        Spell spell = new Spell();
        spell.range = 0.0f;
        spell.tier = 8;
        spell.type = Spell.Type.ACTIVE;
        spell.active = new Spell.Active();
        spell.tooltip = new Spell.Tooltip();
        spell.tooltip.show_header = false;
        spell.tooltip.name = new Spell.Tooltip.LineOptions(false, true);
        spell.tooltip.description.color = ChatFormatting.DARK_GREEN.getSerializedName();
        spell.tooltip.description.show_in_compact = true;
        return spell;
    }

    private static Spell passiveSpellBase() {
        Spell spell = new Spell();
        spell.range = 0.0f;
        spell.tier = 8;
        spell.type = Spell.Type.PASSIVE;
        spell.passive = new Spell.Passive();
        return spell;
    }

    private static Spell.Impact createEffectImpact(String effectIdString, float duration) {
        Spell.Impact buff = new Spell.Impact();
        buff.action = new Spell.Impact.Action();
        buff.action.type = Spell.Impact.Action.Type.STATUS_EFFECT;
        buff.action.status_effect = new Spell.Impact.Action.StatusEffect();
        buff.action.status_effect.effect_id = effectIdString;
        buff.action.status_effect.duration = duration;
        return buff;
    }

    private static void configureCooldown(Spell spell, float duration) {
        if (spell.cost == null) {
            spell.cost = new Spell.Cost();
        }
        if (spell.cost.cooldown == null) {
            spell.cost.cooldown = new Spell.Cost.Cooldown();
        }
        spell.cost.cooldown.duration = duration;
        spell.cost.cooldown.hosting_item = false;
    }

    private static Spell.TargetCondition deadCondition() {
        Spell.TargetCondition deadCondition = new Spell.TargetCondition();
        deadCondition.health_percent_below = 0.0f;
        deadCondition.health_percent_above = 0.0f;
        return deadCondition;
    }

    private static Spell.TargetCondition weakCondition() {
        Spell.TargetCondition deadCondition = new Spell.TargetCondition();
        deadCondition.health_percent_below = 0.5f;
        deadCondition.health_percent_above = 0.01f;
        return deadCondition;
    }

    private static Spell.Trigger killedBySpellTrigger() {
        Spell.Trigger trigger = new Spell.Trigger();
        trigger.type = Spell.Trigger.Type.SPELL_IMPACT_SPECIFIC;
        trigger.impact = new Spell.Trigger.ImpactCondition();
        trigger.impact.impact_type = Spell.Impact.Action.Type.DAMAGE.toString();
        Spell.TargetCondition deadCondition = ArsenalSpells.deadCondition();
        trigger.target_conditions = List.of(deadCondition);
        return trigger;
    }

    private static void areaTarget(Spell spell, ResourceLocation particleId, long particleColor) {
        spell.release.particles_scaled_with_ranged = new ParticleBatch[]{new ParticleBatch(particleId.toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.GROUND, 1.0f, 0.0f, 0.0f).color(particleColor)};
        spell.target = new Spell.Target();
        spell.target.type = Spell.Target.Type.AREA;
        spell.target.area = new Spell.Target.Area();
    }

    private static void buffAreaTarget(Spell spell, ResourceLocation particleId, long particleColor) {
        ArsenalSpells.areaTarget(spell, particleId, particleColor);
        spell.target.area.include_caster = true;
    }

    private static Spell.Impact damageImpact(float coefficient, float knockback) {
        Spell.Impact damage = new Spell.Impact();
        damage.action = new Spell.Impact.Action();
        damage.action.type = Spell.Impact.Action.Type.DAMAGE;
        damage.action.damage = new Spell.Impact.Action.Damage();
        damage.action.damage.spell_power_coefficient = coefficient;
        damage.action.damage.knockback = knockback;
        return damage;
    }

    private static Entry radiance_melee() {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"arsenal", (String)"radiance_melee");
        String title = "Radiance";
        String description = "On melee hit: {trigger_chance} chance to heal yourself and nearby allies by {heal}.";
        Spell spell = ArsenalSpells.passiveSpellBase();
        spell.school = SpellSchools.HEALING;
        spell.range = 2.0f;
        Spell.Trigger trigger = new Spell.Trigger();
        trigger.chance = 0.25f;
        trigger.chance_batching = true;
        trigger.equipment_condition = EquipmentSlot.MAINHAND;
        trigger.type = Spell.Trigger.Type.MELEE_IMPACT;
        trigger.target_override = Spell.Trigger.TargetSelector.CASTER;
        trigger.aoe_source_override = Spell.Trigger.TargetSelector.CASTER;
        spell.passive.triggers = List.of(trigger);
        ArsenalSpells.radianceTargetAndImpact(spell, Attributes.ATTACK_DAMAGE.getRegisteredName());
        ArsenalSpells.configureCooldown(spell, 3.0f);
        spell.cost.cooldown.hosting_item = false;
        return new Entry(id, spell, title, description, null, Category.MELEE);
    }

    private static Entry radiance_ranged() {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"arsenal", (String)"radiance_ranged");
        String title = "Radiance";
        String description = "On arrow hit: {trigger_chance} chance to heal yourself and nearby allies by {heal}.";
        Spell spell = ArsenalSpells.passiveSpellBase();
        spell.school = SpellSchools.HEALING;
        spell.range = 2.0f;
        Spell.Trigger trigger = SpellBuilder.Triggers.arrowHit();
        trigger.chance = 0.25f;
        trigger.target_override = Spell.Trigger.TargetSelector.CASTER;
        trigger.aoe_source_override = Spell.Trigger.TargetSelector.CASTER;
        spell.passive.triggers = List.of(trigger);
        ArsenalSpells.radianceTargetAndImpact(spell, EntityAttributes_RangedWeapon.DAMAGE.id.toString());
        ArsenalSpells.configureCooldown(spell, 0.5f);
        spell.cost.cooldown.hosting_item = false;
        return new Entry(id, spell, title, description, null, Category.RANGED);
    }

    private static Entry radiance_spell() {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"arsenal", (String)"radiance_spell");
        String title = "Radiance";
        String description = "On spell cast: {trigger_chance} chance to heal yourself and nearby allies by {heal}.";
        Spell spell = ArsenalSpells.passiveSpellBase();
        spell.school = SpellSchools.HEALING;
        spell.range = 2.0f;
        Spell.Trigger trigger = new Spell.Trigger();
        trigger.chance = 0.25f;
        trigger.chance_batching = true;
        trigger.equipment_condition = EquipmentSlot.MAINHAND;
        trigger.type = Spell.Trigger.Type.SPELL_CAST;
        trigger.target_override = Spell.Trigger.TargetSelector.CASTER;
        trigger.aoe_source_override = Spell.Trigger.TargetSelector.CASTER;
        spell.passive.triggers = List.of(trigger);
        ArsenalSpells.radianceTargetAndImpact(spell, null);
        ArsenalSpells.configureCooldown(spell, 5.0f);
        spell.cost.cooldown.hosting_item = false;
        return new Entry(id, spell, title, description, null, EnumSet.of(Category.SPELL, Category.HEAL));
    }

    private static void radianceTargetAndImpact(Spell spell, @Nullable String attribute) {
        ArsenalSpells.buffAreaTarget(spell, SpellEngineParticles.area_effect_658.id(), Color.HOLY.toRGBA());
        Spell.Impact heal = new Spell.Impact();
        if (attribute != null) {
            heal.attribute = attribute;
        }
        heal.action = new Spell.Impact.Action();
        heal.action.type = Spell.Impact.Action.Type.HEAL;
        heal.action.heal = new Spell.Impact.Action.Heal();
        heal.action.heal.spell_power_coefficient = 0.25f;
        heal.particles = new ParticleBatch[]{new ParticleBatch(SPARK_DECELERATE.toString(), ParticleBatch.Shape.WIDE_PIPE, ParticleBatch.Origin.FEET, 20.0f, 0.1f, 0.1f).color(HOLY_COLOR), new ParticleBatch(SpellEngineParticles.area_circle_1.id().toString(), ParticleBatch.Shape.LINE_VERTICAL, ParticleBatch.Origin.FEET, 1.0f, 0.2f, 0.2f).followEntity(true).scale(0.8f).maxAge(0.8f).color(Color.HOLY.toRGBA()), new ParticleBatch(HOLY_DECELERATE.toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 15.0f, 0.2f, 0.25f).color(HOLY_COLOR)};
        heal.sound = new Sound(ArsenalSounds.radiance_impact.id().toString());
        spell.impacts = List.of(heal);
    }

    private static Entry stunning_melee() {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"arsenal", (String)"stunning_melee");
        String title = "Stunning";
        String description = "On melee hit: {trigger_chance} chance to stun the targets for {effect_duration} seconds.";
        Spell spell = ArsenalSpells.passiveSpellBase();
        spell.school = ExternalSpellSchools.PHYSICAL_MELEE;
        List triggers = SpellBuilder.Triggers.withConditionMustWield((List)SpellBuilder.Triggers.meleeImpact());
        triggers.forEach(trigger -> {
            trigger.chance_batching = true;
            trigger.chance = 0.2f;
        });
        spell.passive.triggers = triggers;
        spell.target.type = Spell.Target.Type.FROM_TRIGGER;
        Spell.Impact stun = ArsenalSpells.createEffectImpact(ArsenalEffects.STUN.id.toString(), 2.0f);
        stun.sound = new Sound(SpellEngineSounds.STUN_GENERIC.id().toString());
        spell.impacts = List.of(stun);
        ArsenalSpells.configureCooldown(spell, 20.0f);
        spell.cost.batching = true;
        return new Entry(id, spell, title, description, null, Category.MELEE);
    }

    private static Entry exploding_melee() {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"arsenal", (String)"exploding_melee");
        String title = "Exploding";
        String description = "On melee hit: {trigger_chance} chance to cause fiery explosion on a target, dealing {damage} damage.";
        Spell spell = ArsenalSpells.passiveSpellBase();
        spell.school = ExternalSpellSchools.PHYSICAL_MELEE;
        List triggers = SpellBuilder.Triggers.withConditionMustWield((List)SpellBuilder.Triggers.meleeImpact());
        triggers.forEach(trigger -> {
            trigger.chance = 0.2f;
        });
        spell.passive.triggers = triggers;
        spell.target.type = Spell.Target.Type.FROM_TRIGGER;
        Spell.Impact explosion = new Spell.Impact();
        explosion.action = new Spell.Impact.Action();
        explosion.action.type = Spell.Impact.Action.Type.DAMAGE;
        explosion.action.damage = new Spell.Impact.Action.Damage();
        explosion.action.damage.spell_power_coefficient = 0.5f;
        spell.impacts = List.of(explosion);
        spell.area_impact = new Spell.AreaImpact();
        spell.area_impact.radius = 2.5f;
        spell.area_impact.area.distance_dropoff = Spell.Target.Area.DropoffCurve.SQUARED;
        spell.area_impact.particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.fire_explosion.id().toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 1.0f, 0.0f, 0.1f)};
        spell.area_impact.sound = new Sound(SpellEngineSounds.GENERIC_FIRE_IMPACT_1.id().toString());
        return new Entry(id, spell, title, description, null, Category.MELEE);
    }

    private static Entry wither_melee() {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"arsenal", (String)"wither_melee");
        String title = "Withering";
        String description = "On melee hit: {trigger_chance} chance to inflict the target with strong Wither effect for {effect_duration} seconds.";
        Spell spell = ArsenalSpells.passiveSpellBase();
        spell.school = ExternalSpellSchools.PHYSICAL_MELEE;
        List triggers = SpellBuilder.Triggers.withConditionMustWield((List)SpellBuilder.Triggers.meleeImpact());
        triggers.forEach(trigger -> {
            trigger.chance = 0.2f;
        });
        spell.passive.triggers = triggers;
        spell.target.type = Spell.Target.Type.FROM_TRIGGER;
        ArsenalSpells.witherImpact(spell, 0.2f);
        ArsenalSpells.configureCooldown(spell, 3.0f);
        spell.cost.batching = true;
        return new Entry(id, spell, title, description, null, Category.MELEE);
    }

    private static Entry wither_ranged() {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"arsenal", (String)"wither_ranged");
        String title = "Withering";
        String description = "On arrow hit: {trigger_chance} chance to inflict the target with strong Wither effect for {effect_duration} seconds.";
        Spell spell = ArsenalSpells.passiveSpellBase();
        spell.school = ExternalSpellSchools.PHYSICAL_RANGED;
        Spell.Trigger trigger = SpellBuilder.Triggers.arrowHit();
        trigger.chance = 0.3f;
        spell.passive.triggers = List.of(trigger);
        spell.target.type = Spell.Target.Type.FROM_TRIGGER;
        ArsenalSpells.witherImpact(spell, 0.25f);
        ArsenalSpells.configureCooldown(spell, 3.0f);
        spell.cost.batching = true;
        return new Entry(id, spell, title, description, null, Category.RANGED);
    }

    private static void witherImpact(Spell spell, float amplifier_multiplier) {
        Spell.Impact wither = ArsenalSpells.createEffectImpact("wither", 5.0f);
        wither.action.status_effect.amplifier_power_multiplier = amplifier_multiplier;
        wither.action.status_effect.show_particles = true;
        wither.particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.MagicParticles.get((SpellEngineParticles.MagicParticles.Shape)SpellEngineParticles.MagicParticles.Shape.SKULL, (SpellEngineParticles.MagicParticles.Motion)SpellEngineParticles.MagicParticles.Motion.DECELERATE).id().toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 25.0f, 0.2f, 0.25f).color(WITHER_COLOR.toRGBA())};
        wither.sound = new Sound(ArsenalSounds.wither_impact.id().toString());
        spell.impacts = List.of(wither);
    }

    private static Entry flame_cloud_melee() {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"arsenal", (String)"flame_cloud_melee");
        String title = "Flame Strike";
        String description = "On melee hit: {trigger_chance} chance to ignite the area around the target, dealing {damage} damage per second.";
        Spell spell = ArsenalSpells.passiveSpellBase();
        spell.school = ExternalSpellSchools.PHYSICAL_MELEE;
        List triggers = SpellBuilder.Triggers.withConditionMustWield((List)SpellBuilder.Triggers.meleeImpact());
        triggers.forEach(trigger -> {
            trigger.chance = 0.2f;
        });
        spell.passive.triggers = triggers;
        spell.target.type = Spell.Target.Type.FROM_TRIGGER;
        ArsenalSpells.flameCloud(spell, 0.25f, Attributes.ATTACK_DAMAGE.getRegisteredName());
        ArsenalSpells.configureCooldown(spell, 3.0f);
        spell.cost.batching = true;
        return new Entry(id, spell, title, description, null, Category.MELEE);
    }

    private static Entry flame_cloud_ranged() {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"arsenal", (String)"flame_cloud_ranged");
        String title = "Flame Strike";
        String description = "On arrow hit: {trigger_chance} chance to ignite the area around the target, dealing {damage} damage per second.";
        Spell spell = ArsenalSpells.passiveSpellBase();
        spell.school = SpellSchools.FIRE;
        Spell.Trigger trigger = SpellBuilder.Triggers.arrowHit();
        trigger.chance = 0.3f;
        spell.passive.triggers = List.of(trigger);
        spell.target.type = Spell.Target.Type.FROM_TRIGGER;
        ArsenalSpells.flameCloud(spell, 0.25f, EntityAttributes_RangedWeapon.DAMAGE.id.toString());
        return new Entry(id, spell, title, description, null, Category.RANGED);
    }

    private static Entry flame_cloud_spell() {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"arsenal", (String)"flame_cloud_spell");
        String title = "Flame Strike";
        String description = "On spell hit: {trigger_chance} chance to ignite the area around the target, dealing {damage} damage per second.";
        Spell spell = ArsenalSpells.passiveSpellBase();
        spell.school = SpellSchools.FIRE;
        Spell.Trigger trigger = new Spell.Trigger();
        trigger.type = Spell.Trigger.Type.SPELL_IMPACT_SPECIFIC;
        trigger.impact = new Spell.Trigger.ImpactCondition();
        trigger.impact.impact_type = Spell.Impact.Action.Type.DAMAGE.toString();
        trigger.spell = new Spell.Trigger.SpellCondition();
        trigger.spell.type = Spell.Type.ACTIVE;
        trigger.chance = 0.3f;
        spell.passive.triggers = List.of(trigger);
        spell.target.type = Spell.Target.Type.FROM_TRIGGER;
        ArsenalSpells.flameCloud(spell, 0.25f, null);
        ArsenalSpells.configureCooldown(spell, 2.0f);
        return new Entry(id, spell, title, description, null, Category.SPELL);
    }

    private static void flameCloud(Spell spell, float coefficient, @Nullable String attribute) {
        spell.deliver.type = Spell.Delivery.Type.CLOUD;
        spell.deliver.delay = 10;
        Spell.Delivery.Cloud cloud = new Spell.Delivery.Cloud();
        cloud.volume.radius = 2.0f;
        cloud.volume.area.vertical_range_multiplier = 0.3f;
        cloud.volume.sound = new Sound(SpellEngineSounds.GENERIC_FIRE_IMPACT_2.id().toString());
        cloud.impact_tick_interval = 8;
        cloud.time_to_live_seconds = 4.0f;
        cloud.spawn.sound = new Sound(SpellEngineSounds.GENERIC_FIRE_IGNITE.id().toString());
        cloud.client_data = new Spell.Delivery.Cloud.ClientData();
        cloud.client_data.light_level = 15;
        cloud.client_data.particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.flame_ground.id().toString(), ParticleBatch.Shape.PILLAR, ParticleBatch.Origin.FEET, 3.0f, 0.0f, 0.0f), new ParticleBatch(SpellEngineParticles.flame_medium_a.id().toString(), ParticleBatch.Shape.PILLAR, ParticleBatch.Origin.FEET, 2.0f, 0.02f, 0.1f), new ParticleBatch(SpellEngineParticles.flame_medium_b.id().toString(), ParticleBatch.Shape.PILLAR, ParticleBatch.Origin.FEET, 1.0f, 0.02f, 0.1f), new ParticleBatch(SpellEngineParticles.flame_spark.id().toString(), ParticleBatch.Shape.PILLAR, ParticleBatch.Origin.FEET, 3.0f, 0.03f, 0.2f)};
        spell.deliver.clouds = List.of(cloud);
        Spell.Impact damage = new Spell.Impact();
        if (attribute != null) {
            damage.attribute = attribute;
        }
        damage.action = new Spell.Impact.Action();
        damage.action.type = Spell.Impact.Action.Type.DAMAGE;
        damage.action.damage = new Spell.Impact.Action.Damage();
        damage.action.damage.knockback = 0.5f;
        damage.action.damage.spell_power_coefficient = coefficient;
        damage.sound = new Sound(SpellEngineSounds.GENERIC_FIRE_IMPACT_1.id().toString());
        damage.particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.flame.id().toString(), ParticleBatch.Shape.PILLAR, ParticleBatch.Origin.FEET, 20.0f, 0.05f, 0.15f), new ParticleBatch(SpellEngineParticles.flame_medium_a.id().toString(), ParticleBatch.Shape.PILLAR, ParticleBatch.Origin.FEET, 20.0f, 0.05f, 0.15f)};
        spell.impacts = List.of(damage);
    }

    private static Entry poison_cloud_melee() {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"arsenal", (String)"poison_cloud_melee");
        String title = "Poison Cloud";
        String description = "On melee hit: {trigger_chance} chance to create a toxic cloud around the target, lasting for {effect_duration} seconds.";
        Spell spell = ArsenalSpells.passiveSpellBase();
        spell.school = ExternalSpellSchools.PHYSICAL_MELEE;
        List triggers = SpellBuilder.Triggers.withConditionMustWield((List)SpellBuilder.Triggers.meleeImpact());
        triggers.forEach(trigger -> {
            trigger.chance = 0.2f;
        });
        spell.passive.triggers = triggers;
        spell.target.type = Spell.Target.Type.FROM_TRIGGER;
        int duration = 6;
        ArsenalSpells.poisonCloud(spell, 0.25f, duration);
        ArsenalSpells.configureCooldown(spell, (float)duration * 0.5f);
        spell.cost.batching = true;
        return new Entry(id, spell, title, description, null, Category.MELEE);
    }

    private static Entry poison_cloud_ranged() {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"arsenal", (String)"poison_cloud_ranged");
        String title = "Poison Cloud";
        String description = "On arrow hit: {trigger_chance} chance to create a toxic cloud around the target, lasting for {effect_duration} seconds.";
        Spell spell = ArsenalSpells.passiveSpellBase();
        spell.school = ExternalSpellSchools.PHYSICAL_RANGED;
        Spell.Trigger trigger = SpellBuilder.Triggers.arrowHit();
        trigger.chance = 0.3f;
        spell.passive.triggers = List.of(trigger);
        spell.target.type = Spell.Target.Type.FROM_TRIGGER;
        int duration = 8;
        ArsenalSpells.poisonCloud(spell, 0.25f, duration);
        ArsenalSpells.configureCooldown(spell, (float)duration * 0.5f);
        return new Entry(id, spell, title, description, null, Category.RANGED);
    }

    private static void poisonCloud(Spell spell, float coefficient, float cloudDuration) {
        spell.deliver.type = Spell.Delivery.Type.CLOUD;
        spell.deliver.delay = 8;
        Spell.Delivery.Cloud cloud = new Spell.Delivery.Cloud();
        cloud.volume.radius = 2.0f;
        cloud.volume.area.vertical_range_multiplier = 0.3f;
        cloud.volume.sound = new Sound(ArsenalSounds.poison_cloud_tick.id().toString());
        cloud.impact_tick_interval = 8;
        cloud.time_to_live_seconds = cloudDuration;
        cloud.spawn.sound = new Sound(ArsenalSounds.poison_cloud_spawn.id().toString());
        cloud.client_data = new Spell.Delivery.Cloud.ClientData();
        cloud.client_data.light_level = 0;
        cloud.client_data.particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.smoke_large.id().toString(), ParticleBatch.Shape.PILLAR, ParticleBatch.Origin.FEET, 1.0f, 0.01f, 0.02f).color(2583652010L), new ParticleBatch(SpellEngineParticles.smoke_large.id().toString(), ParticleBatch.Shape.PILLAR, ParticleBatch.Origin.FEET, 1.0f, 0.01f, 0.02f).color(0x33DD33EEL)};
        spell.deliver.clouds = List.of(cloud);
        Spell.Impact impact = SpellBuilder.Impacts.effectAdd_ScaledCap((String)"poison", (float)5.0f, (float)coefficient);
        impact.particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.smoke_large.id().toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 0.5f, 0.01f, 0.02f).color(0x33DD33AAL), new ParticleBatch(SpellEngineParticles.MagicParticles.get((SpellEngineParticles.MagicParticles.Shape)SpellEngineParticles.MagicParticles.Shape.SKULL, (SpellEngineParticles.MagicParticles.Motion)SpellEngineParticles.MagicParticles.Motion.DECELERATE).id().toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 3.0f, 0.1f, 0.2f).color(0x33DD33AAL)};
        spell.impacts = List.of(impact);
    }

    private static Entry slowing_melee() {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"arsenal", (String)"slowing_melee");
        String title = "Frostbite";
        String description = "On melee hit: {trigger_chance} chance to slow movement and attack speed of the the target by {bonus}, for {effect_duration} seconds.";
        Effects.Entry effect = ArsenalEffects.FROSTBITE;
        SpellTooltip.DescriptionMutator mutator = args -> {
            AttributeModifier modifier = effect.config().firstModifier();
            String bonus = SpellTooltip.bonus((float)modifier.value, (AttributeModifier.Operation)modifier.operation);
            return args.description().replace("{bonus}", bonus);
        };
        Spell spell = ArsenalSpells.passiveSpellBase();
        spell.school = ExternalSpellSchools.PHYSICAL_MELEE;
        List triggers = SpellBuilder.Triggers.withConditionMustWield((List)SpellBuilder.Triggers.meleeImpact());
        triggers.forEach(trigger -> {
            trigger.chance_batching = true;
            trigger.chance = 0.2f;
        });
        spell.passive.triggers = triggers;
        spell.target.type = Spell.Target.Type.FROM_TRIGGER;
        Spell.Impact slow = ArsenalSpells.createEffectImpact(ArsenalEffects.FROSTBITE.id.toString(), 4.0f);
        slow.particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.snowflake.id().toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 25.0f, 0.1f, 0.15f)};
        slow.sound = new Sound(SpellEngineSounds.STUN_GENERIC.id().toString());
        spell.impacts = List.of(slow);
        ArsenalSpells.configureCooldown(spell, 3.0f);
        spell.cost.batching = true;
        return new Entry(id, spell, title, description, mutator, Category.MELEE);
    }

    private static Entry leeching_melee() {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"arsenal", (String)"leeching_melee");
        String title = "Leeching";
        String description = "Defeating enemies heals you by a small portion of their max health.";
        Spell spell = ArsenalSpells.passiveSpellBase();
        spell.school = ExternalSpellSchools.PHYSICAL_MELEE;
        spell.passive.triggers = SpellBuilder.Triggers.withConditionMustWield((List)SpellBuilder.Triggers.meleeKills());
        spell.target.type = Spell.Target.Type.FROM_TRIGGER;
        ArsenalSpells.leechingEffect(spell);
        return new Entry(id, spell, title, description, null, Category.MELEE);
    }

    private static Entry leeching_spell() {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"arsenal", (String)"leeching_spell");
        String title = "Leeching";
        String description = "Defeating enemies heals you by a small portion of their max health.";
        Spell spell = ArsenalSpells.passiveSpellBase();
        spell.school = ExternalSpellSchools.PHYSICAL_MELEE;
        spell.passive.triggers = List.of(ArsenalSpells.killedBySpellTrigger());
        spell.target.type = Spell.Target.Type.FROM_TRIGGER;
        ArsenalSpells.leechingEffect(spell);
        return new Entry(id, spell, title, description, null, Category.SPELL);
    }

    private static void leechingEffect(Spell spell) {
        Spell.Impact leech = new Spell.Impact();
        leech.attribute = Attributes.MAX_HEALTH.getRegisteredName();
        leech.attribute_from_target = true;
        leech.action = new Spell.Impact.Action();
        leech.action.apply_to_caster = true;
        leech.action.type = Spell.Impact.Action.Type.HEAL;
        leech.action.heal = new Spell.Impact.Action.Heal();
        leech.action.heal.spell_power_coefficient = 0.05f;
        leech.particles = new ParticleBatch[]{new ParticleBatch(SPARK_FLOAT.toString(), ParticleBatch.Shape.WIDE_PIPE, ParticleBatch.Origin.CENTER, 15.0f, 0.02f, 0.1f).color(LEECHING_COLOR.toRGBA()), new ParticleBatch(SPARK_DECELERATE.toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 25.0f, 0.08f, 0.12f).invert().preSpawnTravel(5.0f).followEntity(true).color(LEECHING_COLOR.toRGBA()), new ParticleBatch(SpellEngineParticles.ground_glow.id().toString(), ParticleBatch.Shape.LINE_VERTICAL, ParticleBatch.Origin.GROUND, 1.0f, 0.0f, 0.0f).followEntity(true).scale(0.8f).color(LEECHING_COLOR.alpha(0.2f).toRGBA())};
        leech.sound = Sound.withVolume((ResourceLocation)ArsenalSounds.leeching_impact.id(), (float)0.6f);
        spell.impacts = List.of(leech);
    }

    private static Entry swirling_melee() {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"arsenal", (String)"swirling_melee");
        String title = "Swirling";
        String description = "The last attack in a combo performs a swirling attack, dealing {damage} damage to nearby enemies.";
        Spell spell = ArsenalSpells.passiveSpellBase();
        spell.school = ExternalSpellSchools.PHYSICAL_MELEE;
        spell.range = -0.5f;
        spell.range_mechanic = Spell.RangeMechanic.MELEE;
        Spell.Trigger trigger = SpellBuilder.Triggers.withConditionMustWield((Spell.Trigger)SpellBuilder.Triggers.meleeAttackImpact());
        trigger.melee = new Spell.Trigger.MeleeCondition();
        trigger.melee.is_combo = true;
        trigger.melee.is_offhand = false;
        spell.passive.triggers = List.of(trigger);
        spell.release.sound = new Sound(ArsenalSounds.swirling.id().toString());
        spell.target.type = Spell.Target.Type.AREA;
        spell.target.area = new Spell.Target.Area();
        spell.target.area.distance_dropoff = Spell.Target.Area.DropoffCurve.NONE;
        spell.target.area.vertical_range_multiplier = 0.5f;
        spell.release.particles_scaled_with_ranged = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.area_swirl.id().toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 1.0f, 0.0f, 0.0f).scale(0.8f).followEntity(true)};
        Spell.Impact damage = ArsenalSpells.damageImpact(0.5f, 0.5f);
        spell.impacts = List.of(damage);
        return new Entry(id, spell, title, description, null, Category.MELEE);
    }

    private static Entry guarding_strike_melee() {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"arsenal", (String)"guarding_strike_melee");
        String title = "Guarding Strike";
        Effects.Entry effect = ArsenalEffects.GUARDING;
        String description = "Defeating enemies grants you and nearby allies a temporary effect reducing damage taken by {bonus}, lasting {effect_duration} seconds.";
        SpellTooltip.DescriptionMutator mutator = args -> {
            AttributeModifier modifier = effect.config().firstModifier();
            String bonus = SpellTooltip.bonus((float)Math.abs(modifier.value), (AttributeModifier.Operation)modifier.operation);
            return args.description().replace("{bonus}", bonus);
        };
        Spell spell = ArsenalSpells.passiveSpellBase();
        spell.school = ExternalSpellSchools.PHYSICAL_MELEE;
        spell.range = 2.0f;
        List triggers = SpellBuilder.Triggers.withConditionMustWield((List)SpellBuilder.Triggers.meleeKills());
        for (Spell.Trigger trigger : triggers) {
            trigger.target_override = Spell.Trigger.TargetSelector.CASTER;
            trigger.aoe_source_override = Spell.Trigger.TargetSelector.CASTER;
        }
        spell.passive.triggers = triggers;
        spell.release.sound = new Sound(ArsenalSounds.guardian_strike_release.id().toString());
        ArsenalSpells.buffAreaTarget(spell, SpellEngineParticles.area_effect_714.id(), GUARDING_COLOR.toRGBA());
        Spell.Impact buff = ArsenalSpells.createEffectImpact(ArsenalEffects.GUARDING.id.toString(), 5.0f);
        buff.particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.area_circle_1.id().toString(), ParticleBatch.Shape.LINE_VERTICAL, ParticleBatch.Origin.FEET, 1.0f, 0.2f, 0.2f).followEntity(true).scale(0.8f).maxAge(0.4f).color(GUARDING_COLOR.toRGBA()), new ParticleBatch(SpellEngineParticles.sign_shield.id().toString(), ParticleBatch.Shape.LINE_VERTICAL, ParticleBatch.Origin.CENTER, 1.0f, 0.75f, 0.75f).scale(0.8f).color(GUARDING_COLOR.alpha(0.75f).toRGBA()).followEntity(true)};
        buff.sound = new Sound(ArsenalSounds.guardian_strike_impact.id().toString());
        spell.impacts = List.of(buff);
        ArsenalSpells.configureCooldown(spell, 10.0f);
        return new Entry(id, spell, title, description, mutator, Category.MELEE);
    }

    private static Entry sundering_melee() {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"arsenal", (String)"sundering_melee");
        String title = "Sundering";
        String description = "On melee hit: {trigger_chance} chance to reduce the target's armor by {bonus} for {effect_duration} seconds.";
        Effects.Entry effect = ArsenalEffects.SUNDERING;
        SpellTooltip.DescriptionMutator mutator = args -> {
            AttributeModifier modifier = effect.config().firstModifier();
            String bonus = SpellTooltip.bonus((float)Math.abs(modifier.value), (AttributeModifier.Operation)modifier.operation);
            return args.description().replace("{bonus}", bonus);
        };
        Spell spell = ArsenalSpells.passiveSpellBase();
        spell.school = ExternalSpellSchools.PHYSICAL_MELEE;
        Spell.Trigger trigger = SpellBuilder.Triggers.withConditionMustWield((Spell.Trigger)SpellBuilder.Triggers.meleeAttackImpact());
        trigger.chance_batching = true;
        trigger.chance = 0.2f;
        spell.passive.triggers = List.of(trigger);
        spell.target.type = Spell.Target.Type.FROM_TRIGGER;
        Spell.Impact sunder = ArsenalSpells.createEffectImpact(ArsenalEffects.SUNDERING.id.toString(), 5.0f);
        sunder.particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.smoke_medium.id().toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 25.0f, 0.1f, 0.1f).color(SUNDERING_COLOR.toRGBA())};
        sunder.sound = new Sound(ArsenalSounds.sunder_impact.id().toString());
        spell.impacts = List.of(sunder);
        ArsenalSpells.configureCooldown(spell, 5.0f);
        spell.cost.batching = true;
        return new Entry(id, spell, title, description, mutator, Category.MELEE);
    }

    private static Entry unyielding_shield() {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"arsenal", (String)"unyielding_shield");
        String title = "Unyielding";
        String description = "Blocking grants you increased knockback resistance and armor toughness, lasting {effect_duration} seconds.";
        Effects.Entry effect = ArsenalEffects.UNYIELDING;
        Spell spell = ArsenalSpells.passiveSpellBase();
        spell.school = ExternalSpellSchools.PHYSICAL_MELEE;
        Spell.Trigger trigger = SpellBuilder.Triggers.shieldBlock();
        spell.passive.triggers = List.of(trigger);
        int duration = 5;
        Spell.Impact buff = ArsenalSpells.createEffectImpact(effect.id.toString(), duration);
        buff.particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.sign_shield.id().toString(), ParticleBatch.Shape.LINE_VERTICAL, ParticleBatch.Origin.CENTER, 1.0f, 0.75f, 0.75f).scale(0.8f).color(UNYIELDING_COLOR.alpha(0.75f).toRGBA()).followEntity(true), new ParticleBatch(SPARK_DECELERATE.toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 10.0f, 0.3f, 0.35f).color(UNYIELDING_COLOR.toRGBA())};
        buff.sound = new Sound(ArsenalSounds.unyielding_impact.id().toString());
        spell.impacts = List.of(buff);
        ArsenalSpells.configureCooldown(spell, duration * 2);
        return new Entry(id, spell, title, description, null, Category.SHIELD);
    }

    private static Entry guarding_shield() {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"arsenal", (String)"guarding_shield");
        String title = "Guarding";
        String description = "On shield block: {trigger_chance} chance to reduce damage taken by {bonus}, lasting {effect_duration} seconds.";
        Effects.Entry effect = ArsenalEffects.GUARDING;
        SpellTooltip.DescriptionMutator mutator = args -> {
            AttributeModifier modifier = effect.config().firstModifier();
            String bonus = SpellTooltip.bonus((float)Math.abs(modifier.value), (AttributeModifier.Operation)modifier.operation);
            return args.description().replace("{bonus}", bonus);
        };
        Spell spell = ArsenalSpells.passiveSpellBase();
        spell.school = ExternalSpellSchools.PHYSICAL_MELEE;
        Spell.Trigger trigger = SpellBuilder.Triggers.shieldBlock();
        trigger.chance = 0.3f;
        spell.passive.triggers = List.of(trigger);
        spell.target.type = Spell.Target.Type.FROM_TRIGGER;
        ArsenalSpells.buffAreaTarget(spell, SpellEngineParticles.area_effect_714.id(), GUARDING_COLOR.toRGBA());
        Spell.Impact buff = ArsenalSpells.createEffectImpact(ArsenalEffects.GUARDING.id.toString(), 5.0f);
        buff.particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.area_circle_1.id().toString(), ParticleBatch.Shape.LINE_VERTICAL, ParticleBatch.Origin.FEET, 1.0f, 0.2f, 0.2f).followEntity(true).scale(0.8f).maxAge(0.4f).color(GUARDING_COLOR.toRGBA()), new ParticleBatch(SpellEngineParticles.sign_shield.id().toString(), ParticleBatch.Shape.LINE_VERTICAL, ParticleBatch.Origin.CENTER, 1.0f, 0.75f, 0.75f).scale(0.8f).color(GUARDING_COLOR.alpha(0.75f).toRGBA()).followEntity(true)};
        buff.sound = new Sound(ArsenalSounds.guardian_strike_impact.id().toString());
        spell.impacts = List.of(buff);
        ArsenalSpells.configureCooldown(spell, 10.0f);
        return new Entry(id, spell, title, description, mutator, Category.SHIELD);
    }

    private static Entry spiked_shield() {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"arsenal", (String)"spiked_shield");
        String title = "Spiked";
        String description = "On shield block: {trigger_chance} chance to deal {damage} damage to the attacker.";
        Spell spell = ArsenalSpells.passiveSpellBase();
        spell.school = ExternalSpellSchools.PHYSICAL_MELEE;
        Spell.Trigger trigger = SpellBuilder.Triggers.shieldBlock();
        trigger.chance = 0.5f;
        trigger.target_override = Spell.Trigger.TargetSelector.TARGET;
        spell.passive.triggers = List.of(trigger);
        spell.target.type = Spell.Target.Type.FROM_TRIGGER;
        Spell.Impact damage = ArsenalSpells.damageImpact(0.25f, 0.25f);
        damage.action.min_power = 10.0f;
        damage.particles = new ParticleBatch[]{new ParticleBatch(SPARK_FLOAT.toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 10.0f, 0.3f, 0.35f).color(SPIKED_COLOR.toRGBA())};
        damage.sound = new Sound(ArsenalSounds.spike_impact.id().toString());
        spell.impacts = List.of(damage);
        return new Entry(id, spell, title, description, null, Category.SHIELD);
    }

    private static Entry bonus_shot_ranged() {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"arsenal", (String)"bonus_shot_ranged");
        String title = "Bonus Shot";
        String description = "On arrow hit: {trigger_chance} chance to shoot an additional arrow.";
        Spell spell = ArsenalSpells.passiveSpellBase();
        spell.school = ExternalSpellSchools.PHYSICAL_RANGED;
        Spell.Trigger trigger = SpellBuilder.Triggers.arrowShot();
        trigger.chance = 0.2f;
        trigger.fire_delay = 1;
        spell.passive.triggers = List.of(trigger);
        spell.release.particles = new ParticleBatch[]{new ParticleBatch(SPARK_DECELERATE.toString(), ParticleBatch.Shape.PIPE, ParticleBatch.Origin.LAUNCH_POINT, 25.0f, 0.2f, 0.7f).rotate(ParticleBatch.Rotation.LOOK)};
        spell.target.type = Spell.Target.Type.AIM;
        spell.target.aim = new Spell.Target.Aim();
        spell.deliver.type = Spell.Delivery.Type.SHOOT_ARROW;
        spell.deliver.shoot_arrow = new Spell.Delivery.ShootArrow();
        spell.deliver.shoot_arrow.launch_properties.velocity = 3.15f;
        spell.deliver.delay = 2;
        spell.arrow_perks = new Spell.ArrowPerks();
        spell.arrow_perks.damage_multiplier = 1.0f;
        spell.arrow_perks.bypass_iframes = true;
        spell.arrow_perks.knockback = 0.5f;
        ArsenalSpells.configureCooldown(spell, 1.0f);
        return new Entry(id, spell, title, description, null, Category.RANGED);
    }

    private static Entry rampaging_melee() {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"arsenal", (String)"rampaging_melee");
        String title = "Rampaging";
        String description = "Defeating enemies grants " + title + " effect, increasing your damage by {bonus}, stacking up to {effect_amplifier_cap} times, lasting {effect_duration} seconds.";
        Effects.Entry effect = ArsenalEffects.RAMPAGING;
        SpellTooltip.DescriptionMutator mutator = args -> {
            AttributeModifier modifier = effect.config().firstModifier();
            String bonus = SpellTooltip.bonus((float)Math.abs(modifier.value), (AttributeModifier.Operation)modifier.operation);
            return args.description().replace("{bonus}", bonus);
        };
        Spell spell = ArsenalSpells.passiveSpellBase();
        spell.school = ExternalSpellSchools.PHYSICAL_MELEE;
        List triggers = SpellBuilder.Triggers.withConditionMustWield((List)SpellBuilder.Triggers.meleeKills());
        for (Spell.Trigger trigger : triggers) {
            trigger.target_override = Spell.Trigger.TargetSelector.CASTER;
        }
        spell.passive.triggers = triggers;
        spell.release.sound = new Sound(ArsenalSounds.rampaging_activate.id().toString());
        spell.deliver.type = Spell.Delivery.Type.STASH_EFFECT;
        spell.deliver.stash_effect = new Spell.Delivery.StashEffect();
        spell.deliver.stash_effect.id = effect.id.toString();
        spell.deliver.stash_effect.consume = 0;
        spell.deliver.stash_effect.triggers = triggers;
        spell.target.type = Spell.Target.Type.FROM_TRIGGER;
        Spell.Impact buff = ArsenalSpells.createEffectImpact(effect.id.toString(), 12.0f);
        buff.particles = new ParticleBatch[]{new ParticleBatch(SPARK_DECELERATE.toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 10.0f, 0.3f, 0.35f).color(RAMPAGING_COLOR.toRGBA())};
        buff.action.status_effect.apply_mode = Spell.Impact.Action.StatusEffect.ApplyMode.ADD;
        buff.action.status_effect.amplifier = 1;
        buff.action.status_effect.amplifier_cap = 4;
        buff.action.status_effect.refresh_duration = false;
        spell.impacts = List.of(buff);
        ArsenalSpells.configureCooldown(spell, 20.0f);
        spell.cost.batching = true;
        return new Entry(id, spell, title, description, mutator, Category.MELEE);
    }

    private static Entry rampaging_ranged() {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"arsenal", (String)"rampaging_ranged");
        Effects.Entry effect = ArsenalEffects.FOCUSING;
        String title = "Focusing";
        String description = "Defeating enemies grants " + effect.title + " effect, increasing your damage by {bonus}, stacking up to {effect_amplifier_cap} times, lasting {effect_duration} seconds.";
        SpellTooltip.DescriptionMutator mutator = args -> {
            AttributeModifier modifier = effect.config().firstModifier();
            String bonus = SpellTooltip.bonus((float)Math.abs(modifier.value), (AttributeModifier.Operation)modifier.operation);
            return args.description().replace("{bonus}", bonus);
        };
        Spell spell = ArsenalSpells.passiveSpellBase();
        spell.school = ExternalSpellSchools.PHYSICAL_RANGED;
        List triggers = SpellBuilder.Triggers.withConditionMustWield((List)SpellBuilder.Triggers.rangedKill());
        triggers.forEach(trigger -> {
            trigger.target_override = Spell.Trigger.TargetSelector.CASTER;
        });
        spell.passive.triggers = triggers;
        spell.release.sound = new Sound(ArsenalSounds.focusing_activate.id().toString());
        spell.deliver.type = Spell.Delivery.Type.STASH_EFFECT;
        spell.deliver.stash_effect = new Spell.Delivery.StashEffect();
        spell.deliver.stash_effect.id = effect.id.toString();
        spell.deliver.stash_effect.consume = 0;
        spell.deliver.stash_effect.triggers = triggers;
        spell.target.type = Spell.Target.Type.FROM_TRIGGER;
        Spell.Impact buff = ArsenalSpells.createEffectImpact(effect.id.toString(), 12.0f);
        buff.particles = new ParticleBatch[]{new ParticleBatch(SPARK_DECELERATE.toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 10.0f, 0.3f, 0.35f).color(FOCUSING_COLOR.toRGBA())};
        buff.action.status_effect.apply_mode = Spell.Impact.Action.StatusEffect.ApplyMode.ADD;
        buff.action.status_effect.amplifier = 1;
        buff.action.status_effect.amplifier_cap = 2;
        buff.action.status_effect.refresh_duration = false;
        spell.impacts = List.of(buff);
        ArsenalSpells.configureCooldown(spell, 20.0f);
        spell.cost.batching = true;
        return new Entry(id, spell, title, description, mutator, Category.RANGED);
    }

    private static Entry rampaging_spell() {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"arsenal", (String)"rampaging_spell");
        Effects.Entry effect = ArsenalEffects.SURGING;
        String title = "Surging";
        String description = "Defeating enemies grants " + effect.title + " effect, increasing your spell critical chance by {bonus}, stacking up to {effect_amplifier_cap} times, lasting {effect_duration} seconds.";
        SpellTooltip.DescriptionMutator mutator = args -> {
            AttributeModifier modifier = effect.config().firstModifier();
            String bonus = SpellTooltip.bonus((float)Math.abs(modifier.value), (AttributeModifier.Operation)modifier.operation);
            return args.description().replace("{bonus}", bonus);
        };
        Spell spell = ArsenalSpells.passiveSpellBase();
        spell.school = SpellSchools.ARCANE;
        spell.release.sound = new Sound(ArsenalSounds.surging_activate.id().toString());
        Spell.Trigger trigger = ArsenalSpells.killedBySpellTrigger();
        trigger.target_override = Spell.Trigger.TargetSelector.CASTER;
        spell.passive.triggers = List.of(trigger);
        spell.deliver.type = Spell.Delivery.Type.STASH_EFFECT;
        spell.deliver.stash_effect = new Spell.Delivery.StashEffect();
        spell.deliver.stash_effect.id = effect.id.toString();
        spell.deliver.stash_effect.consume = 0;
        spell.deliver.stash_effect.triggers = List.of(trigger);
        spell.target.type = Spell.Target.Type.FROM_TRIGGER;
        float duration = 12.0f;
        Spell.Impact buff = ArsenalSpells.createEffectImpact(effect.id.toString(), duration);
        buff.particles = new ParticleBatch[]{new ParticleBatch(SPARK_DECELERATE.toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 10.0f, 0.3f, 0.35f).color(SURGING_COLOR.toRGBA())};
        buff.action.status_effect.apply_mode = Spell.Impact.Action.StatusEffect.ApplyMode.ADD;
        buff.action.status_effect.amplifier = 1;
        buff.action.status_effect.amplifier_cap = 4;
        buff.action.status_effect.refresh_duration = false;
        spell.impacts = List.of(buff);
        ArsenalSpells.configureCooldown(spell, 20.0f);
        spell.cost.batching = true;
        return new Entry(id, spell, title, description, mutator, Category.SPELL);
    }

    private static Entry frost_cloud_spell() {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"arsenal", (String)"frost_cloud_spell");
        String title = "Frosty Puddle";
        String description = "On spell hit: {trigger_chance} chance to create a freezing zone around the target, slowing its movement and attack speed, lasting for {effect_duration} seconds.";
        Spell spell = ArsenalSpells.passiveSpellBase();
        spell.school = SpellSchools.FROST;
        Spell.Trigger trigger = new Spell.Trigger();
        trigger.type = Spell.Trigger.Type.SPELL_IMPACT_SPECIFIC;
        trigger.impact = new Spell.Trigger.ImpactCondition();
        trigger.impact.impact_type = Spell.Impact.Action.Type.DAMAGE.toString();
        trigger.spell = new Spell.Trigger.SpellCondition();
        trigger.spell.type = Spell.Type.ACTIVE;
        trigger.chance = 0.2f;
        spell.passive.triggers = List.of(trigger);
        spell.target.type = Spell.Target.Type.FROM_TRIGGER;
        ArsenalSpells.frostCloud(spell);
        ArsenalSpells.configureCooldown(spell, 2.0f);
        return new Entry(id, spell, title, description, null, Category.SPELL);
    }

    private static void frostCloud(Spell spell) {
        spell.deliver.type = Spell.Delivery.Type.CLOUD;
        spell.deliver.delay = 10;
        SpellEngineParticles.TemplateEntry areaParticle = SpellEngineParticles.area_effect_480;
        int radius = 2;
        Spell.Delivery.Cloud cloud = new Spell.Delivery.Cloud();
        cloud.volume.radius = radius;
        cloud.volume.area.vertical_range_multiplier = 0.3f;
        cloud.volume.sound = new Sound(SpellEngineSounds.GENERIC_FIRE_IMPACT_2.id().toString());
        cloud.impact_tick_interval = 8;
        cloud.time_to_live_seconds = 5.0f;
        cloud.spawn.sound = new Sound(SpellEngineSounds.GENERIC_FIRE_IGNITE.id().toString());
        cloud.client_data = new Spell.Delivery.Cloud.ClientData();
        cloud.client_data.light_level = 6;
        cloud.client_data.particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.snowflake.id().toString(), ParticleBatch.Shape.PILLAR, ParticleBatch.Origin.FEET, 2.0f, 0.1f, 0.12f)};
        cloud.client_data.particle_spawn_interval = SpellEngineParticles.area_effect_480.texture().frames();
        cloud.client_data.interval_particles = new ParticleBatch[]{new ParticleBatch(areaParticle.id().toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.GROUND, 1.0f, 0.0f, 0.0f).scale((float)radius).color(FROST_CLOUD_COLOR.alpha(0.75f).toRGBA())};
        spell.deliver.clouds = List.of(cloud);
        Spell.Impact impact = ArsenalSpells.createEffectImpact(ArsenalEffects.FROSTBITE.id.toString(), 2.0f);
        impact.sound = new Sound(SpellEngineSounds.STUN_GENERIC.id().toString());
        impact.particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.snowflake.id().toString(), ParticleBatch.Shape.PILLAR, ParticleBatch.Origin.FEET, 20.0f, 0.05f, 0.15f)};
        spell.impacts = List.of(impact);
    }

    private static Entry cooldown_shot_spell() {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"arsenal", (String)"cooldown_shot_spell");
        String title = "Cooldown Shot";
        String description = "On spell critical hit: {trigger_chance} chance to reset your spell cooldowns.";
        Spell spell = ArsenalSpells.passiveSpellBase();
        spell.school = SpellSchools.ARCANE;
        Spell.Trigger trigger = new Spell.Trigger();
        trigger.type = Spell.Trigger.Type.SPELL_IMPACT_SPECIFIC;
        trigger.impact = new Spell.Trigger.ImpactCondition();
        trigger.impact.impact_type = Spell.Impact.Action.Type.DAMAGE.toString();
        trigger.impact.critical = true;
        trigger.spell = new Spell.Trigger.SpellCondition();
        trigger.spell.type = Spell.Type.ACTIVE;
        trigger.chance = 0.5f;
        trigger.target_override = Spell.Trigger.TargetSelector.CASTER;
        spell.passive.triggers = List.of(trigger);
        spell.target.type = Spell.Target.Type.FROM_TRIGGER;
        Spell.Impact impact = new Spell.Impact();
        impact.action = new Spell.Impact.Action();
        impact.action.type = Spell.Impact.Action.Type.COOLDOWN;
        impact.action.cooldown = new Spell.Impact.Action.Cooldown();
        impact.action.cooldown.actives = new Spell.Impact.Action.Cooldown.Modify();
        impact.action.cooldown.actives.duration_multiplier = 0.0f;
        impact.particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.sign_hourglass.id().toString(), ParticleBatch.Shape.LINE_VERTICAL, ParticleBatch.Origin.CENTER, 1.0f, 0.75f, 0.75f).scale(0.8f).color(COOLDOWN_SHOT_COLOR.toRGBA()).followEntity(true), new ParticleBatch(SPARK_DECELERATE.toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 40.0f, 0.3f, 0.3f).color(COOLDOWN_SHOT_COLOR.toRGBA())};
        impact.sound = new Sound(ArsenalSounds.spell_cooldown_impact.id().toString());
        spell.impacts = List.of(impact);
        ArsenalSpells.configureCooldown(spell, 30.0f);
        return new Entry(id, spell, title, description, null, EnumSet.of(Category.SPELL, Category.HEAL));
    }

    private static Entry shockwave_melee() {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"arsenal", (String)"shockwave_melee");
        String title = "Shockwave";
        String description = "The last attack in a combo sends a shockwave forward, dealing {damage} damage to enemies in its path.";
        Spell spell = ArsenalSpells.passiveSpellBase();
        spell.school = ExternalSpellSchools.PHYSICAL_MELEE;
        spell.range = 10.0f;
        Spell.Trigger trigger = SpellBuilder.Triggers.withConditionMustWield((Spell.Trigger)SpellBuilder.Triggers.meleeAttackImpact());
        trigger.melee = new Spell.Trigger.MeleeCondition();
        trigger.melee.is_combo = true;
        trigger.melee.is_offhand = false;
        spell.passive.triggers = List.of(trigger);
        spell.target.type = Spell.Target.Type.AIM;
        spell.target.aim = new Spell.Target.Aim();
        spell.deliver.type = Spell.Delivery.Type.PROJECTILE;
        spell.deliver.projectile = new Spell.Delivery.ShootProjectile();
        spell.deliver.projectile.inherit_shooter_pitch = false;
        spell.deliver.projectile.launch_properties.velocity = 0.75f;
        spell.deliver.projectile.launch_properties.sound = new Sound(ArsenalSounds.shockwave_release.id().toString());
        Spell.ProjectileData projectile = new Spell.ProjectileData();
        projectile.homing_angle = 0.0f;
        projectile.client_data = new Spell.ProjectileData.Client();
        projectile.client_data.model = new Spell.ProjectileModel();
        projectile.client_data.model.model_id = ArsenalProjectiles.shockwave_large.id().toString();
        projectile.client_data.model.scale = 4.0f;
        projectile.client_data.model.rotate_degrees_per_tick = 0.0f;
        projectile.perks.pierce = 999;
        projectile.hitbox = new Spell.ProjectileData.HitBox(3.5f, 0.5f);
        spell.deliver.projectile.projectile = projectile;
        Spell.Impact damage = ArsenalSpells.damageImpact(0.25f, 0.5f);
        damage.particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.MagicParticles.get((SpellEngineParticles.MagicParticles.Shape)SpellEngineParticles.MagicParticles.Shape.ARCANE, (SpellEngineParticles.MagicParticles.Motion)SpellEngineParticles.MagicParticles.Motion.BURST).id().toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, null, 20.0f, 0.2f, 0.7f, 0.0f, 0.0f).color(SHOCKWAVE_COLOR.toRGBA())};
        damage.sound = new Sound(ArsenalSounds.shockwave_impact.id().toString());
        spell.impacts = List.of(damage);
        return new Entry(id, spell, title, description, null, Category.MELEE);
    }

    private static Entry shockwave_area_spell() {
        int cooldown_threshold = 5;
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"arsenal", (String)"shockwave_area_spell");
        String title = "Shockwave Area";
        String description = "Damaging spells with longer than " + cooldown_threshold + " seconds cooldown, send shockwaves around you, dealing {damage} damage to enemies in their path.";
        Spell spell = ArsenalSpells.passiveSpellBase();
        spell.school = SpellSchools.ARCANE;
        spell.range = 10.0f;
        Spell.Trigger trigger = new Spell.Trigger();
        trigger.type = Spell.Trigger.Type.SPELL_IMPACT_SPECIFIC;
        trigger.impact = new Spell.Trigger.ImpactCondition();
        trigger.impact.impact_type = Spell.Impact.Action.Type.DAMAGE.toString();
        trigger.spell = new Spell.Trigger.SpellCondition();
        trigger.spell.cooldown_min = cooldown_threshold;
        trigger.spell.type = Spell.Type.ACTIVE;
        spell.passive.triggers = List.of(trigger);
        spell.target.type = Spell.Target.Type.FROM_TRIGGER;
        spell.deliver.type = Spell.Delivery.Type.PROJECTILE;
        spell.deliver.projectile = new Spell.Delivery.ShootProjectile();
        spell.deliver.projectile.direct_towards_target = true;
        spell.deliver.projectile.launch_properties.velocity = 0.6f;
        spell.deliver.projectile.launch_properties.extra_launch_count = 3;
        spell.deliver.projectile.launch_properties.extra_launch_delay = 0;
        spell.deliver.projectile.launch_properties.sound = Sound.withVolume((ResourceLocation)ArsenalSounds.shockwave_release.id(), (float)0.6f);
        spell.deliver.projectile.direction_offsets = new Spell.Delivery.ShootProjectile.DirectionOffset[]{new Spell.Delivery.ShootProjectile.DirectionOffset(0.0f, 0.0f), new Spell.Delivery.ShootProjectile.DirectionOffset(90.0f, 0.0f), new Spell.Delivery.ShootProjectile.DirectionOffset(180.0f, 0.0f), new Spell.Delivery.ShootProjectile.DirectionOffset(270.0f, 0.0f)};
        Spell.ProjectileData projectile = new Spell.ProjectileData();
        projectile.homing_angle = 0.0f;
        projectile.client_data = new Spell.ProjectileData.Client();
        projectile.client_data.model = new Spell.ProjectileModel();
        projectile.client_data.model.model_id = ArsenalProjectiles.shockwave.id().toString();
        projectile.client_data.model.scale = 2.0f;
        projectile.client_data.model.rotate_degrees_per_tick = 0.0f;
        projectile.perks.pierce = 999;
        projectile.hitbox = new Spell.ProjectileData.HitBox(2.0f, 0.4f);
        spell.deliver.projectile.projectile = projectile;
        Spell.Impact damage = ArsenalSpells.damageImpact(0.25f, 0.5f);
        damage.action.min_power = 7.0f;
        damage.particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.MagicParticles.get((SpellEngineParticles.MagicParticles.Shape)SpellEngineParticles.MagicParticles.Shape.ARCANE, (SpellEngineParticles.MagicParticles.Motion)SpellEngineParticles.MagicParticles.Motion.BURST).id().toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, null, 20.0f, 0.2f, 0.7f, 0.0f, 0.0f).color(SHOCKWAVE_COLOR.toRGBA())};
        damage.sound = new Sound(ArsenalSounds.shockwave_impact.id().toString());
        spell.impacts = List.of(damage);
        ArsenalSpells.configureCooldown(spell, 4.0f);
        return new Entry(id, spell, title, description, null, EnumSet.of(Category.SPELL, Category.HEAL));
    }

    private static Entry chain_reaction_spell() {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"arsenal", (String)"chain_reaction_spell");
        String title = "Chain Reaction";
        String description = "On spell critical hit: launches a spell projectile with chain reaction, dealing {damage} spell damage.";
        Spell spell = ArsenalSpells.passiveSpellBase();
        spell.school = SpellSchools.ARCANE;
        spell.range = 20.0f;
        Spell.Trigger trigger = new Spell.Trigger();
        trigger.type = Spell.Trigger.Type.SPELL_IMPACT_SPECIFIC;
        trigger.impact = new Spell.Trigger.ImpactCondition();
        trigger.impact.impact_type = Spell.Impact.Action.Type.DAMAGE.toString();
        trigger.impact.critical = true;
        trigger.spell = new Spell.Trigger.SpellCondition();
        trigger.spell.type = Spell.Type.ACTIVE;
        spell.passive.triggers = List.of(trigger);
        spell.target.type = Spell.Target.Type.FROM_TRIGGER;
        spell.deliver.type = Spell.Delivery.Type.PROJECTILE;
        spell.deliver.projectile = new Spell.Delivery.ShootProjectile();
        spell.deliver.projectile.direct_towards_target = true;
        spell.deliver.projectile.launch_properties.velocity = 0.75f;
        spell.deliver.projectile.launch_properties.sound = new Sound(ArsenalSounds.missile_release.id().toString());
        spell.deliver.projectile.direction_offsets = new Spell.Delivery.ShootProjectile.DirectionOffset[]{new Spell.Delivery.ShootProjectile.DirectionOffset(0.0f, -80.0f)};
        Spell.ProjectileData projectile = new Spell.ProjectileData();
        projectile.homing_angles = new float[]{10.0f, 20.0f, 30.0f, 20.0f};
        projectile.homing_angle = 3.0f;
        projectile.perks.chain_reaction_size = 3;
        projectile.perks.chain_reaction_triggers = 1;
        projectile.client_data = new Spell.ProjectileData.Client();
        projectile.client_data.light_level = 10;
        projectile.client_data.travel_particles = new ParticleBatch[]{new ParticleBatch(SPELL_ASCEND.toString(), ParticleBatch.Shape.CIRCLE, ParticleBatch.Origin.CENTER, ParticleBatch.Rotation.LOOK, 1.0f, 0.05f, 0.1f, 0.0f, 0.0f).color(CHAIN_REACTION_COLOR.toRGBA())};
        projectile.client_data.model = new Spell.ProjectileModel();
        projectile.client_data.model.model_id = ArsenalProjectiles.missile.id().toString();
        projectile.client_data.model.scale = 0.5f;
        spell.deliver.projectile.projectile = projectile;
        Spell.Impact damage = ArsenalSpells.damageImpact(0.5f, 0.25f);
        damage.action.min_power = 7.0f;
        damage.particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.MagicParticles.get((SpellEngineParticles.MagicParticles.Shape)SpellEngineParticles.MagicParticles.Shape.ARCANE, (SpellEngineParticles.MagicParticles.Motion)SpellEngineParticles.MagicParticles.Motion.BURST).id().toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, null, 20.0f, 0.2f, 0.7f, 0.0f, 0.0f).color(CHAIN_REACTION_COLOR.toRGBA())};
        damage.sound = new Sound(ArsenalSounds.missile_impact.id().toString());
        spell.impacts = List.of(damage);
        ArsenalSpells.configureCooldown(spell, 1.0f);
        return new Entry(id, spell, title, description, null, EnumSet.of(Category.SPELL, Category.HEAL));
    }

    private static Entry guardian_heal() {
        float threshold = 0.5f;
        int duration = 6;
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"arsenal", (String)"guardian_heal");
        String title = "Guardian Remedy";
        String description = "Healing targets under {threshold} health grants them a temporary absorption shield, lasting {effect_duration} seconds.";
        SpellTooltip.DescriptionMutator mutator = args -> args.description().replace("{threshold}", SpellTooltip.percent((float)threshold));
        Spell spell = ArsenalSpells.passiveSpellBase();
        spell.school = SpellSchools.HEALING;
        Spell.Trigger trigger = new Spell.Trigger();
        trigger.stage = Spell.Trigger.Stage.PRE;
        trigger.type = Spell.Trigger.Type.SPELL_IMPACT_SPECIFIC;
        trigger.impact = new Spell.Trigger.ImpactCondition();
        trigger.impact.impact_type = Spell.Impact.Action.Type.HEAL.toString();
        trigger.spell = new Spell.Trigger.SpellCondition();
        trigger.spell.type = Spell.Type.ACTIVE;
        trigger.target_conditions = List.of(ArsenalSpells.weakCondition());
        spell.passive.triggers = List.of(trigger);
        spell.target.type = Spell.Target.Type.FROM_TRIGGER;
        Spell.Impact effect = ArsenalSpells.createEffectImpact(ArsenalEffects.ABSORPTION.id.toString(), duration);
        effect.action.status_effect.apply_mode = Spell.Impact.Action.StatusEffect.ApplyMode.SET;
        effect.action.status_effect.amplifier_power_multiplier = 0.2f;
        effect.particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.area_circle_1.id().toString(), ParticleBatch.Shape.LINE_VERTICAL, ParticleBatch.Origin.FEET, 1.0f, 0.2f, 0.2f).followEntity(true).scale(0.8f).maxAge(0.4f).color(Color.HOLY.toRGBA()), new ParticleBatch(SpellEngineParticles.area_effect_714.id().toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.GROUND, 1.0f, 0.0f, 0.0f).color(Color.HOLY.toRGBA())};
        effect.sound = new Sound(ArsenalSounds.guardian_heal_impact.id().toString());
        spell.impacts = List.of(effect);
        ArsenalSpells.configureCooldown(spell, duration);
        spell.cost.batching = true;
        return new Entry(id, spell, title, description, mutator, Category.HEAL);
    }

    private static Entry cooldown_heal() {
        float threshold = 0.5f;
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"arsenal", (String)"cooldown_heal");
        String title = "Cooldown Touch";
        String description = "Healing targets under {threshold} health, has {trigger_chance} chance to reset your spell cooldowns.";
        SpellTooltip.DescriptionMutator mutator = args -> args.description().replace("{threshold}", SpellTooltip.percent((float)threshold));
        Spell spell = ArsenalSpells.passiveSpellBase();
        spell.school = SpellSchools.HEALING;
        Spell.Trigger trigger = new Spell.Trigger();
        trigger.stage = Spell.Trigger.Stage.PRE;
        trigger.type = Spell.Trigger.Type.SPELL_IMPACT_SPECIFIC;
        trigger.impact = new Spell.Trigger.ImpactCondition();
        trigger.impact.impact_type = Spell.Impact.Action.Type.HEAL.toString();
        trigger.target_conditions = List.of(ArsenalSpells.weakCondition());
        trigger.chance = 0.5f;
        trigger.target_override = Spell.Trigger.TargetSelector.CASTER;
        spell.passive.triggers = List.of(trigger);
        spell.target.type = Spell.Target.Type.FROM_TRIGGER;
        spell.deliver.delay = 1;
        Spell.Impact impact = new Spell.Impact();
        impact.action = new Spell.Impact.Action();
        impact.action.type = Spell.Impact.Action.Type.COOLDOWN;
        impact.action.cooldown = new Spell.Impact.Action.Cooldown();
        impact.action.cooldown.actives = new Spell.Impact.Action.Cooldown.Modify();
        impact.action.cooldown.actives.duration_multiplier = 0.0f;
        impact.particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.sign_hourglass.id().toString(), ParticleBatch.Shape.LINE_VERTICAL, ParticleBatch.Origin.CENTER, 1.0f, 0.75f, 0.75f).scale(0.8f).color(COOLDOWN_HEAL_COLOR.toRGBA()).followEntity(true), new ParticleBatch(SPARK_DECELERATE.toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 40.0f, 0.3f, 0.3f).color(COOLDOWN_HEAL_COLOR.toRGBA())};
        impact.sound = new Sound(ArsenalSounds.spell_cooldown_impact.id().toString());
        spell.impacts = List.of(impact);
        ArsenalSpells.configureCooldown(spell, 30.0f);
        return new Entry(id, spell, title, description, mutator, Category.HEAL);
    }

    public record Entry(ResourceLocation id, Spell spell, String title, String description, @Nullable SpellTooltip.DescriptionMutator mutator, EnumSet<Category> categories) {
        public Entry(ResourceLocation id, Spell spell, String title, String description, @Nullable SpellTooltip.DescriptionMutator mutator, Category category) {
            this(id, spell, title, description, mutator, EnumSet.of(category));
        }
    }

    public static enum Category {
        MELEE,
        RANGED,
        SPELL,
        HEAL,
        SHIELD;

    }
}

