/*
 * Decompiled with CFR 0.152.
 */
package net.fabric_extras.ranged_weapon.client;

import com.ibm.icu.text.DecimalFormat;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class TooltipUtil {
    public static void addPullTime(ItemStack itemStack, List<Component> lines) {
        int lastAttributeLine;
        int pullTime = TooltipUtil.readablePullTime(itemStack);
        if (pullTime > 0 && (lastAttributeLine = TooltipUtil.getLastAttributeLine(lines)) > 0) {
            lines.add(lastAttributeLine + 1, (Component)Component.literal((String)" ").append((Component)Component.translatable((String)"item.ranged_weapon.pull_time", (Object[])new Object[]{TooltipUtil.formattedNumber((float)pullTime / 20.0f)}).withStyle(ChatFormatting.DARK_GREEN)));
        }
    }

    private static int getLastAttributeLine(List<Component> lines) {
        int lastAttributeLine = -1;
        String attributePrefix = "attribute.modifier";
        String handPrefix = "item.modifiers";
        for (int i = 0; i < lines.size(); ++i) {
            TranslatableContents translatableText;
            String key;
            Component line = lines.get(i);
            ComponentContents content = line.getContents();
            if (!(content instanceof TranslatableContents) || !(key = (translatableText = (TranslatableContents)content).getKey()).startsWith(attributePrefix) && !key.startsWith(handPrefix)) continue;
            lastAttributeLine = i;
        }
        return lastAttributeLine;
    }

    private static int readablePullTime(ItemStack itemStack) {
        Item item = itemStack.getItem();
        double pullTime = 0.0;
        return (int)pullTime;
    }

    private static String formattedNumber(float number) {
        DecimalFormat formatter = new DecimalFormat();
        formatter.setMaximumFractionDigits(1);
        return formatter.format((double)number);
    }
}

