/*
 * Decompiled with CFR 0.152.
 */
package net.fabric_extras.ranged_weapon.mixin.item;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import net.fabric_extras.ranged_weapon.api.EntityAttributes_RangedWeapon;
import net.fabric_extras.ranged_weapon.api.RangedConfig;
import net.fabric_extras.ranged_weapon.internal.RangedItemSettings;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={BowItem.class})
public class BowItemMixin {
    public float getPullProgress_RWA(int useTicks, LivingEntity user) {
        double pullTime = user.getAttributeValue(EntityAttributes_RangedWeapon.PULL_TIME.entry);
        long pullTimeTicks = Math.round(pullTime * 20.0);
        float f = (float)useTicks / (float)pullTimeTicks;
        if ((f = (f * f + f * 2.0f) / 3.0f) > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    @ModifyVariable(method={"<init>(Lnet/minecraft/world/item/Item$Properties;)V"}, at=@At(value="HEAD"), ordinal=0)
    private static Item.Properties applyDefaultAttributes(Item.Properties settings) {
        if (((RangedItemSettings)settings).getRangedAttributes() == null) {
            return ((RangedItemSettings)settings).rangedAttributes(RangedConfig.BOW);
        }
        return settings;
    }

    @WrapOperation(method={"releaseUsing(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/LivingEntity;I)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/BowItem;getPowerForTime(I)F")})
    private float applyCustomPullTime(int ticks, Operation<Float> original, ItemStack stack, Level world, LivingEntity user, int remainingUseTicks) {
        return this.getPullProgress_RWA(ticks, user);
    }
}

