/*
 * Decompiled with CFR 0.152.
 */
package net.fabric_extras.ranged_weapon.mixin.item;

import net.fabric_extras.ranged_weapon.api.CustomRangedWeapon;
import net.fabric_extras.ranged_weapon.api.EntityAttributes_RangedWeapon;
import net.fabric_extras.ranged_weapon.api.RangedConfig;
import net.fabric_extras.ranged_weapon.internal.RangedItemSettings;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CrossbowItem.class})
public class CrossbowItemMixin {
    @ModifyVariable(method={"<init>(Lnet/minecraft/world/item/Item$Properties;)V"}, at=@At(value="HEAD"), ordinal=0)
    private static Item.Properties applyDefaultAttributes(Item.Properties settings) {
        if (((RangedItemSettings)settings).getRangedAttributes() == null) {
            return ((RangedItemSettings)settings).rangedAttributes(RangedConfig.CROSSBOW);
        }
        return settings;
    }

    @Inject(method={"<init>(Lnet/minecraft/world/item/Item$Properties;)V"}, at={@At(value="TAIL")})
    private void postInit(Item.Properties settings, CallbackInfo ci) {
        ((CustomRangedWeapon)((Object)this)).setTypeBaseline(RangedConfig.CROSSBOW);
    }

    @Inject(method={"getChargeDuration(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/entity/LivingEntity;)I"}, at={@At(value="HEAD")}, cancellable=true)
    private static void applyCustomPullTime_RWA(ItemStack stack, LivingEntity user, CallbackInfoReturnable<Integer> cir) {
        Item item = stack.getItem();
        if (item instanceof CustomRangedWeapon) {
            CustomRangedWeapon weapon = (CustomRangedWeapon)item;
            float pullTime = (float)user.getAttributeValue(EntityAttributes_RangedWeapon.PULL_TIME.entry);
            float f = EnchantmentHelper.modifyCrossbowChargingTime((ItemStack)stack, (LivingEntity)user, (float)pullTime);
            int pullTimeTicks = Mth.floor((float)(f * 20.0f));
            cir.setReturnValue((Object)pullTimeTicks);
            cir.cancel();
        }
    }
}

