/*
 * Decompiled with CFR 0.152.
 */
package net.arsenal.item;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.arsenal.item.Group;
import net.arsenal.item.Loot;
import net.arsenal.spell.ArsenalSounds;
import net.arsenal.spell.ArsenalSpells;
import net.fabric_extras.shield_api.item.CustomShieldItem;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.class_1322;
import net.minecraft.class_156;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1814;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3545;
import net.minecraft.class_7923;
import net.minecraft.class_9285;
import net.spell_engine.api.config.AttributeModifier;
import net.spell_engine.api.config.ShieldConfig;
import net.spell_engine.api.item.Equipment;
import net.spell_engine.api.item.Tiers;
import net.spell_engine.api.item.weapon.Weapon;
import net.spell_engine.api.spell.SpellDataComponents;
import net.spell_engine.api.spell.container.SpellContainerHelper;

public class ArsenalShields {
    public static final ArrayList<Entry> entries = new ArrayList();
    private static final String GENERIC_ARMOR_TOUGHNESS = "minecraft:generic.armor_toughness";
    private static final String GENERIC_MAX_HEALTH = "generic.max_health";
    private static final int durability_t0 = 168;
    private static final int durability_t1 = 336;
    private static final int durability_t2 = 672;
    private static final int durability_t3 = 1344;
    private static final int durability_t4 = 4032;
    public static Entry unique_shield_1 = ArsenalShields.shield("unique_shield_1", () -> class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_22021}), List.of(new AttributeModifier("minecraft:generic.armor_toughness", 2.0f, class_1322.class_1323.field_6328), new AttributeModifier("generic.max_health", 6.0f, class_1322.class_1323.field_6328)), 4032).translatedName("Bulwark of Azzinoth").spell(ArsenalSpells.spiked_shield.id()).loot(5, Loot.Theme.EVIL.toString());
    public static Entry unique_shield_2 = ArsenalShields.shield("unique_shield_2", () -> class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8773}), List.of(new AttributeModifier("minecraft:generic.armor_toughness", 2.0f, class_1322.class_1323.field_6328), new AttributeModifier("generic.max_health", 6.0f, class_1322.class_1323.field_6328)), 4032).translatedName("Bastion of Light").spell(ArsenalSpells.guarding_shield.id()).loot(5, Loot.Theme.GENERIC.toString());
    public static Entry unique_shield_sw = ArsenalShields.shield("unique_shield_sw", () -> class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8494}), List.of(new AttributeModifier("minecraft:generic.armor_toughness", 2.0f, class_1322.class_1323.field_6328), new AttributeModifier("generic.max_health", 6.0f, class_1322.class_1323.field_6328)), 4032).translatedName("Sword Breaker's Bulwark").spell(ArsenalSpells.unyielding_shield.id()).loot(5, Loot.Theme.ELVEN.toString());

    private static Supplier<class_1856> ingredient(String idString, boolean requirement, class_1792 fallback) {
        class_2960 id = class_2960.method_60654((String)idString);
        if (requirement) {
            return () -> class_1856.method_8091((class_1935[])new class_1935[]{fallback});
        }
        return () -> {
            class_1792 item = (class_1792)class_7923.field_41178.method_10223(id);
            class_1792 ingredient = item != null ? item : fallback;
            return class_1856.method_8091((class_1935[])new class_1935[]{ingredient});
        };
    }

    public static Entry shield(String name, Supplier<class_1856> repair, List<AttributeModifier> attributes, int durability) {
        Entry entry = new Entry(class_2960.method_60655((String)"arsenal", (String)name), repair, attributes, durability);
        entry.lootProperties = Equipment.LootProperties.of((int)5);
        entries.add(entry);
        return entry;
    }

    public static void register(Map<String, ShieldConfig> configs) {
        int netheriteTier = Tiers.unsafe((String)"netherite");
        ArrayList<CustomShieldItem> shields = new ArrayList<CustomShieldItem>();
        for (Entry entry : entries) {
            ShieldConfig config = configs.get(entry.id.toString());
            if (config == null) {
                config = new ShieldConfig();
                config.durability = entry.durability;
                config.attributes = entry.attributes;
                configs.put(entry.id.toString(), config);
            }
            ArrayList<class_3545> shieldAttributes = new ArrayList<class_3545>();
            for (class_9285.class_9287 modifier : Weapon.attributesFrom((List)config.attributes).comp_2393()) {
                shieldAttributes.add(new class_3545((Object)modifier.comp_2395(), (Object)modifier.comp_2396()));
            }
            class_1792.class_1793 settings = new class_1792.class_1793().method_7895(config.durability);
            int tier = Tiers.unsafe((class_2960)entry.id());
            if (tier >= netheriteTier) {
                settings.method_24359();
            }
            if (entry.rarity != class_1814.field_8906) {
                settings.method_7894(entry.rarity);
            }
            if (entry.spells != null) {
                settings.method_57349(SpellDataComponents.SPELL_CONTAINER, (Object)SpellContainerHelper.createForShield(entry.spells));
            }
            CustomShieldItem shield = new CustomShieldItem(ArsenalSounds.shield_equip.entry(), entry.repair, shieldAttributes, settings);
            class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)entry.id, (Object)shield);
            shields.add(shield);
        }
        ItemGroupEvents.modifyEntriesEvent(Group.KEY).register(content -> {
            for (class_1792 shield : shields) {
                content.method_45421((class_1935)shield);
            }
        });
    }

    static {
        for (Entry entry : entries) {
            entry.rarity = class_1814.field_8903;
        }
    }

    public static final class Entry {
        private final class_2960 id;
        private final Supplier<class_1856> repair;
        private final List<AttributeModifier> attributes;
        private final int durability;
        private String translatedName = "";
        public class_1814 rarity = class_1814.field_8906;
        public List<class_2960> spells = null;
        public Equipment.LootProperties lootProperties = Equipment.LootProperties.EMPTY;

        public Entry(class_2960 id, Supplier<class_1856> repair, List<AttributeModifier> attributes, int durability) {
            this.id = id;
            this.repair = repair;
            this.attributes = attributes;
            this.durability = durability;
        }

        public class_2960 id() {
            return this.id;
        }

        public Supplier<class_1856> repair() {
            return this.repair;
        }

        public List<AttributeModifier> attributes() {
            return this.attributes;
        }

        public int durability() {
            return this.durability;
        }

        public Entry translatedName(String translatedName) {
            this.translatedName = translatedName;
            return this;
        }

        public String translatedName() {
            return this.translatedName;
        }

        public String translationKey() {
            return class_156.method_646((String)"item", (class_2960)this.id());
        }

        public Entry spell(class_2960 spellId) {
            this.spells = List.of(spellId);
            return this;
        }

        public Entry loot(int tier, String theme) {
            this.lootProperties = Equipment.LootProperties.of((int)tier, (String)theme);
            return this;
        }
    }
}

